/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ClientSocketConnection;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class SocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response>
implements ClientSocketConnection<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.SocketConnectionImpl");
    private static final int MAX_CONNECTION_ATTEMPTS = 60;
    private static final int CONNECTION_ATTEMPT_DELAY = 500;
    private final InetAddress myHost;
    private final int myInitialPort;
    private final int myPortsNumberToTry;

    public SocketConnectionImpl(InetAddress host, int initialPort, int portsNumberToTry, @NotNull RequestResponseExternalizerFactory<Request, Response> requestResponseRequestResponseExternalizerFactory) {
        if (requestResponseRequestResponseExternalizerFactory == null) {
            SocketConnectionImpl.$$$reportNull$$$0(0);
        }
        super(requestResponseRequestResponseExternalizerFactory);
        this.myHost = host;
        this.myInitialPort = initialPort;
        this.myPortsNumberToTry = portsNumberToTry;
    }

    @Override
    public void open() throws IOException {
        Socket socket = this.createSocket();
        this.setPort(socket.getPort());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.attachToSocket(socket);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e.getMessage());
            }
        });
    }

    @NotNull
    private Socket createSocket() throws IOException {
        InetAddress host = this.myHost;
        if (host == null) {
            try {
                host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException ignored) {
                host = InetAddress.getLoopbackAddress();
            }
        }
        IOException exc = null;
        for (int i = 0; i < this.myPortsNumberToTry; ++i) {
            Socket socket;
            block6: {
                int port = this.myInitialPort + i;
                try {
                    socket = new Socket(host, port);
                    if (socket != null) break block6;
                }
                catch (IOException e) {
                    exc = e;
                    LOG.debug((Throwable)e);
                    continue;
                }
                SocketConnectionImpl.$$$reportNull$$$0(1);
            }
            return socket;
        }
        throw exc;
    }

    public void connect() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Exception exception = null;
            InetAddress host = this.myHost;
            if (host == null) {
                host = InetAddress.getLoopbackAddress();
            }
            for (int attempt = 0; attempt < 60; ++attempt) {
                for (int i = 0; i < this.myPortsNumberToTry; ++i) {
                    Socket socket;
                    try {
                        socket = new Socket(host, this.myInitialPort + i);
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        exception = e;
                        continue;
                    }
                    this.setPort(socket.getPort());
                    try {
                        this.attachToSocket(socket);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                    return;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    exception = e;
                    break;
                }
            }
            this.setStatus(ConnectionStatus.CONNECTION_FAILED, exception == null ? "Connection failed" : "Connection failed: " + exception.getMessage());
        });
    }

    @Override
    public void startPolling() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.addThreadToInterrupt();
            try {
                for (int attempt = 0; attempt < 60; ++attempt) {
                    try {
                        this.open();
                        return;
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        Thread.sleep(500L);
                        continue;
                    }
                }
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Cannot connect to " + (this.myHost != null ? this.myHost : "localhost") + ", the maximum number of connection attempts exceeded");
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.removeThreadToInterrupt();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestResponseRequestResponseExternalizerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSocket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

