/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceInspection
extends JsonSchemaBasedInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = JsonBundle.message("json.schema.ref.refs.inspection.name", new Object[0]);
        if (string == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull JsonValue root, @Nullable JsonSchemaObject schema, @NotNull JsonSchemaService service2, final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
        if (root == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(1);
        }
        if (service2 == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(3);
        }
        if (session2 == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(4);
        }
        final boolean checkRefs = schema != null && service2.isSchemaFile(schema.getSchemaFile());
        return new JsonElementVisitor(){

            public void visitElement(PsiElement element) {
                JsonProperty schemaProp;
                if (element == root && element instanceof JsonObject && (schemaProp = ((JsonObject)element).findProperty("$schema")) != null) {
                    this.doCheck(schemaProp.getValue());
                }
                super.visitElement(element);
            }

            @Override
            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!checkRefs) {
                    return;
                }
                if ("$ref".equals(o.getName())) {
                    this.doCheck(o.getValue());
                }
                super.visitProperty(o);
            }

            private void doCheck(JsonValue value) {
                if (!(value instanceof JsonStringLiteral)) {
                    return;
                }
                for (PsiReference reference2 : value.getReferences()) {
                    PsiElement resolved;
                    if (reference2 instanceof WebReference || (resolved = reference2.resolve()) != null) continue;
                    holder.registerProblem(reference2, this.getReferenceErrorDesc(reference2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private String getReferenceErrorDesc(PsiReference reference2) {
                String text = reference2.getCanonicalText();
                if (reference2 instanceof FileReference) {
                    int hash = text.indexOf(35);
                    return JsonBundle.message("json.schema.ref.file.not.found", hash == -1 ? text : text.substring(0, hash));
                }
                if (reference2 instanceof JsonPointerReferenceProvider.JsonSchemaIdReference) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.id", text);
                }
                int lastSlash = text.lastIndexOf(47);
                if (lastSlash == -1) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.path", text);
                }
                String substring = text.substring(text.lastIndexOf(47) + 1);
                try {
                    Integer.parseInt(substring);
                    return JsonBundle.message("json.schema.ref.no.array.element", substring);
                }
                catch (Exception e) {
                    return JsonBundle.message("json.schema.ref.no.property", substring);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaRefReferenceInspection$1", "visitProperty"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaRefReferenceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaRefReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

