/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.view.ui.MultiSeparatorListCellRenderer;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.roots.ui.configuration.SidePanelSeparator;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSidePanel {
    private final JList<Place> myList;
    private final DefaultListModel<Place> myModel;
    private final List<Pair<String, Integer>> mySeparators;
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final ListWithFilter myListWithFilter;
    private final MyGroupedItemsListRenderer myRenderer;
    private final JScrollPane myScroll;

    public DataSourceSidePanel(ComponentConfigurator componentConfigurator, Function<Place, String> filterSupplier) {
        this.mySeparators = ContainerUtil.newArrayList();
        this.myModel = new DefaultListModel();
        this.myList = new JBList(this.myModel);
        this.myScroll = ScrollPaneFactory.createScrollPane(this.myList, (boolean)true);
        this.myScroll.setCorner("LOWER_RIGHT_CORNER", null);
        this.myScroll.setCorner("LOWER_LEFT_CORNER", null);
        this.myScroll.setCorner("UPPER_RIGHT_CORNER", null);
        this.myScroll.setCorner("UPPER_LEFT_CORNER", null);
        this.myList.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myRenderer = new MyGroupedItemsListRenderer(this.myList, componentConfigurator);
        this.myList.setCellRenderer(this.myRenderer);
        this.myList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index2;
                if (SwingUtilities.isRightMouseButton(e) && (index2 = DataSourceSidePanel.this.myList.locationToIndex(e.getPoint())) != -1 && !DataSourceSidePanel.this.myList.isSelectedIndex(index2)) {
                    DataSourceSidePanel.this.myList.setSelectedIndex(index2);
                }
                super.mousePressed(e);
            }
        });
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap(this.myList, (JScrollPane)this.myScroll, o -> {
            Place place = (Place)ObjectUtils.tryCast((Object)o, Place.class);
            return place == null ? null : (String)filterSupplier.fun((Object)place);
        });
        this.myPanel.add((Component)this.myListWithFilter, "Center");
        this.myList.setSelectionMode(2);
        UIUtil.setBackgroundRecursively((Component)this.myPanel, (Color)UIUtil.SIDE_PANEL_BACKGROUND);
    }

    public int getItemWidth(Place place) {
        JComponent component = this.myRenderer.getItemCellRendererComponent(this.myList, place, -1, true, true);
        this.myList.add(component);
        if (component instanceof CellRendererPanel) {
            ((CellRendererPanel)component).forceInvalidate();
        } else {
            component.invalidate();
        }
        int width = (int)component.getPreferredSize().getWidth();
        this.myList.remove(component);
        return width;
    }

    public void setMinimumWidth(int w) {
        this.myScroll.getViewport().setMinimumSize(new Dimension(w, -1));
    }

    public JList<Place> getList() {
        return this.myList;
    }

    public void addPlace(Place place) {
        this.myModel.addElement(place);
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    public void clear() {
        this.myModel.clear();
        this.mySeparators.clear();
    }

    public Matcher getSpeedSearchMatcher() {
        return this.myListWithFilter.getSpeedSearch().getMatcher();
    }

    public void addSeparator(@NotNull String text2) {
        if (text2 == null) {
            DataSourceSidePanel.$$$reportNull$$$0(0);
        }
        this.mySeparators.add((Pair<String, Integer>)Pair.create((Object)text2, (Object)this.myModel.size()));
    }

    public void select(Place place) {
        this.myList.setSelectedValue(place, true);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/ui/DataSourceSidePanel", "addSeparator"));
    }

    private class MyGroupedItemsListRenderer
    extends MultiSeparatorListCellRenderer<Place> {
        private final SidePanelCountLabel myCountLabel;
        private final ComponentConfigurator myConfigurator;
        private final JLabel myIconComponent;
        private final CellRendererPanel myItemComponent;
        private final SimpleColoredComponent myTextComponent;
        private final Component mySpacer;
        private final Icon myEmptyIcon;

        MyGroupedItemsListRenderer(@NotNull JList<Place> list, ComponentConfigurator configurator) {
            if (configurator == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(0);
            }
            super(list);
            this.myCountLabel = new SidePanelCountLabel();
            this.myIconComponent = new JLabel();
            this.myItemComponent = new CellRendererPanel();
            this.myTextComponent = new SimpleColoredComponent();
            this.mySpacer = Box.createHorizontalGlue();
            this.myEmptyIcon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16, (int)16));
            this.myConfigurator = configurator;
            this.myIconComponent.setBorder((Border)JBUI.Borders.empty((int)0, (int)15, (int)0, (int)3));
            this.myItemComponent.setLayout((LayoutManager)new BoxLayout((Container)this.myItemComponent, 0));
            this.myItemComponent.add((Component)this.myIconComponent);
            this.myItemComponent.add((Component)this.myTextComponent);
            this.myItemComponent.add((Component)this.myCountLabel);
            this.myItemComponent.add(this.mySpacer);
            this.myItemComponent.setAlignmentX(0.0f);
            this.myTextComponent.setBorder(JBUI.Borders.empty((int)2));
        }

        @Override
        @NotNull
        protected SeparatorWithText createSeparator() {
            SidePanelSeparator separator = new SidePanelSeparator(){

                public Dimension getMaximumSize() {
                    Dimension size = super.getMaximumSize();
                    return new Dimension(MyGroupedItemsListRenderer.this.getViewableWidth(), (int)size.getHeight());
                }

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    return new Dimension(size.width, (int)((double)size.height * 1.5));
                }
            };
            separator.setAlignmentX(0.0f);
            SidePanelSeparator sidePanelSeparator = separator;
            if (sidePanelSeparator == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(1);
            }
            return sidePanelSeparator;
        }

        List<Object> merge(boolean fromBeginning, List<Object> separators) {
            if (separators.size() > 1) {
                Object last = separators.get(separators.size() - 1);
                if (!last.equals("--")) {
                    Object preLast = separators.get(separators.size() - 2);
                    if (!fromBeginning && preLast.equals("--") && !last.equals("---")) {
                        return Arrays.asList("--", this.canonize(last));
                    }
                    return Collections.singletonList(this.canonize(last));
                }
                for (int i2 = separators.size() - 2; i2 >= 0; --i2) {
                    Object sep = separators.get(i2);
                    if (sep.equals("--")) continue;
                    return Collections.singletonList(this.canonize(sep));
                }
                return Collections.singletonList(this.canonize(last));
            }
            return separators;
        }

        @Override
        public Collection<Object> querySeparators(@Nullable Place from, @NotNull Place to) {
            if (to == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(2);
            }
            int fromIdx = DataSourceSidePanel.this.myModel.indexOf(from);
            int toIdx = DataSourceSidePanel.this.myModel.indexOf(to);
            if (toIdx < 0) {
                toIdx = DataSourceSidePanel.this.myModel.size();
            }
            assert (fromIdx <= toIdx);
            List<Object> separators = ContainerUtil.newArrayList();
            for (Pair separator : DataSourceSidePanel.this.mySeparators) {
                if ((Integer)separator.getSecond() <= fromIdx || (Integer)separator.getSecond() > toIdx) continue;
                separators.add(separator.getFirst());
            }
            separators = this.merge(from == null, separators);
            if (!separators.isEmpty() && separators.get(separators.size() - 1).equals("--") && from == null) {
                return Collections.emptyList();
            }
            return separators;
        }

        private Object canonize(Object s) {
            return s.equals("---") ? "--" : s;
        }

        @Override
        public void configureSeparator(@NotNull SeparatorWithText component, @NotNull Object separator) {
            if (component == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(3);
            }
            if (separator == null) {
                MyGroupedItemsListRenderer.$$$reportNull$$$0(4);
            }
            component.setCaption(String.valueOf(this.canonize(separator)));
        }

        @Override
        protected JComponent getItemCellRendererComponent(JList<? extends Place> list, Place value, int index2, boolean isSelected, boolean focus) {
            Color bg = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.SIDE_PANEL_BACKGROUND;
            Color fg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getLabelForeground();
            this.myCountLabel.setVisible(false);
            this.myTextComponent.clear();
            this.myTextComponent.setBackground(bg);
            this.myTextComponent.setForeground(fg);
            this.myConfigurator.configure(this.myTextComponent, value, isSelected);
            this.myConfigurator.updateCount(this.myCountLabel, value);
            this.myIconComponent.setIcon((Icon)ObjectUtils.chooseNotNull((Object)this.myTextComponent.getIcon(), (Object)this.myEmptyIcon));
            this.myTextComponent.setIcon(null);
            this.myTextComponent.setMaximumSize(null);
            this.myTextComponent.setMaximumSize(this.myTextComponent.getPreferredSize());
            this.myCountLabel.setSelected(isSelected);
            this.myItemComponent.setSelected(isSelected);
            this.myItemComponent.setBackground(bg);
            return this.myItemComponent;
        }

        private int getViewableWidth() {
            return (int)DataSourceSidePanel.this.myScroll.getViewport().getExtentSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourceSidePanel$MyGroupedItemsListRenderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourceSidePanel$MyGroupedItemsListRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSeparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "querySeparators";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "configureSeparator";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ComponentConfigurator {
        public void configure(@NotNull SimpleColoredComponent var1, @NotNull Place var2, boolean var3);

        public void updateCount(@NotNull SidePanelCountLabel var1, @NotNull Place var2);
    }
}

