/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sql92.Sql92GeneratedParser;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlParser
implements PsiParser,
LightPsiParser,
SqlElementTypes {
    private static final WhitespacesAndCommentsBinder TRIM_SPACES_RIGHT = new WhitespacesAndCommentsBinder.RecursiveBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return 0;
        }
    };
    private static final WhitespacesAndCommentsBinder ADD_COMMENT_LEFT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            int ws = 0;
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType t = tokens.get(idx);
                if (SqlTokens.COMMENT_TOKENS.contains(t)) {
                    ws = 0;
                    continue;
                }
                if ((ws += StringUtil.countNewLines((CharSequence)getter.get(idx))) <= 1 && idx != 0) continue;
                return idx + 1;
            }
            return 0;
        }
    };
    private static final Pattern PL_PATTERN = Pattern.compile(".*_(?:CREATE|ALTER)_(?:PROCEDURE|FUNCTION|TRIGGER|PACKAGE|VIEW)_.*");
    private final SqlLanguageDialectEx myLanguage;
    protected boolean myExternalReferenceJustParsed;
    private int mySeparatorParsed = -1;
    private boolean myStatementRecoverNewLine;

    protected SqlParser(SqlLanguageDialectEx language) {
        this.myLanguage = language;
    }

    public SqlLanguageDialectEx getLanguage() {
        return this.myLanguage;
    }

    public boolean shouldParseStatementSeparator(PsiBuilder b2) {
        boolean result2 = !this.isStatementSeparatorParsed(b2);
        this.mySeparatorParsed = -1;
        return result2;
    }

    public void statementSeparatorParsed(PsiBuilder b2) {
        b2.eof();
        this.mySeparatorParsed = b2.getCurrentOffset();
    }

    public boolean isStatementSeparatorParsed(PsiBuilder b2) {
        b2.eof();
        return this.mySeparatorParsed == b2.getCurrentOffset();
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root2, @NotNull PsiBuilder builder) {
        if (root2 == null) {
            SqlParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            SqlParser.$$$reportNull$$$0(1);
        }
        this.parseLight(root2, builder);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            SqlParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    public void parseLight(IElementType root2, PsiBuilder initialBuilder) {
        boolean result2;
        PsiBuilder builder = this.adaptBuilder(root2, initialBuilder);
        PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)0, (int)1, null);
        if (root2 instanceof SqlReferenceElementType) {
            result2 = this.parseReferenceExpression(builder, (SqlReferenceElementType)root2);
        } else if (root2 == SqlCompositeElementTypes.SQL_TYPE_ELEMENT) {
            result2 = this.parseDataType(builder, 0, false);
        } else if (root2 == SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT) {
            result2 = this.parseDataTypeExt(builder);
        } else if (root2 == SqlCompositeElementTypes.SQL_QUERY_EXPRESSION) {
            result2 = this.parseQueryExpression(builder, 0);
        } else if (root2 == SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST) {
            result2 = this.parseTableColumnList(builder, 0);
        } else if (root2 == SqlCompositeElementTypes.SQL_EXPRESSION) {
            result2 = this.parseValueExpression(builder, 0, false);
        } else if (root2 == SqlCompositeElementTypes.SQL_STATEMENT) {
            result2 = this.parseSqlStatement(builder, 0);
        } else if (root2 == SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION) {
            result2 = this.parseEvaluableExpression(builder, 0);
        } else if (this.parseJdbcProcedureCall(builder, 0) || this.parseSpecificRoots(root2, builder, 0)) {
            result2 = true;
        } else {
            this.parseScriptDefault(builder);
            result2 = true;
        }
        GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)0, (PsiBuilder.Marker)marker, (IElementType)root2, (boolean)result2, (boolean)true, (GeneratedParserUtilBase.Parser)GeneratedParserUtilBase.TRUE_CONDITION);
    }

    protected boolean parseDataTypeExt(PsiBuilder builder) {
        return this.parseDataType(builder, 0, true) || SqlGeneratedParser.table_type(builder, 0);
    }

    protected boolean parseSpecificRoots(IElementType root2, PsiBuilder builder, int level) {
        return false;
    }

    @NotNull
    public PsiBuilder adaptBuilder(IElementType root2, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = SqlGeneratedParserUtil.adapt_builder_(root2, initialBuilder, this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            SqlParser.$$$reportNull$$$0(3);
        }
        return psiBuilder;
    }

    protected abstract TokenSet[] getExtendsTokenSets();

    public abstract boolean parseQueryExpression(PsiBuilder var1, int var2);

    public abstract boolean parseSqlStatement(PsiBuilder var1, int var2);

    public abstract boolean parseDataType(PsiBuilder var1, int var2, boolean var3);

    public abstract boolean parseValueExpression(PsiBuilder var1, int var2, boolean var3, boolean var4);

    public abstract boolean parseEvaluableExpression(PsiBuilder var1, int var2);

    public boolean parseTableColumnList(PsiBuilder builder, int level) {
        return Sql92GeneratedParser.table_opt_column_list(builder, level);
    }

    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        PsiBuilder.Marker marker = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACE)) {
            boolean refAndEqAlreadyParsed = this.parseParameterOrVariableReference(builder, true) && SqlParserUtil.consumeOneOfTokens(builder, new IElementType[]{SQL_OP_EQ}) != null;
            boolean call = StringUtil.equalsIgnoreCase((CharSequence)builder.getTokenText(), (CharSequence)"call");
            if (call || refAndEqAlreadyParsed) {
                if (call) {
                    builder.advanceLexer();
                }
                if (!this.parseStatementInsideJdbcCall(builder, level)) {
                    this.parseJdbcProcedureCallBody(builder, level + 1, refAndEqAlreadyParsed);
                }
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{null});
                marker.done((IElementType)JDBC_PROCEDURE_CALL);
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_BRACE)) {
            String text2 = builder.getTokenText();
            if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"fn")) {
                builder.advanceLexer();
                SqlGeneratedParser.database_function_call_expression(builder, 0);
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                marker.done((IElementType)ODBC_FUNCTION_CALL);
                return true;
            }
            IElementType type = this.getOdbcTokenType(text2);
            boolean skip = false;
            if (type != null || this.allowAnyIdentifierInOdbc() && (skip = this.consumeIdentifier(builder))) {
                if (!skip) {
                    builder.advanceLexer();
                }
                this.parseValueExpression(builder, 0, false, true);
                SqlParserUtil.tryConsumeToken(builder, new IElementType[]{SQL_RIGHT_BRACE});
                marker.done((IElementType)(type != null ? type : ODBC_GENERIC));
                return true;
            }
        }
        marker.rollbackTo();
        return false;
    }

    @Nullable
    protected IElementType getOdbcTokenType(@Nullable String text2) {
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"fn")) {
            return ODBC_FUNCTION_CALL;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"d")) {
            return ODBC_DATE;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"t")) {
            return ODBC_TIME;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"ts")) {
            return ODBC_TIMESTAMP;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)"escape")) {
            return ODBC_ESCAPE;
        }
        return null;
    }

    protected boolean allowNoStatementSeparator() {
        return false;
    }

    protected boolean allowAnyIdentifierInOdbc() {
        return false;
    }

    protected boolean parseStatementInsideJdbcCall(PsiBuilder builder, int level) {
        return false;
    }

    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed) {
        this.parseJdbcProcedureCallBody(builder, level, refAlreadyParsed, SQL_OP_EQ);
    }

    public void parseJdbcProcedureCallBody(PsiBuilder builder, int level, boolean refAlreadyParsed, SqlTokenType ... tokens) {
        if (!refAlreadyParsed && this.parseParameterOrVariableReference(builder, true)) {
            SqlParserUtil.consumeOneOfTokens(builder, (IElementType[])tokens);
        }
        this.parseJdbcFunctionCallExpression(builder, level);
    }

    public boolean parseJdbcFunctionCallExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParser.database_function_call_expression(builder, level);
    }

    protected void parseScriptDefault(PsiBuilder builder) {
        this.parseStatementBlockBody(builder, true, GeneratedParserUtilBase.TRUE_CONDITION);
    }

    public boolean parseStatementSeparatorAndMark(PsiBuilder builder, boolean mark2) {
        IElementType tokenType = builder.getTokenType();
        if (this.getLanguage().getStatementSeparators().contains(tokenType)) {
            builder.advanceLexer();
            if (mark2) {
                this.statementSeparatorParsed(builder);
            }
            return true;
        }
        return false;
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, boolean allowNoSemicolonForLastStatement, SqlTokenType ... endTokens) {
        return this.parseStatementBlockBody(builder, allowNoSemicolonForLastStatement, SqlParserUtil.newTokenCondition((IElementType[])endTokens));
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, boolean allowNoSemicolonForLastStatement, GeneratedParserUtilBase.Parser endCondition) {
        return this.parseStatementBlockBody(builder, allowNoSemicolonForLastStatement, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                int offset = builder.getCurrentOffset();
                try {
                    SqlParser.this.myStatementRecoverNewLine = false;
                    BranchesCache.get(builder).clear();
                    boolean bl = SqlParser.this.parseSqlStatement(builder, level);
                    return bl;
                }
                catch (StackOverflowError e) {
                    CharSequence text2 = builder.getOriginalText();
                    CharSequence fragment = text2.subSequence(offset, Math.min(text2.length(), builder.getCurrentOffset() + 20));
                    SqlDialectImplUtil.LOG.error(SqlParser.this.getLanguage().getDisplayName() + ": " + fragment, (Throwable)e);
                    throw e;
                }
                finally {
                    SqlParser.this.myStatementRecoverNewLine = false;
                }
            }
        }, endCondition);
    }

    public boolean parseGenericBlockBody(PsiBuilder builder, GeneratedParserUtilBase.Parser nestedParser, GeneratedParserUtilBase.Parser endCondition, GeneratedParserUtilBase.Parser separatorParser, Boolean lastSep, String name) {
        boolean inCompletion = SqlGeneratedParserUtil.isInCompletion(builder, 0);
        builder.eof();
        int currentOffset = builder.getCurrentOffset();
        boolean sepInside = lastSep == null || lastSep == false;
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, (b2, l) -> {
            int offset = b2.getCurrentOffset();
            nestedParser.parse(b2, l);
            if (b2.getCurrentOffset() == offset && !b2.eof()) {
                if (SqlParser.tryParse(b2, l, separatorParser)) {
                    SqlGeneratedParserUtil.report_error_((PsiBuilder)b2, (boolean)false);
                } else {
                    SqlParserUtil.markTokenAsUnexpectedAndAdvance(b2, name);
                }
            }
            if (!sepInside) {
                SqlGeneratedParserUtil.report_error_((PsiBuilder)b2, (boolean)separatorParser.parse(b2, l));
            }
            return inCompletion || !b2.eof();
        }, (b2, l) -> {
            if (!sepInside || b2.getCurrentOffset() == currentOffset) {
                return endCondition.parse(b2, l);
            }
            PsiBuilder.Marker m = b2.mark();
            boolean sep = separatorParser.parse(b2, l);
            boolean goOn = endCondition.parse(b2, l);
            boolean mandatory = goOn || lastSep != null;
            SqlGeneratedParserUtil.report_error_((PsiBuilder)b2, (!mandatory || sep ? 1 : 0) != 0);
            m.drop();
            return goOn;
        });
        return builder.getCurrentOffset() != currentOffset;
    }

    public boolean parseStatementBlockBody(PsiBuilder builder, final boolean allowNoSemicolonForLastStatement, final GeneratedParserUtilBase.Parser nestedParser, GeneratedParserUtilBase.Parser endCondition) {
        final boolean inCompletion = SqlGeneratedParserUtil.isInCompletion(builder, 0);
        int currentOffset = builder.getCurrentOffset();
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                boolean lastFail;
                boolean parsed = false;
                boolean advanced = false;
                if (!SqlParser.this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                    int offset = builder.getCurrentOffset();
                    parsed = nestedParser.parse(builder, level);
                    if (builder.getCurrentOffset() == offset && !builder.eof()) {
                        SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, "<statement>");
                    }
                    advanced = builder.getCurrentOffset() != offset;
                }
                boolean oneMore = false;
                boolean bl = lastFail = !parsed && builder.eof() && advanced;
                if (SqlParser.this.shouldParseStatementSeparator(builder) && !lastFail) {
                    boolean lastStatement = allowNoSemicolonForLastStatement && SqlGeneratedParserUtil.eof((PsiBuilder)builder, (int)level);
                    boolean optional = !parsed || lastStatement;
                    oneMore = SqlParserUtil.consumeOneOfTokens(builder, optional, SqlParser.this.getLanguage().getStatementSeparators().getTypes()) != null;
                } else if (parsed && inCompletion) {
                    oneMore = SqlParserUtil.endsWithNewLine(builder, 1);
                }
                if (!oneMore && advanced && inCompletion && builder.eof()) {
                    oneMore = SqlParserUtil.hasNMeaningfulNewLines(builder, 2);
                }
                if (parsed) {
                    SqlParser.this.applyStatementMarkerBinders(builder);
                }
                return inCompletion && oneMore || !builder.eof();
            }
        }, endCondition);
        return builder.getCurrentOffset() != currentOffset;
    }

    protected boolean parseBatchBlock(PsiBuilder builder, SqlCompositeElementType batchType, SqlTokenType goType) {
        PsiBuilderImpl.ProductionMarker last;
        PsiBuilder.Marker mark2 = builder.mark();
        if (GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)goType)) {
            mark2.drop();
            return !builder.eof();
        }
        boolean blockParsed = this.parseStatementBlockBody(builder, true, goType);
        if (blockParsed && (last = (PsiBuilderImpl.ProductionMarker)builder.getLatestDoneMarker()) != null && last.getStartIndex() <= ((PsiBuilderImpl.ProductionMarker)mark2).getStartIndex()) {
            if (last.getTokenType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
                ((PsiBuilder.Marker)last).drop();
            } else {
                blockParsed = false;
            }
        }
        if (blockParsed) {
            mark2.done((IElementType)batchType);
            mark2.setCustomEdgeTokenBinders(ADD_COMMENT_LEFT, TRIM_SPACES_RIGHT);
        } else {
            mark2.drop();
        }
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)goType) && SqlParserUtil.consumeOptionalToken(builder, (IElementType)goType)) {
            SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_INTEGER_TOKEN);
        }
        return !builder.eof();
    }

    public boolean parseStringLiteral(PsiBuilder builder, int level) {
        boolean checkStringIdentifier = false;
        int start = builder.getCurrentOffset();
        PsiBuilder.Marker marker = builder.mark();
        IElementType resultType = this.parseStringLiteralWithCharsetSpec(builder);
        if (resultType == null && (resultType = this.parseStringLiteralInner(builder)) != null) {
            boolean bl = checkStringIdentifier = resultType == SQL_STRING_LITERAL;
        }
        if (resultType == null || checkStringIdentifier && this.allowStringsAsIdentifiers() && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
            if (start == builder.getCurrentOffset()) {
                marker.drop();
            } else {
                marker.rollbackTo();
            }
            return false;
        }
        marker.done(resultType);
        return true;
    }

    @Nullable
    public IElementType parseStringLiteralInner(PsiBuilder builder) {
        PsiBuilder.Marker mark2;
        boolean first = true;
        boolean allowNoopConcat = this.allowNoopStringConcatenation(builder, true);
        while (true) {
            mark2 = builder.mark();
            boolean param = false;
            boolean r = this.consumeStringToken(builder, true);
            if (!r && (r = (param = this.parseExternalParameterImpl(builder, false, false))) && builder.getTokenType() == SQL_PERIOD) {
                PsiBuilder.Marker precede = mark2.precede();
                mark2.rollbackTo();
                mark2 = precede;
                r = false;
            }
            if (!r) {
                boolean bl = r = !first && SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT_DELIMITED);
            }
            if (!r) break;
            if (first && !(allowNoopConcat &= this.allowNoopStringConcatenation(builder, false)) || param) {
                mark2.drop();
            } else {
                mark2.done((IElementType)SQL_STRING_LITERAL);
            }
            if (!allowNoopConcat) {
                return first ? (param ? null : SQL_STRING_LITERAL) : SQL_STRING_LITERAL_CONCATENATION;
            }
            first = false;
        }
        mark2.drop();
        return null;
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        if (SqlGeneratedParserUtil.isExternalParameterFirst(builder.getTokenType())) {
            return true;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            return false;
        }
        String text2 = builder.getTokenText();
        return text2 != null && (StringUtil.startsWith((CharSequence)text2, (CharSequence)"'") || first && StringUtil.startsWithIgnoreCase((String)text2, (String)"n"));
    }

    @Nullable
    protected IElementType parseStringLiteralWithCharsetSpec(PsiBuilder builder) {
        IElementType nextToken;
        PsiBuilder.Marker mark2 = builder.mark();
        if (!this.consumeUnderscoreAndCharSpec(builder)) {
            mark2.drop();
            return null;
        }
        SqlLanguageDialectEx language = this.getLanguage();
        IElementType result2 = null;
        SqlCompositeElementType parsed = null;
        if (language.supportsSql92CharSetSpecFor((IElementType)SQL_STRING_LITERAL) && (nextToken = builder.getTokenType()) != SQL_IDENT_DELIMITED) {
            result2 = this.parseStringLiteralInner(builder);
            parsed = SQL_STRING_LITERAL;
        }
        if (result2 == null && language.supportsSql92CharSetSpecFor((IElementType)SQL_PARAMETER_REFERENCE) && this.parseParameterOrVariableReference(builder, true)) {
            result2 = SQL_STRING_LITERAL;
        }
        if (result2 == null && language.supportsSql92CharSetSpecFor((IElementType)SQL_NUMERIC_LITERAL) && SqlGeneratedParserUtil.parseNumber(builder, 0)) {
            result2 = SQL_STRING_LITERAL;
        }
        if (result2 != null) {
            if (parsed == null) {
                LighterASTNode last = builder.getLatestDoneMarker();
                IElementType iElementType = parsed = last == null ? null : last.getTokenType();
            }
            if (parsed == null || !language.supportsSql92CharSetSpecFor((IElementType)parsed)) {
                result2 = null;
            }
        }
        if (result2 == null) {
            mark2.rollbackTo();
        } else {
            mark2.drop();
        }
        return result2;
    }

    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        if (SqlGeneratedParserUtil.eof((PsiBuilder)builder, (int)0)) {
            return false;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == SQL_UNDERSCORE) {
            builder.advanceLexer();
            return this.parseCharacterSetSpec(builder);
        }
        if (tokenType == SQL_IDENT) {
            String tokenText = builder.getTokenText();
            if (tokenText == null || tokenText.length() == 0 || tokenText.charAt(0) != '_') {
                return false;
            }
            return this.parseCharacterSetSpec(builder);
        }
        return false;
    }

    public boolean parseNullOrStringLiteral(PsiBuilder builder) {
        PsiBuilder.Marker m = builder.mark();
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_NULL)) {
            m.done((IElementType)SQL_SPECIAL_LITERAL);
            return true;
        }
        m.drop();
        return this.parseStringLiteral(builder, 0);
    }

    public boolean parseStringLiteralOrParameter(PsiBuilder builder) {
        return this.parseNullOrStringLiteral(builder) || this.parseParameterOrVariableReference(builder, true);
    }

    public boolean parseNumberLiteralOrParameter(PsiBuilder builder, boolean allowFloat) {
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_NULL)) {
            return true;
        }
        if (this.parseParameterOrVariableReference(builder, true)) {
            return true;
        }
        return SqlParser.parseInteger(builder, allowFloat);
    }

    public boolean consumeStringToken(PsiBuilder builder, boolean optional) {
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_CUSTOM_LQUOTE)) {
            while (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_CUSTOM_QUOTED_STRING_TOKEN) || this.parseExternalParameterImpl(builder, true, true)) {
            }
            if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_UNCLOSED_TOKEN)) {
                return true;
            }
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_CUSTOM_RQUOTE);
            return true;
        }
        if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_UNCLOSED_TOKEN)) {
            return true;
        }
        return SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_STRING_TOKEN);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, false, refType);
    }

    public boolean parseReferenceExpression(PsiBuilder builder, boolean optional, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, optional, refType);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, SqlReferenceElementType refType) {
        return this.parseReferenceExpressionInner(builder, optional, !optional, refType);
    }

    public boolean parseReferenceExpressionOrVariable(PsiBuilder builder, SqlReferenceElementType refType) {
        if ((refType == SQL_VARIABLE_REFERENCE || this.getVariableType(builder) != null) && refType != SQL_OPERATOR_REFERENCE) {
            return this.parseParameterOrVariableReference(builder, false);
        }
        return this.parseReferenceExpressionInner(builder, true, true, refType);
    }

    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        IElementType paramToken = builder.getTokenType();
        if (this.getLanguage().isOperatorSupported(paramToken)) {
            return null;
        }
        if (paramToken == SQL_COLON) {
            return SQL_PARAMETER_REFERENCE;
        }
        if (this.isVariableReference(builder)) {
            return SQL_VARIABLE_REFERENCE;
        }
        return null;
    }

    protected boolean isVariableReference(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (type != SQL_IDENT) {
            return type == SQL_AT_SIGN;
        }
        String text2 = builder.getTokenText();
        return this.myLanguage.isVariablePrefix(text2) || text2 != null && text2.startsWith("@");
    }

    public boolean mergeOperatorWithQuestionMark(PsiBuilder builder) {
        return false;
    }

    public boolean parseCustomOperator(PsiBuilder builder, IElementType type, boolean mandatoryQuestion) {
        IElementType tokenType = builder.getTokenType();
        if (this.myLanguage.isOperatorSupported(tokenType)) {
            PsiBuilder.Marker m = builder.mark();
            if (builder.rawLookup(1) == SqlTokens.SQL_QUESTION_MARK && this.myLanguage.isOperatorSupported((IElementType)SqlTokens.SQL_QUESTION_MARK) && this.mergeOperatorWithQuestionMark(builder)) {
                builder.advanceLexer();
            } else if (mandatoryQuestion) {
                m.rollbackTo();
                return false;
            }
            builder.advanceLexer();
            m.done((IElementType)SQL_IDENTIFIER);
            if (type != null) {
                m.precede().done(type);
            }
            return true;
        }
        return false;
    }

    private boolean parseOperatorReferenceExpression(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (this.parseCustomOperator(builder, (IElementType)refType, false)) {
            return true;
        }
        if (!this.parsingOperatorsAsIdentifier()) {
            if (!optional) {
                PsiBuilder.Marker m = builder.mark();
                m.done((IElementType)SQL_REFERENCE);
            }
            return !optional;
        }
        return this.parseQualifiedReferenceExpression(builder, optional, force, refType);
    }

    public boolean parseReferenceExpressionInner(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        if (refType == SQL_OPERATOR_REFERENCE) {
            return this.parseOperatorReferenceExpression(builder, optional, force, refType);
        }
        return this.parseQualifiedReferenceExpression(builder, optional, force, refType);
    }

    private boolean parseAtSymbolNext(PsiBuilder builder, SqlReferenceElementType refType, int endOffset) {
        if (refType != SQL_USER_REFERENCE && endOffset != -1 && endOffset < builder.getCurrentOffset()) {
            return false;
        }
        if (this.isVariableReference(builder)) {
            builder.advanceLexer();
            return true;
        }
        return SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && StringUtil.startsWithChar((CharSequence)builder.getTokenText(), (char)'@');
    }

    private boolean parseQualifiedReferenceExpression(PsiBuilder builder, boolean optional, boolean force, SqlReferenceElementType refType) {
        int endOffset;
        boolean qualified = refType.isQualified();
        if (qualified && SqlGeneratedParserUtil.isQualificationForbidden(builder, 0)) {
            qualified = false;
            refType = SqlGeneratedParserUtil.shorten(refType);
        }
        PsiBuilder.Marker m = builder.mark();
        if (!this.parseIdentifierInner(builder, optional, !optional || force || qualified && builder.rawLookup(1) == SQL_PERIOD, refType == SQL_CHARSET_REFERENCE, refType)) {
            m.drop();
            return false;
        }
        LighterASTNode latestDoneMarker = builder.getLatestDoneMarker();
        int n = endOffset = latestDoneMarker == null ? -1 : latestDoneMarker.getEndOffset();
        if (latestDoneMarker != null && this.myExternalReferenceJustParsed && refType.getTargetKind() == ObjectKind.COLUMN) {
            ((PsiBuilder.Marker)latestDoneMarker).drop();
            m.drop();
        } else {
            m.done((IElementType)(qualified && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) ? SQL_REFERENCE : refType));
        }
        return !qualified || this.parseQualifiedReferenceExpressionTail(builder, refType, endOffset);
    }

    public boolean parseQualifiedReferenceExpressionTail(PsiBuilder builder, SqlReferenceElementType refType, int endOffset) {
        PsiBuilder.Marker m = (PsiBuilder.Marker)builder.getLatestDoneMarker();
        if (m == null) {
            builder.error("Qualification needs expression to qualify");
            return false;
        }
        while (true) {
            LighterASTNode marker;
            boolean atSign;
            if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_PERIOD)) {
                atSign = false;
            } else if (this.parseAtSymbolNext(builder, refType, endOffset)) {
                atSign = true;
            } else {
                return true;
            }
            m = m.precede();
            if (atSign) {
                if (!this.parseReferenceExpressionInner(builder, false, SQL_GENERIC_AT_REFERENCE)) {
                    break;
                }
            } else if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD)) {
                builder.mark().done((IElementType)SQL_IDENTIFIER);
            } else if (!this.parseIdentifierInner(builder, false, false, refType == SQL_CHARSET_REFERENCE, refType)) break;
            endOffset = (marker = builder.getLatestDoneMarker()) == null ? -1 : marker.getEndOffset();
            m.done((IElementType)(SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) ? SQL_REFERENCE : refType));
        }
        m.done((IElementType)refType);
        return true;
    }

    protected boolean parsingOperatorsAsIdentifier() {
        return true;
    }

    public boolean parseIdentifier(PsiBuilder builder, boolean optional) {
        return this.parseIdentifierInner(builder, optional, !optional, false, null);
    }

    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        PsiBuilder.Marker mark2 = builder.mark();
        if (!allowCharSetSpec && this.getLanguage().supportsSql92CharSetSpecFor((IElementType)SQL_IDENTIFIER)) {
            this.consumeUnderscoreAndCharSpec(builder);
        }
        if (this.consumeIdentifier(builder, allowKeywords, this.allowStringsAsIdentifiers())) {
            mark2.done((IElementType)SQL_IDENTIFIER);
            return true;
        }
        if (!optional) {
            mark2.error(SqlMessages.message("identifier.expected", new Object[0]));
        } else {
            mark2.drop();
        }
        return false;
    }

    public boolean allowStringsAsIdentifiers() {
        return false;
    }

    public boolean consumeIdentifier(PsiBuilder builder) {
        return this.consumeIdentifier(builder, true, this.allowStringsAsIdentifiers());
    }

    public boolean consumeIdentifier(PsiBuilder builder, boolean allowKeywords, boolean allowString) {
        return this.consumeIdentifier(builder, allowKeywords, allowString, true);
    }

    public boolean consumeIdentifier(PsiBuilder builder, boolean allowKeywords, boolean allowString, boolean canFollowParameterRef) {
        boolean external = this.parseExternalParameterImpl(builder, false, false);
        boolean advance = !external || builder.rawLookup(0) == builder.getTokenType();
        boolean bl = advance = advance && this.consumeIdentifierInner(builder, allowKeywords, allowString);
        if (canFollowParameterRef && advance && !this.isWhitespaceHere(builder)) {
            this.parseExternalParameterImpl(builder, true, false);
            this.myExternalReferenceJustParsed = false;
        }
        return external || advance || this.parseQuestionMarkParameter(builder);
    }

    private boolean isWhitespaceHere(PsiBuilder builder) {
        return this.isWhitespace(builder.rawLookup(0)) || this.isWhitespace(builder.rawLookup(-1));
    }

    private boolean consumeIdentifierInner(PsiBuilder builder, boolean allowKeywords, boolean allowString) {
        if (this.consumeVarIdentifier(builder, allowString)) {
            return true;
        }
        boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), allowKeywords, allowString);
        if (advance) {
            builder.advanceLexer();
        }
        return advance;
    }

    protected boolean isIdentifierToken(PsiBuilder builder, @Nullable IElementType token, boolean allowKeywords, boolean allowString) {
        return token == SQL_IDENT || token == SQL_IDENT_DELIMITED || token == SQL_MODULE || token == SQL_ASTERISK || token instanceof SqlKeywordTokenType && (allowKeywords || !this.isReservedKeywordHere(builder, token)) || allowString && token == SQL_STRING_TOKEN;
    }

    protected boolean consumeVarIdentifier(PsiBuilder builder, boolean allowString) {
        if (this.isVariableReference(builder)) {
            boolean advance;
            IElementType type = builder.rawLookup(1);
            boolean bl = advance = type == SQL_IDENT || type == SQL_IDENT_DELIMITED || type == SQL_MODULE || type instanceof SqlKeywordTokenType || allowString && type == SQL_STRING_TOKEN;
            if (advance) {
                builder.advanceLexer();
                builder.advanceLexer();
                return true;
            }
        }
        return false;
    }

    public boolean parseCharacterSetSpec(PsiBuilder builder) {
        return this.parseReferenceExpression(builder, SQL_CHARSET_REFERENCE);
    }

    protected boolean allowQuestionMarkParameter(PsiBuilder builder) {
        return !SqlGeneratedParserUtil.isOn(builder, 0, "DISABLE_QUESTION_PARAM");
    }

    public boolean parseQuestionMarkParameter(PsiBuilder builder) {
        if (SqlGeneratedParserUtil.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_QUESTION_MARK) && this.allowQuestionMarkParameter(builder)) {
            PsiBuilder.Marker marker = builder.mark();
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_QUESTION_MARK);
            SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_INTEGER_TOKEN);
            marker.done((IElementType)SQL_PARAMETER_REFERENCE);
            return true;
        }
        return false;
    }

    public boolean parseParameterOrVariableReference(PsiBuilder builder, boolean optional) {
        PsiBuilder.Marker marker = builder.mark();
        if (this.parseQuestionMarkParameter(builder) || this.parseExternalParameterImpl(builder, false, true)) {
            if (builder.getTokenType() == SQL_PERIOD) {
                marker.rollbackTo();
                return false;
            }
            marker.drop();
            return true;
        }
        IElementType variableType = this.getVariableType(builder);
        if (variableType != null) {
            marker.drop();
            return this.parseParameterReferenceInner(builder, variableType);
        }
        IElementType resultType = this.consumeCustomParameterReference(builder);
        if (resultType == null) {
            marker.rollbackTo();
        } else {
            marker.done(resultType);
        }
        return resultType == null && !optional ? this.parseReferenceExpressionInner(builder, true, SQL_VARIABLE_REFERENCE) : resultType != null;
    }

    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        this.myExternalReferenceJustParsed = false;
        if (!SqlGeneratedParserUtil.parseUserParameter(builder, checkStart, checkEnd)) {
            return false;
        }
        this.myExternalReferenceJustParsed = true;
        return true;
    }

    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        PsiBuilder.Marker mark2 = builder.mark();
        this.consumeParameterReferenceInner(builder);
        mark2.done(resultType);
        return true;
    }

    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        boolean optional;
        if (builder.getTokenType() != SQL_IDENT) {
            builder.advanceLexer();
        }
        this.parseIdentifier(builder, false);
        boolean bl = optional = !SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_INDICATOR);
        if (SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_COLON)) {
            this.parseIdentifier(builder, false);
        }
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        return null;
    }

    public boolean isReservedKeywordHere(PsiBuilder builder, IElementType type) {
        return type instanceof SqlKeywordTokenType && this.myLanguage.isReservedKeyword(type);
    }

    public boolean parseReferenceOrFunction(PsiBuilder builder, int level, boolean optional) {
        boolean skipFunction;
        IElementType type = builder.getTokenType();
        boolean bl = skipFunction = this.isReservedKeywordHere(builder, type) && !this.myLanguage.getSupportedFunctions().contains(builder.getTokenText()) && builder.rawLookup(1) != SQL_PERIOD;
        if (!skipFunction && SqlGeneratedParser.primary_expression(builder, level)) {
            LighterASTNode resultMarker = builder.getLatestDoneMarker();
            if (resultMarker != null && resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)(SqlGeneratedParserUtil.isQualificationForbidden(builder, level) ? SQL_COLUMN_SHORT_REFERENCE : SQL_COLUMN_REFERENCE));
            }
            return true;
        }
        if (!optional) {
            builder.error("expression required");
        }
        return false;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return this.parseValueExpression(builder, level, false);
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return this.parseQueryExpression(builder, level);
    }

    public boolean parseLValueExpression(PsiBuilder builder, int level) {
        if (SqlGeneratedParser.primary_expression(builder, level)) {
            LighterASTNode resultMarker = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker());
            if (resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)SQL_COLUMN_REFERENCE);
            }
            return true;
        }
        return false;
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional) {
        return this.parseValueExpression(builder, level, optional, true);
    }

    protected Pair<String, Boolean> extractString(PsiBuilder builder, int start, int end) {
        int si;
        int ei;
        int moffs = -builder.rawTokenIndex();
        for (ei = 0; ei >= moffs && builder.rawTokenTypeStart(ei) > end; --ei) {
        }
        for (si = ei; si >= moffs && builder.rawTokenTypeStart(si) >= start; --si) {
        }
        if (ei - ++si < 1) {
            return Pair.create((Object)"", (Object)true);
        }
        int from = builder.rawTokenTypeStart(si);
        int to = builder.rawTokenTypeStart(ei);
        StringBuilder res2 = new StringBuilder(to - from);
        boolean plain = true;
        while (si < ei) {
            IElementType type = builder.rawLookup(si);
            if (this.isWhitespace(type)) {
                res2.append(" ");
            } else if (!SqlGeneratedParserUtil.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) {
                CharSequence text2 = builder.getOriginalText().subSequence(builder.rawTokenTypeStart(si), builder.rawTokenTypeStart(si + 1));
                if (type == SQL_IDENT_DELIMITED) {
                    text2 = this.getLanguage().getDatabaseDialect().unquoteIdentifier(text2.toString());
                    plain = false;
                }
                res2.append(text2);
            }
            ++si;
        }
        return Pair.create((Object)res2.toString(), (Object)plain);
    }

    public boolean parseKnownFunctionArgumentList(PsiBuilder builder, int level) {
        LighterASTNode refMarker = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker());
        Pair<String, Boolean> name = this.extractString(builder, refMarker.getStartOffset(), refMarker.getEndOffset());
        Case plain = this.myLanguage.getDatabaseDialect().getCasing((ObjectKind)ObjectKind.NONE, null).plain;
        String functionName = plain == Case.EXACT ? ((String)name.first).trim() : Case.UPPER.apply(((String)name.first).trim());
        SqlFunctionDefinition definition = this.myLanguage.getSupportedFunctions().get(functionName);
        if (definition != null) {
            if (definition.getLocation() == SqlFunctionDefinition.Location.TABLE_FUNCTION) {
                if (!SqlParser.isTableFunctionLocation(builder)) {
                    return false;
                }
            } else if (definition.getLocation() == SqlFunctionDefinition.Location.ENGINE_SPEC) {
                GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
                if (frame == null || frame.elementType != SQL_FUNCTION_CALL) {
                    return false;
                }
                frame = frame.parentFrame;
                if (frame == null || frame.elementType != SQL_ENGINE_CLAUSE) {
                    return false;
                }
            }
        }
        return definition != null && this.parseFunctionParametersAndParens(builder, level + 1, functionName, definition, (Boolean)name.second);
    }

    private static boolean isTableFunctionLocation(PsiBuilder builder) {
        GeneratedParserUtilBase.Frame frame = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).currentFrame;
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        while (frame != null && frame.elementType == SQL_FUNCTION_CALL) {
            frame = frame.parentFrame;
        }
        while (frame != null && frame.elementType == null) {
            frame = frame.parentFrame;
        }
        return frame != null && frame.elementType == SQL_TABLE_PROCEDURE_CALL_EXPRESSION;
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        return SqlGeneratedParser.paren_argument_list(builder, level);
    }

    public boolean parseFunctionParametersAndParens(PsiBuilder builder, int level, String functionName, SqlFunctionDefinition definition, boolean plain) {
        Object[] prototypes;
        String parens = definition != null ? definition.getDialectAttribute("parens") : null;
        Object[] objectArray = prototypes = definition == null ? SqlFunctionDefinition.Prototype.EMPTY_ARRAY : definition.getPrototypes();
        if (!plain && "prohibited".equals(parens) && this.getLanguage().getDbms().isPostgres()) {
            parens = "required";
        }
        if (!"required".equals(parens) && SqlParser.isTableFunctionLocation(builder)) {
            parens = "required";
        }
        if ("prohibited".equals(parens) && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN)) {
            if (prototypes.length < 2 || prototypes[0].getParams().length > 0) {
                SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, null);
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_RIGHT_PAREN);
                return true;
            }
            prototypes = (SqlFunctionDefinition.Prototype[])ArrayUtil.remove((Object[])prototypes, (int)0);
        } else if ("required".equals(parens) && !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_LEFT_PAREN)) {
            return false;
        }
        if (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_LEFT_PAREN)) {
            if (!this.parseFunctionParametersStart(builder, level, definition)) {
                return false;
            }
            boolean result2 = false;
            Number parsedProtoId = null;
            FunctionParsingContext context = new FunctionParsingContext();
            PsiBuilder.Marker marker = builder.mark();
            if (prototypes.length > 0) {
                LighterASTNode latestDoneMarker;
                Number protoId;
                boolean eatMore;
                boolean overloadable = definition == null || definition.isOverloadable();
                result2 = this.parseParameterChoice(builder, level, (SqlFunctionDefinition.Parameter[])prototypes, true, context, !overloadable);
                boolean bl = eatMore = builder.getTokenType() != SQL_RIGHT_PAREN && builder.getTokenType() != SQL_SEMICOLON && !this.argumentListRecover(builder, level);
                if (!result2 || eatMore) {
                    result2 = false;
                }
                if ((protoId = SqlInfoElementType.getValue((latestDoneMarker = builder.getLatestDoneMarker()) == null ? null : latestDoneMarker.getTokenType(), Number.class)) != null) {
                    if (result2) {
                        parsedProtoId = protoId;
                    }
                    if (!result2 || overloadable && context.errorCounter != 0) {
                        ((PsiBuilder.Marker)latestDoneMarker).drop();
                    }
                }
            }
            if (!result2) {
                this.parseSimpleArguments(builder, level, context);
            }
            marker.done((IElementType)SQL_EXPRESSION_LIST);
            this.parseFunctionParametersEnd(builder, level, definition);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            if (parsedProtoId != null) {
                Object prototype = prototypes[parsedProtoId.intValue()];
                if (((SqlFunctionDefinition.Prototype)prototype).getTailBlock() != null) {
                    this.parseFunctionParameter(builder, level, ((SqlFunctionDefinition.Prototype)prototype).getTailBlock(), context);
                }
                this.parsePrototypeTail(builder, level, (SqlFunctionDefinition.Prototype)prototype, context);
            }
            return true;
        }
        return "optional".equals(parens) || !SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_PERIOD) && definition != null && prototypes.length > 0 && ((SqlFunctionDefinition.ParameterBlock)prototypes[0]).getParams().length == 0;
    }

    protected void parseSimpleArguments(PsiBuilder builder, int level, FunctionParsingContext context) {
        block0: while (true) {
            Collection<SqlInfoElementType> infoElementTypes = context.get(builder.getCurrentOffset());
            if (!this.parseFunctionArgument(builder, level, true, true)) {
                IElementType tokenType = builder.getTokenType();
                if (!(tokenType instanceof SqlKeywordTokenType) && tokenType != SQL_COMMA || this.argumentListRecover(builder, level)) break;
                builder.advanceLexer();
            }
            Iterator<SqlInfoElementType> iterator = infoElementTypes.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SqlInfoElementType type = iterator.next();
                builder.mark().done((IElementType)type);
            }
            break;
        }
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        return true;
    }

    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        return true;
    }

    public boolean parseParameterSequence(PsiBuilder builder, int level, SqlFunctionDefinition.ParameterBlock block, FunctionParsingContext functionContext) {
        SqlFunctionDefinition.Parameter[] parameters = block.getParams();
        if (block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.CHOICE) {
            return this.parseParameterChoice(builder, level, parameters, false, functionContext, true);
        }
        if (parameters.length == 0) {
            return true;
        }
        boolean isOptionalSequence = block.getBlockType() == SqlFunctionDefinition.ParameterBlockType.OPTIONAL_SEQUENCE;
        boolean result2 = true;
        boolean pinned = false;
        PsiBuilder.Marker mark2 = builder.mark();
        for (SqlFunctionDefinition.Parameter parameter : parameters) {
            int offset = builder.getCurrentOffset();
            boolean shouldParse = pinned || result2;
            boolean parsed = shouldParse && this.parseFunctionParameter(builder, level + 1, parameter, functionContext);
            result2 = parsed && result2;
            int len = builder.getCurrentOffset() - offset;
            if (!pinned && result2 && parameter != SqlFunctionDefinition.COMMA && len > 0 && (!isOptionalSequence || parameter instanceof SqlFunctionDefinition.Keyword)) {
                pinned = true;
            } else if (shouldParse && !parsed && pinned) {
                SqlGeneratedParserUtil.report_error_((PsiBuilder)builder, (GeneratedParserUtilBase.ErrorState)GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder), (boolean)false);
                ++functionContext.errorCounter;
            }
            if (builder.eof()) break;
        }
        if (!result2 && !pinned) {
            mark2.rollbackTo();
        } else {
            mark2.drop();
        }
        return result2 || pinned || isOptionalSequence;
    }

    private SqlParserUtil.ParserChoice<Integer> createParserChoice(final SqlFunctionDefinition.Parameter parameter, final int index2, final FunctionParsingContext functionContext, final int[] prototypeIndex) {
        return new SqlParserUtil.ParserChoice<Integer>(){
            private final SqlFunctionDefinition.Prototype prototype;
            {
                this.prototype = (SqlFunctionDefinition.Prototype)ObjectUtils.tryCast((Object)parameter, SqlFunctionDefinition.Prototype.class);
            }

            @Override
            public Integer parse(PsiBuilder builder, int level) {
                return this.parseAndGetError(builder, level, parameter);
            }

            @Nullable
            private Integer parseAndGetError(PsiBuilder builder, int level, SqlFunctionDefinition.Parameter param) {
                prototypeIndex[0] = index2;
                int counter = functionContext.errorCounter;
                functionContext.errorCounter = 0;
                boolean result2 = SqlParser.this.parseFunctionParameter(builder, level, param, functionContext);
                int errors = functionContext.errorCounter;
                functionContext.errorCounter = counter;
                return result2 ? Integer.valueOf(errors) : null;
            }

            @Override
            public Integer lookahead(Integer prev, PsiBuilder builder, int level) {
                assert (this.prototype != null);
                SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SqlCommonTokens.SQL_RIGHT_PAREN);
                this.parseAndGetError(builder, level, this.prototype.getTailBlock());
                return super.lookahead(prev, builder, level);
            }

            @Override
            public boolean hasLookahead() {
                return this.prototype != null && this.prototype.getTailBlock() != null;
            }
        };
    }

    private SqlParserUtil.ParserChoice<Integer> createSimpleArgumentsParser(final FunctionParsingContext functionContext, final int[] prototypeIndex) {
        return new SqlParserUtil.ParserChoice<Integer>(){

            @Override
            public boolean isSimple() {
                return true;
            }

            @Override
            public Integer parse(PsiBuilder builder, int level) {
                prototypeIndex[0] = -1;
                int counter = 0;
                boolean result2 = true;
                boolean first = true;
                while (true) {
                    Collection<SqlInfoElementType> infoElementTypes = functionContext.get(builder.getCurrentOffset());
                    if (!SqlParser.this.parseFunctionArgument(builder, level, first, true)) {
                        counter = 1;
                        result2 = false;
                        break;
                    }
                    first = false;
                    for (SqlInfoElementType type : infoElementTypes) {
                        builder.mark().done((IElementType)type);
                    }
                    if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SqlCommonTokens.SQL_COMMA)) break;
                    builder.advanceLexer();
                }
                return result2 ? Integer.valueOf(counter) : null;
            }
        };
    }

    private boolean parseParameterChoice(PsiBuilder builder, int level, SqlFunctionDefinition.Parameter[] parameters, boolean storePrototypeIndex, FunctionParsingContext functionContext, boolean genError) {
        BranchesCache.CacheEntry branch;
        SqlFunctionDefinition function2 = parameters.length > 0 && parameters[0] instanceof SqlFunctionDefinition.Prototype ? ((SqlFunctionDefinition.Prototype)parameters[0]).getFunction() : null;
        BranchesCache cache2 = function2 != null ? BranchesCache.get(builder) : null;
        int branchStart = builder.getCurrentOffset();
        int[] prototypeIndex = new int[]{-1};
        Integer result2 = null;
        boolean fromCache = false;
        if (function2 != null && (branch = cache2.getCachedBranch(branchStart, function2)) != null) {
            fromCache = true;
            prototypeIndex[0] = branch.protoId;
            result2 = branch.metric;
            branch.importMarks(functionContext);
        }
        if (!fromCache) {
            ArrayList parsers = ContainerUtil.newArrayListWithCapacity((int)parameters.length);
            for (int i2 = parameters.length - 1; i2 >= 0; --i2) {
                parsers.add(this.createParserChoice(parameters[i2], i2, functionContext, prototypeIndex));
            }
            if (function2 != null && function2.isOverloadable()) {
                parsers.add(this.createSimpleArgumentsParser(functionContext, prototypeIndex));
            }
            result2 = (Integer)SqlParserUtil.chooseTheBestParser(builder, level, parsers);
            if (function2 != null) {
                cache2.putBranch(branchStart, function2, prototypeIndex[0], result2, functionContext);
            }
        } else {
            int index2 = prototypeIndex[0];
            SqlParserUtil.ParserChoice<Integer> parser = index2 == -1 ? this.createSimpleArgumentsParser(functionContext, prototypeIndex) : this.createParserChoice(parameters[index2], index2, functionContext, prototypeIndex);
            SqlParserUtil.chooseTheBestParser(builder, level, Collections.singletonList(parser));
        }
        if (result2 == null) {
            if (!genError) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (SqlFunctionDefinition.Parameter parameter : parameters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(parameter.toString());
            }
            builder.error(SqlMessages.message("one.of.expected.0", sb.toString()));
            return false;
        }
        functionContext.errorCounter += result2.intValue();
        if (storePrototypeIndex && prototypeIndex[0] >= 0) {
            builder.mark().done(SqlInfoElementType.getElementType(prototypeIndex[0]));
        }
        return true;
    }

    public boolean parseFunctionParameter(PsiBuilder builder, int level, SqlFunctionDefinition.Parameter parameter, FunctionParsingContext functionContext) {
        boolean result2 = this.parseFunctionParameterSingle(builder, level, parameter, functionContext);
        if (!result2 || !parameter.isMany()) {
            return result2;
        }
        while (SqlGeneratedParserUtil.consumeTokenFast((PsiBuilder)builder, (IElementType)SQL_COMMA) && this.parseFunctionParameterSingle(builder, level, parameter, functionContext)) {
        }
        return true;
    }

    public boolean parseFunctionParameterSingle(PsiBuilder builder, int level, SqlFunctionDefinition.Parameter parameter, FunctionParsingContext functionContext) {
        boolean result2;
        Collection<SqlInfoElementType> infoTypeCollection = functionContext.get(builder.getCurrentOffset());
        PsiBuilder.Marker mark2 = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, null);
        if (parameter == SqlFunctionDefinition.COMMA) {
            boolean result22 = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)SQL_COMMA);
        } else if (parameter instanceof SqlFunctionDefinition.SyntaxParameter) {
            String text2 = ((SqlFunctionDefinition.SyntaxParameter)parameter).getText();
            result2 = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)text2);
        } else if (parameter instanceof SqlFunctionDefinition.Keyword) {
            SqlTokenType expectedToken = SqlTokenRegistry.getType((String)((SqlFunctionDefinition.Keyword)parameter).getName());
            result2 = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (IElementType)expectedToken);
        } else if (parameter instanceof SqlFunctionDefinition.SimpleParameter) {
            SqlFunctionDefinition.SimpleParameter simpleParam = (SqlFunctionDefinition.SimpleParameter)parameter;
            SqlFunctionDefinition.Type type = simpleParam.getType();
            PsiBuilder.Marker prefixMark = builder.mark();
            boolean prefixParsed = this.parseNamedFunctionArgumentPrefix(builder, level);
            Boolean paramParsed = this.parseSimpleParameter(builder, level, type);
            if (paramParsed != null) {
                result2 = paramParsed;
            } else if (type == SqlFunctionDefinition.REF) {
                SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((SqlFunctionDefinition.ReferenceParameter)simpleParam);
                result2 = this.parseTypedReference(builder, refType);
            } else {
                PsiBuilder.Marker marker = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)(level + 1), (int)0, (String)"<expression>");
                SqlGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<expression>");
                boolean allowBoolean = SqlType.Category.BOOLEAN == this.myLanguage.getTypeCategory(type.getDataType()) || type == SqlFunctionDefinition.ANY;
                result2 = this.parseValueExpression(builder, level + 1, false, allowBoolean);
                SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)(level + 1), (PsiBuilder.Marker)marker, null, (boolean)result2, (boolean)false, null);
            }
            if (prefixParsed) {
                prefixMark.done((IElementType)SQL_NAMED_PARAMETER_VALUE);
            } else {
                prefixMark.drop();
            }
            result2 |= prefixParsed;
        } else if (parameter instanceof SqlFunctionDefinition.ParameterBlock) {
            SqlFunctionDefinition.ParameterBlock block = (SqlFunctionDefinition.ParameterBlock)parameter;
            result2 = this.parseParameterSequence(builder, level, block, functionContext);
        } else if (parameter instanceof SqlFunctionDefinition.ExternalParameter) {
            result2 = this.parseSpecificRoots(((SqlFunctionDefinition.ExternalParameter)parameter).getNodeType(), builder, level);
        } else {
            throw new AssertionError((Object)("unknown parameter " + parameter));
        }
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)mark2, null, (boolean)result2, (boolean)false, null);
        if (result2 && parameter != SqlFunctionDefinition.COMMA && !(parameter instanceof SqlFunctionDefinition.ParameterBlock)) {
            infoTypeCollection.add(SqlInfoElementType.getElementType(parameter));
            for (SqlInfoElementType sqlInfoElementType : infoTypeCollection) {
                builder.mark().done((IElementType)sqlInfoElementType);
            }
        }
        return result2;
    }

    protected Boolean parseSimpleParameter(PsiBuilder builder, int level, SqlFunctionDefinition.Type type) {
        if (type == SqlFunctionDefinition.DATATYPE) {
            return this.parseDataType(builder, level, false);
        }
        if (type == SqlFunctionDefinition.TABLE) {
            return this.parseQueryExpression(builder, level);
        }
        if (type == SqlFunctionDefinition.TOKEN) {
            return this.consumeIdentifier(builder);
        }
        return null;
    }

    protected boolean parsePrototypeTail(PsiBuilder builder, int level, SqlFunctionDefinition.Prototype parameter, FunctionParsingContext context) {
        return true;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        if (SqlGeneratedParser.primary_expression(builder, 0)) {
            LighterASTNode resultMarker = (LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker());
            if (refType != null && resultMarker.getTokenType() == SQL_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)resultMarker).remapTokenType((IElementType)refType);
            }
            return true;
        }
        return false;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        PsiBuilder.Marker mark2 = builder.mark();
        boolean parsed = this.parseNamedFunctionArgumentPrefix(builder, level);
        boolean parsedVal = this.parseValueExpression(builder, level, !parsed && optional, allowBoolean);
        if (parsed) {
            mark2.done((IElementType)SQL_NAMED_PARAMETER_VALUE);
        } else {
            mark2.drop();
        }
        return parsed || parsedVal;
    }

    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return false;
    }

    public boolean parseNamedFunctionArgumentPrefixImpl(PsiBuilder builder, IElementType token) {
        boolean result2;
        PsiBuilder.Marker mark2 = builder.mark();
        boolean bl = result2 = this.parseReferenceExpression(builder, true, SQL_ARGUMENT_REFERENCE) && SqlParserUtil.consumeToken(builder, token);
        if (result2) {
            mark2.drop();
        } else {
            mark2.rollbackTo();
        }
        return result2;
    }

    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return false;
    }

    protected boolean isWhitespace(IElementType type) {
        return SqlTokens.WS_TOKENS.contains(type);
    }

    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        this.applyStatementMarkerBinders(builder);
        if (SqlGeneratedParserUtil.isCompletionHere(builder, level)) {
            return false;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null) {
            return false;
        }
        if (this.isStatementSeparatorParsed(builder)) {
            return false;
        }
        if (this.myLanguage.getStatementSeparators().contains(tokenType)) {
            return false;
        }
        if (!this.myStatementRecoverNewLine && !this.allowNoStatementSeparator()) {
            int i2 = 1;
            while (true) {
                IElementType type;
                if ((type = builder.rawLookup(-i2)) == null) {
                    this.myStatementRecoverNewLine = true;
                    break;
                }
                if (this.isWhitespace(type)) {
                    CharSequence s = PsiBuilderUtil.rawTokenText((PsiBuilder)builder, (int)(-i2));
                    if (StringUtil.indexOf((CharSequence)s, (char)'\n') >= 0) {
                        this.myStatementRecoverNewLine = true;
                        break;
                    }
                } else if (!GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)type)) break;
                ++i2;
            }
            if (!this.myStatementRecoverNewLine) {
                return true;
            }
        }
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)16);
        boolean r = !prefixParser.parse(builder, level + 1);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, (boolean)r, (boolean)false, null);
        return r;
    }

    private void applyStatementMarkerBinders(PsiBuilder builder) {
        WhitespacesAndCommentsBinder right;
        IElementType type;
        LighterASTNode last = builder.getLatestDoneMarker();
        IElementType iElementType = type = last != null ? last.getTokenType() : null;
        if (type == null || !GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder).typeExtends(type, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
            return;
        }
        WhitespacesAndCommentsBinder left = PL_PATTERN.matcher(type.toString()).matches() ? ADD_COMMENT_LEFT : null;
        WhitespacesAndCommentsBinder whitespacesAndCommentsBinder = right = !this.allowNoStatementSeparator() ? null : TRIM_SPACES_RIGHT;
        if (left != null || right != null) {
            ((PsiBuilder.Marker)last).setCustomEdgeTokenBinders(left, right);
        }
    }

    public boolean canBeCalled(IElementType type) {
        return type == SQL_COLUMN_REFERENCE || type == SQL_ARGUMENT_REFERENCE || type == SQL_FUNCTION_CALL || type == SQL_REFERENCE;
    }

    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return false;
    }

    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return null;
    }

    private static boolean tryParse(PsiBuilder b2, int l, GeneratedParserUtilBase.Parser p2) {
        PsiBuilder.Marker m = SqlGeneratedParserUtil.enter_section_((PsiBuilder)b2, (int)l, (int)16);
        boolean res2 = p2.parse(b2, l);
        SqlGeneratedParserUtil.exit_section_((PsiBuilder)b2, (int)l, (PsiBuilder.Marker)m, (boolean)false, (boolean)false, null);
        return res2;
    }

    private static boolean consumeIntegerToken(PsiBuilder builder, boolean allowFloat) {
        boolean optional;
        boolean bl = optional = SqlParserUtil.consumeOneOfTokens(builder, true, new IElementType[]{SQL_OP_PLUS, SQL_OP_MINUS}) == null;
        return allowFloat ? SqlParserUtil.consumeOneOfTokens(builder, optional, new IElementType[]{SQL_INTEGER_TOKEN, SQL_FLOAT_TOKEN}) != null : SqlParserUtil.consumeToken(builder, true, (IElementType)SQL_INTEGER_TOKEN);
    }

    private static boolean parseInteger(PsiBuilder builder, boolean allowFloat) {
        PsiBuilder.Marker mark2 = builder.mark();
        boolean result2 = SqlParser.consumeIntegerToken(builder, allowFloat);
        if (result2) {
            mark2.done((IElementType)SQL_NUMERIC_LITERAL);
        } else {
            mark2.rollbackTo();
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/base/SqlParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/base/SqlParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BranchesCache {
        private static final Key<BranchesCache> ourKey = Key.create((String)"BranchesCache");
        private final TIntObjectHashMap<CacheEntry> myProtoIds = new TIntObjectHashMap();

        private BranchesCache() {
        }

        @Nullable
        public CacheEntry getCachedBranch(int branchStart, SqlFunctionDefinition f) {
            CacheEntry entry = (CacheEntry)this.myProtoIds.get(branchStart);
            return entry == null || entry.func != f ? null : entry;
        }

        public void putBranch(int branchStart, SqlFunctionDefinition f, int id, Integer metric, FunctionParsingContext context) {
            this.myProtoIds.put(branchStart, (Object)new CacheEntry(f, id, metric, BranchesCache.exportMarks(context)));
        }

        public void clear() {
            this.myProtoIds.clear();
        }

        @NotNull
        public static BranchesCache get(@NotNull PsiBuilder builder) {
            BranchesCache cache2;
            if (builder == null) {
                BranchesCache.$$$reportNull$$$0(0);
            }
            if ((cache2 = (BranchesCache)builder.getUserData(ourKey)) == null) {
                cache2 = new BranchesCache();
                builder.putUserData(ourKey, (Object)cache2);
            }
            BranchesCache branchesCache = cache2;
            if (branchesCache == null) {
                BranchesCache.$$$reportNull$$$0(1);
            }
            return branchesCache;
        }

        public static Trinity<int[], int[], List<SqlInfoElementType>> exportMarks(FunctionParsingContext context) {
            if (context.map == null) {
                return null;
            }
            final int[] offsets = new int[context.map.size()];
            final int[] ends = new int[context.map.size()];
            final ArrayList items = ContainerUtil.newArrayList();
            context.map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Collection<SqlInfoElementType>>(){
                int idx = 0;

                public boolean execute(int offs, Collection<SqlInfoElementType> infos) {
                    offsets[this.idx] = offs;
                    items.addAll(infos);
                    ends[this.idx] = items.size();
                    ++this.idx;
                    return true;
                }
            });
            return Trinity.create((Object)offsets, (Object)ends, (Object)items);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/base/SqlParser$BranchesCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/base/SqlParser$BranchesCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class CacheEntry {
            public final SqlFunctionDefinition func;
            public final int protoId;
            public final Integer metric;
            public final Trinity<int[], int[], List<SqlInfoElementType>> marks;

            private CacheEntry(SqlFunctionDefinition func, int id, Integer metric, Trinity<int[], int[], List<SqlInfoElementType>> marks) {
                this.func = func;
                this.protoId = id;
                this.metric = metric;
                this.marks = marks;
            }

            public void importMarks(FunctionParsingContext context) {
                int i2 = 0;
                int prev = 0;
                while (i2 < ((int[])this.marks.first).length) {
                    Collection<SqlInfoElementType> infos = context.get(((int[])this.marks.first)[i2]);
                    for (int j = prev; j < ((int[])this.marks.second)[i2]; ++j) {
                        infos.add((SqlInfoElementType)((Object)((List)this.marks.third).get(j)));
                    }
                    prev = ((int[])this.marks.second)[++i2 - 1];
                }
            }
        }
    }

    public static class FunctionParsingContext {
        public TIntObjectHashMap<Collection<SqlInfoElementType>> map;
        public int errorCounter;

        public Collection<SqlInfoElementType> get(int offset) {
            Collection list;
            if (this.map == null) {
                this.map = new TIntObjectHashMap();
            }
            if ((list = (Collection)this.map.get(offset)) == null) {
                list = new ArrayListSet();
                this.map.put(offset, (Object)list);
            }
            return list;
        }
    }
}

