/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showreferences;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferenceType;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ShowQualifiedListener;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;

public class ReferenceKey {
    private final String _fkName;
    private final String _fktable_cat;
    private final String _fktable_schem;
    private final String _fktable_name;
    private final String _pktable_cat;
    private final String _pktable_schem;
    private final String _pktable_name;
    private ReferenceType _referenceType;
    private boolean _showQualified;
    private HashMap<String, String> _fkColumn_pkcolumn = new HashMap();

    public ReferenceKey(String fkName, String fktable_cat, String fktable_schem, String fktable_name, String pktable_cat, String pktable_schem, String pktable_name, ReferenceType referenceType) {
        this._fkName = fkName;
        this._fktable_cat = fktable_cat;
        this._fktable_schem = fktable_schem;
        this._fktable_name = fktable_name;
        this._pktable_cat = pktable_cat;
        this._pktable_schem = pktable_schem;
        this._pktable_name = pktable_name;
        this._referenceType = referenceType;
    }

    public void addColumn(String fkcolumn_name, String pkcolumn_name) {
        this._fkColumn_pkcolumn.put(fkcolumn_name, pkcolumn_name);
    }

    public String toString() {
        String colRefsPk = null;
        String colRefsFk = null;
        for (Map.Entry<String, String> fk_pk : this._fkColumn_pkcolumn.entrySet()) {
            if (null == colRefsPk) {
                if (this._showQualified) {
                    colRefsFk = SQLUtilities.getQualifiedTableName(this._fktable_cat, this._fktable_schem, this._fktable_name) + "(" + fk_pk.getKey();
                    colRefsPk = SQLUtilities.getQualifiedTableName(this._pktable_cat, this._pktable_schem, this._pktable_name) + "(" + fk_pk.getValue();
                    continue;
                }
                colRefsFk = this._fktable_name + "(" + fk_pk.getKey();
                colRefsPk = this._pktable_name + "(" + fk_pk.getValue();
                continue;
            }
            colRefsPk = colRefsPk + "," + fk_pk.getValue();
            colRefsFk = colRefsFk + "," + fk_pk.getKey();
        }
        colRefsPk = colRefsPk + ")";
        colRefsFk = colRefsFk + ")";
        String colRefs = ReferenceType.EXPORTED_KEY == this._referenceType ? colRefsFk + " -> " + colRefsPk : colRefsPk + " -> " + colRefsFk;
        return colRefs + " [FK = " + this._fkName + "]";
    }

    public ResultMetaDataTable getFkResultMetaDataTable() {
        return new ResultMetaDataTable(this._fktable_cat, this._fktable_schem, this._fktable_name);
    }

    public ResultMetaDataTable getPkResultMetaDataTable() {
        return new ResultMetaDataTable(this._pktable_cat, this._pktable_schem, this._pktable_name);
    }

    public ShowQualifiedListener getShowQualifiedListener() {
        return new ShowQualifiedListener(){

            @Override
            public void showQualifiedChanged(boolean showQualified) {
                ReferenceKey.this._showQualified = showQualified;
            }
        };
    }

    public HashMap<String, String> getFkColumn_pkcolumnMap() {
        return this._fkColumn_pkcolumn;
    }

    public ReferenceType getReferenceType() {
        return this._referenceType;
    }
}

