dnl
dnl AC_PROG_GNU_OBJECTIVEC
dnl
dnl (copied from aclocal.m4 distributed with obgtk-1.0.0)
dnl
AC_DEFUN(AC_PROG_GNU_OBJECTIVE_C,[
	AC_CHECK_PROGS(OBJC, $OBJC gcc egcs cc)
	AC_REQUIRE([AC_LIB_PTHREAD])
	OBJCLIBS="-dl -lobjc $PTHREAD_LIB" 
	AC_CHECK_FUNC(sched_yield,,[
	  AC_CHECK_LIB(posix4,sched_yield,
	    OBJCLIBS="$OBJCLIBS -lposix4",, $OBJCLIBS)])
	AC_SUBST(OBJCLIBS)

	AC_CACHE_CHECK([if GNU Objective C compiler ($OBJC) works],
	  ac_cv_prog_gnu_objc_works, [
	    if test -n "$OBJC"; then
		cat > conftest.m <<EOF
#include <objc/Object.h>
@interface myRandomObj : Object
{
}
@end
@implementation myRandomObj
@end
int main () {
  /* No, you are not seeing double.  Remember that square brackets
     are the autoconf m4 quotes.  */
  id myid = [[myRandomObj alloc]];
  [[myid free]];
  return 0;
}
EOF
		$OBJC -o conftest $LDFLAGS conftest.m $OBJCLIBS 1>&AC_FD_CC 2>&1
		result=$?
		rm -f conftest*

		if test $result -eq 0; then
			ac_cv_prog_gnu_objc_works=yes
		else
			ac_cv_prog_gnu_objc_works=no
		fi
	    else
      	    	ac_cv_prog_gnu_objc_works=no
    	    fi])
	HAVE_GNU_OBJECTIVE_C=$ac_cv_prog_gnu_objc_works
])

