//
// $Id: Character.h,v 1.6 2007/03/06 20:42:19 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(CHARACTER_OL_GUARD)
#if !defined(OL_GENERATING_DOCUMENTATION)
#define CHARACTER_OL_GUARD
#endif

/**
 * @file
 *
 * Unicode constants for characters. These character constants are encoded using
 * UTF-16, which is the internal encoding used by OLText and OLTextBuffer. These
 * constants can be used to build simple pieces of text when UTF-16 is not
 * otherwise available and conversion from another encoding is not desired.
 *
 * @sa OLText, OLTextBuffer
 *
 * @ingroup Text
 */
/*@{*/
#define OL_SPACE_CHAR                   0x0020 /**< A space - ' ' */
#define OL_EXCLAMATION_CHAR             0x0021 /**< An exclamation point - '!' */
#define OL_DOUBLE_QUOTE_CHAR            0x0022 /**< A double quotation mark - '"' */
#define OL_NUMBER_SIGN_CHAR             0x0023 /**< A number sign - '#' */
#define OL_DOLLAR_SIGN_CHAR             0x0024 /**< A dollar sign - '$' */
#define OL_PERCENT_CHAR                 0x0025 /**< A percent sign - '%' */
#define OL_AMPERSAND_CHAR               0x0026 /**< An ampersand - '&' */
#define OL_APOSTROPHE_CHAR              0x0027 /**< An apostrophe - "'" */
#define OL_LEFT_PARENTHESIS_CHAR        0x0028 /**< A left parenthesis - '(' */
#define OL_RIGHT_PARENTHESIS_CHAR       0x0029 /**< A right parenthesis - ')' */
#define OL_ASTERISK_CHAR                0x002A /**< An asterisk - '*' */
#define OL_PLUS_CHAR                    0x002B /**< A plus sign - '+' */
#define OL_COMMA_CHAR                   0x002C /**< A comma - ',' */
#define OL_MINUS_CHAR                   0x002D /**< A minus sign - '-' */
#define OL_PERIOD_CHAR                  0x002E /**< A period - '.' */
#define OL_SLASH_CHAR                   0x002F /**< A forward slash - '/' */
#define OL_ZERO_CHAR                    0x0030 /**< A zero - '0' */
#define OL_ONE_CHAR                     0x0031 /**< A one - '1' */
#define OL_TWO_CHAR                     0x0032 /**< A two - '2' */
#define OL_THREE_CHAR                   0x0033 /**< A three - '3' */
#define OL_FOUR_CHAR                    0x0034 /**< A four - '4' */
#define OL_FIVE_CHAR                    0x0035 /**< A five - '5' */
#define OL_SIX_CHAR                     0x0036 /**< A six - '6' */
#define OL_SEVEN_CHAR                   0x0037 /**< A seven - '7' */
#define OL_EIGHT_CHAR                   0x0038 /**< An eight - '8' */
#define OL_NINE_CHAR                    0x0039 /**< A nine - '9' */
#define OL_COLON_CHAR                   0x003A /**< A colon - ':' */
#define OL_SEMICOLON_CHAR               0x003B /**< A semicolon - ';' */
#define OL_LESS_THAN_CHAR               0x003C /**< A less than sign - '<' */
#define OL_EQUALS_CHAR                  0x003D /**< An equals sign - '=' */
#define OL_GREATER_THAN_CHAR            0x003E /**< A greater than sign - '>' */
#define OL_QUESTION_MARK_CHAR           0x003F /**< A question mark - '?' */
#define OL_AT_SIGN_CHAR                 0x0040 /**< An at sign - '@' */
#define OL_CAPITAL_A_CHAR               0x0041 /**< A capital letter A - 'A' */
#define OL_CAPITAL_B_CHAR               0x0042 /**< A capital letter B - 'B' */
#define OL_CAPITAL_C_CHAR               0x0043 /**< A capital letter C - 'C' */
#define OL_CAPITAL_D_CHAR               0x0044 /**< A capital letter D - 'D' */
#define OL_CAPITAL_E_CHAR               0x0045 /**< A capital letter E - 'E' */
#define OL_CAPITAL_F_CHAR               0x0046 /**< A capital letter F - 'F' */
#define OL_CAPITAL_G_CHAR               0x0047 /**< A capital letter G - 'G' */
#define OL_CAPITAL_H_CHAR               0x0048 /**< A capital letter H - 'H' */
#define OL_CAPITAL_I_CHAR               0x0049 /**< A capital letter I - 'I' */
#define OL_CAPITAL_J_CHAR               0x004A /**< A capital letter J - 'J' */
#define OL_CAPITAL_K_CHAR               0x004B /**< A capital letter K - 'K' */
#define OL_CAPITAL_L_CHAR               0x004C /**< A capital letter L - 'L' */
#define OL_CAPITAL_M_CHAR               0x004D /**< A capital letter M - 'M' */
#define OL_CAPITAL_N_CHAR               0x004E /**< A capital letter N - 'N' */
#define OL_CAPITAL_O_CHAR               0x004F /**< A capital letter O - 'O' */
#define OL_CAPITAL_P_CHAR               0x0050 /**< A capital letter P - 'P' */
#define OL_CAPITAL_Q_CHAR               0x0051 /**< A capital letter Q - 'Q' */
#define OL_CAPITAL_R_CHAR               0x0052 /**< A capital letter R - 'R' */
#define OL_CAPITAL_S_CHAR               0x0053 /**< A capital letter S - 'S' */
#define OL_CAPITAL_T_CHAR               0x0054 /**< A capital letter T - 'T' */
#define OL_CAPITAL_U_CHAR               0x0055 /**< A capital letter U - 'U' */
#define OL_CAPITAL_V_CHAR               0x0056 /**< A capital letter V - 'V' */
#define OL_CAPITAL_W_CHAR               0x0057 /**< A capital letter W - 'W' */
#define OL_CAPITAL_X_CHAR               0x0058 /**< A capital letter X - 'X' */
#define OL_CAPITAL_Y_CHAR               0x0059 /**< A capital letter Y - 'Y' */
#define OL_CAPITAL_Z_CHAR               0x005A /**< A capital letter Z - 'Z' */
#define OL_LEFT_SQUARE_BRACKET_CHAR     0x005B /**< A left square bracket - '[' */
#define OL_BACKSLASH_CHAR               0x005C /**< A backslash - '\' */
#define OL_RIGHT_SQUARE_BRACKET_CHAR    0x005D /**< A right square bracket - ']' */
#define OL_CIRCUMFLEX_CHAR              0x005E /**< A circumflex - '^' */
#define OL_UNDERSCORE_CHAR              0x005F /**< An underscore - '_' */
#define OL_GRAVE_CHAR                   0x0060 /**< A grave - '`' */
#define OL_SMALL_A_CHAR                 0x0061 /**< A small letter A - 'a' */
#define OL_SMALL_B_CHAR                 0x0062 /**< A small letter B - 'b' */
#define OL_SMALL_C_CHAR                 0x0063 /**< A small letter C - 'c' */
#define OL_SMALL_D_CHAR                 0x0064 /**< A small letter D - 'd' */
#define OL_SMALL_E_CHAR                 0x0065 /**< A small letter E - 'e' */
#define OL_SMALL_F_CHAR                 0x0066 /**< A small letter F - 'f' */
#define OL_SMALL_G_CHAR                 0x0067 /**< A small letter G - 'g' */
#define OL_SMALL_H_CHAR                 0x0068 /**< A small letter H - 'h' */
#define OL_SMALL_I_CHAR                 0x0069 /**< A small letter I - 'i' */
#define OL_SMALL_J_CHAR                 0x006A /**< A small letter J - 'j' */
#define OL_SMALL_K_CHAR                 0x006B /**< A small letter K - 'k' */
#define OL_SMALL_L_CHAR                 0x006C /**< A small letter L - 'l' */
#define OL_SMALL_M_CHAR                 0x006D /**< A small letter M - 'm' */
#define OL_SMALL_N_CHAR                 0x006E /**< A small letter N - 'n' */
#define OL_SMALL_O_CHAR                 0x006F /**< A small letter O - 'o' */
#define OL_SMALL_P_CHAR                 0x0070 /**< A small letter P - 'p' */
#define OL_SMALL_Q_CHAR                 0x0071 /**< A small letter Q - 'q' */
#define OL_SMALL_R_CHAR                 0x0072 /**< A small letter R - 'r' */
#define OL_SMALL_S_CHAR                 0x0073 /**< A small letter S - 's' */
#define OL_SMALL_T_CHAR                 0x0074 /**< A small letter T - 't' */
#define OL_SMALL_U_CHAR                 0x0075 /**< A small letter U - 'u' */
#define OL_SMALL_V_CHAR                 0x0076 /**< A small letter V - 'v' */
#define OL_SMALL_W_CHAR                 0x0077 /**< A small letter W - 'w' */
#define OL_SMALL_X_CHAR                 0x0078 /**< A small letter X - 'x' */
#define OL_SMALL_Y_CHAR                 0x0079 /**< A small letter Y - 'y' */
#define OL_SMALL_Z_CHAR                 0x007A /**< A small letter Z - 'z' */
#define OL_LEFT_CURLY_BRACE_CHAR        0x007B /**< A left curly brace - '{' */
#define OL_VERTICAL_BAR_CHAR            0x007C /**< A vertical bar - '|' */
#define OL_RIGHT_CURLY_BRACE_CHAR       0x007D /**< A right curly brace - '}' */
#define OL_TILDE_CHAR                   0x007E /**< A tilde - '~' */
/*@}*/

#endif
