/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

public class SolexaQualityConverter {
    public static final int SOLEXA_ADDEND = 64;
    private static SolexaQualityConverter singleton = null;
    private final byte[] phredScore = new byte[256];

    public static synchronized SolexaQualityConverter getSingleton() {
        if (singleton == null) {
            singleton = new SolexaQualityConverter();
        }
        return singleton;
    }

    private SolexaQualityConverter() {
        int i;
        for (i = 0; i < 64; ++i) {
            this.phredScore[i] = 0;
        }
        for (i = 64; i < this.phredScore.length; ++i) {
            this.phredScore[i] = this.convertSolexaQualityCharToPhredBinary(i);
        }
    }

    private byte convertSolexaQualityCharToPhredBinary(int solexaQuality) {
        return (byte)Math.round(10.0 * Math.log10(1.0 + Math.pow(10.0, (double)(solexaQuality - 64) / 10.0)));
    }

    public void convertSolexa_1_3_QualityCharsToPhredBinary(byte[] solexaQuals) {
        int i = 0;
        while (i < solexaQuals.length) {
            int n = i++;
            solexaQuals[n] = (byte)(solexaQuals[n] - 64);
        }
    }
}

