'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\" Copyright (c) 1998-2000 Ajuba Solutions.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH event n 8.3 Tk "Tk Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
event \- Miscellaneous event facilities: define virtual events and generate events
.SH SYNOPSIS
\fBevent\fI option \fR?\fIarg ...\fR?
.BE
.SH DESCRIPTION
.PP
The \fBevent\fR command provides several facilities for dealing with
window system events, such as defining virtual events and synthesizing
events.  The command has several different forms, determined by the
first argument.  The following forms are currently supported:
.\" METHOD: add
.TP
\fBevent add <<\fIvirtual\fB>>\fI sequence \fR?\fIsequence ...\fR?
.
Associates the virtual event \fIvirtual\fR with the physical
event sequence(s) given by the \fIsequence\fR arguments, so that
the virtual event will trigger whenever any one of the \fIsequence\fRs
occurs.
\fIVirtual\fR may be any string value and \fIsequence\fR may have
any of the values allowed for the \fIsequence\fR argument to the
\fBbind\fR command.
If \fIvirtual\fR is already defined, the new physical event sequences
add to the existing sequences for the event.
.\" METHOD: delete
.TP
\fBevent delete <<\fIvirtual\fB>> \fR?\fIsequence sequence ...\fR?
.
Deletes each of the \fIsequence\fRs from those associated with
the virtual event given by \fIvirtual\fR.
\fIVirtual\fR may be any string value and \fIsequence\fR may have
any of the values allowed for the \fIsequence\fR argument to the
\fBbind\fR command.
Any \fIsequence\fRs not currently associated with \fIvirtual\fR
are ignored.
If no \fIsequence\fR argument is provided, all physical event sequences
are removed for \fIvirtual\fR, so that the virtual event will not
trigger anymore.
.\" METHOD: generate
.TP
\fBevent generate \fIwindow event \fR?\fIoption value option value ...\fR?
.
Generates a window event and arranges for it to be processed just as if
it had come from the window system.
\fIWindow\fR gives the path name of the window for which the event
will be generated; it may also be an identifier (such as returned by
\fBwinfo id\fR) as long as it is for a window in the current application.
\fIEvent\fR provides a basic description of
the event, such as \fB<Shift-Button-2>\fR or \fB<<Paste>>\fR.
If \fIWindow\fR is empty the whole screen is meant, and coordinates
are relative to the screen.
\fIEvent\fR may have any of the forms allowed for the \fIsequence\fR
argument of the \fBbind\fR command except that it must consist
of a single event pattern, not a sequence.
\fIOption-value\fR pairs may be used to specify additional
attributes of the event, such as the x and y mouse position;  see
\fBEVENT FIELDS\fR below.  If the \fB\-when\fR option is not specified, the
event is processed immediately:  all of the handlers for the event
will complete before the \fBevent generate\fR command returns.
If the \fB\-when\fR option is specified then it determines when the
event is processed.  Certain events, such as key events, require
that the window has focus to receive the event properly.
.\" METHOD: info
.TP
\fBevent info \fR?\fB<<\fIvirtual\fB>>\fR?
.
Returns information about virtual events.
If the \fB<<\fIvirtual\fB>>\fR argument is omitted, the return value
is a list of all the virtual events that are currently defined.
If \fB<<\fIvirtual\fB>>\fR is specified then the return value is
a list whose elements are the physical event sequences currently
defined for the given virtual event;  if the virtual event is
not defined then an empty string is returned.
.RS
.PP
Note that virtual events that are not bound to physical event
sequences are \fInot\fR returned by \fBevent info\fR.
.RE
.SH "EVENT FIELDS"
.PP
The following options are supported for the \fBevent generate\fR
command.  These correspond to the
.QW %
expansions allowed in binding scripts for the \fBbind\fR command.
.\" OPTION: -above
.TP
\fB\-above\fI window\fR
.
\fIWindow\fR specifies the \fIabove\fR field for the event,
either as a window path name or as an integer window id.
Valid for \fBConfigure\fR events.
Corresponds to the \fB%a\fR substitution for binding scripts.
.\" OPTION: -borderwidth
.TP
\fB\-borderwidth\fI size\fR
.
\fISize\fR must be a screen distance;  it specifies the
\fIborder_width\fR field for the event.
Valid for \fBConfigure\fR events.
Corresponds to the \fB%B\fR substitution for binding scripts.
.\" OPTION: -button
.TP
\fB\-button\fI number\fR
.
\fINumber\fR must be an integer;  it specifies the \fIdetail\fR field
for a \fBButton\fR or \fBButtonRelease\fR event, overriding
any button  number provided in the base \fIevent\fR argument.
Corresponds to the \fB%b\fR substitution for binding scripts.
.\" OPTION: -count
.TP
\fB\-count\fI number\fR
.
\fINumber\fR must be an integer;  it specifies the \fIcount\fR field
for the event.  Valid for \fBExpose\fR events.
Corresponds to the \fB%c\fR substitution for binding scripts.
.\" OPTION: -data
.TP
\fB\-data\fI string\fR
.
\fIString\fR may be any value; it specifies the \fIuser_data\fR field
for the event.  Only valid for virtual events.  Corresponds to the
\fB%d\fR substitution for virtual events in binding scripts.
.\" OPTION: -delta
.TP
\fB\-delta\fI number\fR
.
\fINumber\fR must be an integer;  it specifies the \fIdelta\fR field
for the \fBMouseWheel\fR event.  The \fIdelta\fR refers to the
direction and magnitude the mouse wheel was rotated.  Note the value
is not a screen distance but are units of motion in the mouse wheel.
Typically these values are multiples of 120.  For example, 120 should
scroll the text widget up 4 lines and \-240 would scroll the text
widget down 8 lines.  Of course, other widgets may define different
behaviors for mouse wheel motion.  This field corresponds to the
\fB%D\fR substitution for binding scripts.
.\" OPTION: -detail
.TP
\fB\-detail\fI detail\fR
.
\fIDetail\fR specifies the \fIdetail\fR field for the event
and must be one of the following:
.RS
.DS
.ta 6c
\fBNotifyAncestor\fR	\fBNotifyNonlinearVirtual\fR
\fBNotifyDetailNone\fR	\fBNotifyPointer\fR
\fBNotifyInferior\fR	\fBNotifyPointerRoot\fR
\fBNotifyNonlinear\fR	\fBNotifyVirtual\fR
.DE
Valid for \fBEnter\fR, \fBLeave\fR, \fBFocusIn\fR and
\fBFocusOut\fR events.
Corresponds to the \fB%d\fR substitution for binding scripts.
.RE
.\" OPTION: -focus
.TP
\fB\-focus\fI boolean\fR
.
\fIBoolean\fR must be a boolean value;  it specifies the \fIfocus\fR
field for the event.
Valid for \fBEnter\fR and \fBLeave\fR events.
Corresponds to the \fB%f\fR substitution for binding scripts.
.\" OPTION: -height
.TP
\fB\-height\fI size\fR
.
\fISize\fR must be a screen distance;  it specifies the \fIheight\fR
field for the event.  Valid for \fBConfigure\fR events.
Corresponds to the \fB%h\fR substitution for binding scripts.
.\" OPTION: -keycode
.TP
\fB\-keycode\fI number\fR
.
\fINumber\fR  must be an integer;  it specifies the \fIkeycode\fR
field for the event.
Valid for \fBKey\fR and \fBKeyRelease\fR events.
Corresponds to the \fB%k\fR substitution for binding scripts.
.\" OPTION: -keysym
.TP
\fB\-keysym\fI name\fR
.
\fIName\fR must be the name of a valid keysym, such as \fBg\fR,
\fBspace\fR, or \fBReturn\fR;  its corresponding
keycode value is used as the \fIkeycode\fR field for event, overriding
any detail specified in the base \fIevent\fR argument.
Valid for \fBKey\fR and \fBKeyRelease\fR events.
Corresponds to the \fB%K\fR substitution for binding scripts.
.\" OPTION: -mode
.TP
\fB\-mode\fI notify\fR
.
\fINotify\fR specifies the \fImode\fR field for the event and must be
one of \fBNotifyNormal\fR, \fBNotifyGrab\fR, \fBNotifyUngrab\fR, or
\fBNotifyWhileGrabbed\fR.
Valid for \fBEnter\fR, \fBLeave\fR, \fBFocusIn\fR, and
\fBFocusOut\fR events.
Corresponds to the \fB%m\fR substitution for binding scripts.
.\" OPTION: -override
.TP
\fB\-override\fI boolean\fR
.
\fIBoolean\fR must be a boolean value;  it specifies the
\fIoverride_redirect\fR field for the event.
Valid for \fBMap\fR, \fBReparent\fR, and \fBConfigure\fR events.
Corresponds to the \fB%o\fR substitution for binding scripts.
.\" OPTION: -place
.TP
\fB\-place\fI where\fR
.
\fIWhere\fR specifies the \fIplace\fR field for the event;  it must be
either \fBPlaceOnTop\fR or \fBPlaceOnBottom\fR.
Valid for \fBCirculate\fR events.
Corresponds to the \fB%p\fR substitution for binding scripts.
.\" OPTION: -root
.TP
\fB\-root\fI window\fR
.
\fIWindow\fR must be either a window path name or an integer window
identifier;  it specifies the \fIroot\fR field for the event.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, and \fBMotion\fR
events.
Corresponds to the \fB%R\fR substitution for binding scripts.
.\" OPTION: -rootx
.TP
\fB\-rootx\fI coord\fR
.
\fICoord\fR must be a screen distance;  it specifies the \fIx_root\fR
field for the event.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, and \fBMotion\fR
events.  Corresponds to the \fB%X\fR substitution for binding scripts.
.\" OPTION: -rooty
.TP
\fB\-rooty\fI coord\fR
.
\fICoord\fR must be a screen distance;  it specifies the \fIy_root\fR
field for the event.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, and \fBMotion\fR
events.
Corresponds to the \fB%Y\fR substitution for binding scripts.
.\" OPTION: -sendevent
.TP
\fB\-sendevent\fI boolean\fR
.
\fIBoolean\fR must be a boolean value;  it specifies the \fIsend_event\fR
field for the event.  Valid for all events.  Corresponds to the
\fB%E\fR substitution for binding scripts.
.\" OPTION: -serial
.TP
\fB\-serial\fI number\fR
.
\fINumber\fR must be an integer;  it specifies the \fIserial\fR field
for the event.  Valid for all events.
Corresponds to the \fB%#\fR substitution for binding scripts.
.\" OPTION: -state
.TP
\fB\-state\fI state\fR
.
\fIState\fR specifies the \fIstate\fR field for the event.
For \fBKey\fR, \fBKeyRelease\fR, \fBButtons\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, and \fBMotion\fR events
it must be an integer value.
For \fBVisibility\fR events it must be one of \fBVisibilityUnobscured\fR,
\fBVisibilityPartiallyObscured\fR, or \fBVisibilityFullyObscured\fR.
This option overrides any modifiers such as \fBMeta\fR or \fBControl\fR
specified in the base \fIevent\fR.
Corresponds to the \fB%s\fR substitution for binding scripts.
.\" OPTION: -subwindow
.TP
\fB\-subwindow\fI window\fR
.
\fIWindow\fR specifies the \fIsubwindow\fR field for the event, either
as a path name for a Tk widget or as an integer window identifier.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, and \fBMotion\fR events.
Similar to \fB%S\fR substitution for binding scripts.
.\" OPTION: -time
.TP
\fB\-time\fI integer\fR
.
\fIInteger\fR must be an integer value;  it specifies the \fItime\fR field
for the event. Additionally, the special value \fBcurrent\fR is allowed;
this value will be substituted by the current event time.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBEnter\fR, \fBLeave\fR, \fBMotion\fR,
and \fBProperty\fR events.
Corresponds to the \fB%t\fR substitution for binding scripts.
.\" OPTION: -warp
.TP
\fB\-warp\fI boolean\fR
.
\fIboolean\fR must be a boolean value;  it specifies whether
the screen pointer should be warped as well.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, and \fBMotion\fR events.  The pointer will
only warp to a window if it is mapped.
.\" OPTION: -width
.TP
\fB\-width\fI size\fR
.
\fISize\fR must be a screen distance;  it specifies the \fIwidth\fR field
for the event.
Valid for \fBConfigure\fR events.
Corresponds to the \fB%w\fR substitution for binding scripts.
.\" OPTION: -when
.TP
\fB\-when\fI when\fR
.
\fIWhen\fR determines when the event will be processed;  it must have one
of the following values:
.RS
.IP \fBnow\fR 10
Process the event immediately, before the command returns.
This also happens if the \fB\-when\fR option is omitted.
.IP \fBtail\fR 10
Place the event on Tcl's event queue behind any events already
queued for this application.
.IP \fBhead\fR 10
Place the event at the front of Tcl's event queue, so that it
will be handled before any other events already queued.
.IP \fBmark\fR 10
Place the event at the front of Tcl's event queue but behind any
other events already queued with \fB\-when mark\fR.
This option is useful when generating a series of events that should
be processed in order but at the front of the queue.
.RE
.\" OPTION: -x
.TP
\fB\-x\fI coord\fR
.
\fICoord\fR must be a screen distance;  it specifies the \fIx\fR field
for the event.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBMotion\fR, \fBEnter\fR, \fBLeave\fR,
\fBExpose\fR, \fBConfigure\fR, \fBGravity\fR, and \fBReparent\fR
events.
Corresponds to the \fB%x\fR substitution for binding scripts.
If \fIWindow\fR is empty the coordinate is relative to the
screen, and this option corresponds to the \fB%X\fR substitution
for binding scripts.
.\" OPTION: -y
.TP
\fB\-y\fI coord\fR
.
\fICoord\fR must be a screen distance;  it specifies the \fIy\fR
field for the event.
Valid for \fBKey\fR, \fBKeyRelease\fR, \fBButton\fR,
\fBButtonRelease\fR, \fBMotion\fR, \fBEnter\fR, \fBLeave\fR,
\fBExpose\fR, \fBConfigure\fR, \fBGravity\fR, and \fBReparent\fR
events.
Corresponds to the \fB%y\fR substitution for binding scripts.
If \fIWindow\fR is empty the coordinate is relative to the
screen, and this option corresponds to the \fB%Y\fR substitution
for binding scripts.
.PP
Any options that are not specified when generating an event are filled
with the value 0, except for \fIserial\fR, which is filled with the
next X event serial number.
.SH "PREDEFINED VIRTUAL EVENTS"
.PP
Tk defines the following virtual events for the purposes of
notification:
.TP
\fB<<AltUnderlined>>\fR
.
This is sent to widget to notify it that the letter it has underlined
(as an accelerator indicator) with the \fB\-underline\fR option has
been pressed in combination with the Alt key. The usual response to
this is to either focus into the widget (or some related widget) or to
invoke the widget.
.TP
\fB<<Invoke>>\fR
.
This can be sent to some widgets (e.g. button, listbox, menu) as an
alternative to <space>.
.TP
\fB<<ListboxSelect>>\fR
.
This is sent to a listbox when the set of selected item(s) in the
listbox is updated.
.TP
\fB<<MenuSelect>>\fR
.
This is sent to a menu when the currently selected item in the menu
changes. It is intended for use with context-sensitive help systems.
.TP
\fB<<Modified>>\fR
.
This is sent to a text widget when the contents of the widget are
changed.
.TP
\fB<<Selection>>\fR
.
This is sent to a text widget when the selection in the widget is
changed.
.TP
\fB<<ThemeChanged>>\fR
.
This is sent to all widgets when the ttk theme changed. The ttk
widgets listen to this event and redisplay themselves when it fires.
The legacy widgets ignore this event.
.TP
\fB<<TkWorldChanged>>\fR
.
This event is sent to all widgets when a font is changed, for example,
by the use of [font configure].  The user_data field (%d) will have the
value "FontChanged".  For other system wide changes, this event will
be sent to all widgets, and the user_data field will indicate the
cause of the change.  NOTE: all tk and ttk widgets already handle this
event internally.
.TP
\fB<<TraverseIn>>\fR
.
This is sent to a widget when the focus enters the widget because of a
user-driven
.QW "tab to widget"
action.
.TP
\fB<<TraverseOut>>\fR
.
This is sent to a widget when the focus leaves the widget because of a
user-driven
.QW "tab to widget"
action.
.TP
\fB<<UndoStack>>\fR
.
This is sent to a text widget when its undo stack or redo stack becomes
empty or unempty.
.TP
\fB<<WidgetViewSync>>\fR
.
This is sent to a text widget when its internal data become obsolete,
and again when these internal data are back in sync with the widget
view. The detail field (%d substitution) is either true (when the
widget is in sync) or false (when it is not).
.PP
Tk defines the following virtual events for the purposes of unifying
bindings across multiple platforms. Users expect them to behave in the
following way:
.TP
\fB<<Clear>>\fR
.
Delete the currently selected widget contents.
.TP
\fB<<Copy>>\fR
.
Copy the currently selected widget contents to the clipboard.
.TP
\fB<<Cut>>\fR
.
Move the currently selected widget contents to the clipboard.
.TP
\fB<<LineEnd>>\fR
.
Move to the end of the line in the current widget while deselecting any
selected contents.
.TP
\fB<<LineStart>>\fR
.
Move to the start of the line in the current widget while deselecting any
selected contents.
.TP
\fB<<NextChar>>\fR
.
Move to the next item (i.e., visible character) in the current widget while
deselecting any selected contents.
.TP
\fB<<NextLine>>\fR
.
Move to the next line in the current widget while deselecting any selected
contents.
.TP
\fB<<NextPara>>\fR
.
Move to the next paragraph in the current widget while deselecting any
selected contents.
.TP
\fB<<NextWord>>\fR
.
Move to the next group of items (i.e., visible word) in the current widget
while deselecting any selected contents.
.TP
\fB<<Paste>>\fR
.
Replace the currently selected widget contents with the contents of
the clipboard.
.TP
\fB<<PasteSelection>>\fR
.
Insert the contents of the selection at the mouse location. (This
event has meaningful \fB%x\fR and \fB%y\fR substitutions).
.TP
\fB<<PrevChar>>\fR
.
Move to the previous item (i.e., visible character) in the current widget
while deselecting any selected contents.
.TP
\fB<<PrevLine>>\fR
.
Move to the previous line in the current widget while deselecting any selected
contents.
.TP
\fB<<PrevPara>>\fR
.
Move to the previous paragraph in the current widget while deselecting any
selected contents.
.TP
\fB<<PrevWindow>>\fR
.
Traverse to the previous window.
.TP
\fB<<PrevWord>>\fR
.
Move to the previous group of items (i.e., visible word) in the current widget
while deselecting any selected contents.
.TP
\fB<<Redo>>\fR
.
Redo one undone action.
.TP
\fB<<SelectAll>>\fR
.
Set the range of selected contents to the complete widget.
.TP
\fB<<SelectLineEnd>>\fR
.
Move to the end of the line in the current widget while extending the range
of selected contents.
.TP
\fB<<SelectLineStart>>\fR
.
Move to the start of the line in the current widget while extending the range
of selected contents.
.TP
\fB<<SelectNextChar>>\fR
.
Move to the next item (i.e., visible character) in the current widget while
extending the range of selected contents.
.TP
\fB<<SelectNextLine>>\fR
.
Move to the next line in the current widget while extending the range of
selected contents.
.TP
\fB<<SelectNextPara>>\fR
.
Move to the next paragraph in the current widget while extending the range
of selected contents.
.TP
\fB<<SelectNextWord>>\fR
.
Move to the next group of items (i.e., visible word) in the current widget
while extending the range of selected contents.
.TP
\fB<<SelectNone>>\fR
.
Reset the range of selected contents to be empty.
.TP
\fB<<SelectPrevChar>>\fR
.
Move to the previous item (i.e., visible character) in the current widget
while extending the range of selected contents.
.TP
\fB<<SelectPrevLine>>\fR
.
Move to the previous line in the current widget while extending the range of
selected contents.
.TP
\fB<<SelectPrevPara>>\fR
.
Move to the previous paragraph in the current widget while extending the
range of selected contents.
.TP
\fB<<SelectPrevWord>>\fR
.
Move to the previous group of items (i.e., visible word) in the current widget
while extending the range of selected contents.
.TP
\fB<<ToggleSelection>>\fR
.
Toggle the selection.
.TP
\fB<<Undo>>\fR
.
Undo the last action.
.SH EXAMPLES
.SS "MAPPING KEYS TO VIRTUAL EVENTS"
.PP
In order for a virtual event binding to trigger, two things must
happen.  First, the virtual event must be defined with the
\fBevent add\fR command.  Second, a binding must be created for
the virtual event with the \fBbind\fR command.
Consider the following virtual event definitions:
.PP
.CS
\fBevent add\fR <<Paste>> <Control-y>
\fBevent add\fR <<Paste>> <Button-2>
\fBevent add\fR <<Save>> <Control-X><Control-S>
\fBevent add\fR <<Save>> <Shift-F12>
if {[tk windowingsystem] eq "aqua"} {
    \fBevent add\fR <<Save>> <Command-s>
}
.CE
.PP
In the \fBbind\fR command, a virtual event can be bound like any other
builtin event type as follows:
.PP
.CS
bind Entry <<Paste>> {%W insert [selection get]}
.CE
.PP
The double angle brackets are used to specify that a virtual event is being
bound.  If the user types Control-y or presses button 2, or if
a \fB<<Paste>>\fR virtual event is synthesized with \fBevent generate\fR,
then the \fB<<Paste>>\fR binding will be invoked.
.PP
If a virtual binding has the exact same sequence as a separate
physical binding, then the physical binding will take precedence.
Consider the following example:
.PP
.CS
\fBevent add\fR <<Paste>> <Control-y> <Meta-Control-y>
bind Entry <Control-y> {puts Control-y}
bind Entry <<Paste>> {puts Paste}
.CE
.PP
When the user types Control-y the \fB<Control-y>\fR binding
will be invoked, because a physical event is considered
more specific than a virtual event, all other things being equal.
However, when the user types Meta-Control-y the
\fB<<Paste>>\fR binding will be invoked, because the
\fBMeta\fR modifier in the physical pattern associated with the
virtual binding is more specific than the \fB<Control-y\fR> sequence for
the physical event.
.PP
Bindings on a virtual event may be created before the virtual event exists.
Indeed, the virtual event never actually needs to be defined, for instance,
on platforms where the specific virtual event would be meaningless or
ungeneratable.
.PP
When a definition of a virtual event changes at run time, all windows
will respond immediately to the new definition.
Starting from the preceding example, if the following code is executed:
.PP
.CS
bind Entry <Control-y> {}
\fBevent add\fR <<Paste>> <F6>
.CE
.PP
the behavior will change such in two ways.  First, the shadowed
\fB<<Paste>>\fR binding will emerge.
Typing Control-y will no longer invoke the \fB<Control-y>\fR binding,
but instead invoke the virtual event \fB<<Paste>>\fR.  Second,
pressing the F6 key will now also invoke the \fB<<Paste>>\fR binding.
.SS "MOVING THE MOUSE POINTER"
.PP
Sometimes it is useful to be able to really move the mouse pointer. For
example, if you have some software that is capable of demonstrating directly
to the user how to use the program. To do this, you need to
.QW warp
the mouse around by using \fBevent generate\fR, like this:
.PP
.CS
for {set xy 0} {$xy < 200} {incr xy} {
    \fBevent generate\fR . <Motion> -x $xy -y $xy -warp 1
    update
    after 50
}
.CE
.PP
Note that it is usually considered bad style to move the mouse pointer for the
user because it removes control from them. Therefore this technique should be
used with caution. Also note that it is not guaranteed to function on all
platforms.
.SH "SEE ALSO"
bind(n)
.SH KEYWORDS
event, binding, define, handle, virtual event
'\" Local Variables:
'\" mode: nroff
'\" End:
