#!/bin/sh
# $Id: dwf-export.sh 7458 2021-01-10 15:31:24Z flaterco $
set -e
PREFIX=harmonics-dwf-
DATESTAMP=`date +%Y%m%d`
ID=${PREFIX}${DATESTAMP}
cd /tmp
mkdir ${ID}
cd ${ID}
tar xJf "/tmp/pkgbuild/math/harmbase2/work/.destdir/usr/pkg/share/harmbase2/boilerplate.txz"
pg_dump --no-owner harmbase2 | grep -v "^--" > ${ID}.sql
cd ..
tar cvJ --numeric-owner --file ${ID}-SQL.tar.xz ${ID}
rm ${ID}/${ID}.sql
"/tmp/pkgbuild/math/harmbase2/work/.destdir/usr/pkg/bin/hbexport" ${ID}/${ID}-free.tcd
tar cvJ --numeric-owner --file ${ID}-free.tar.xz ${ID}
rm -rf ${ID}
