package TDS::Admin::DirInfo;

use strict;
use vars qw(@ISA @EXPORT);
use Exporter;

use ObjectTemplate;

use TDS::DirInfo;
use TDS::Style;

@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes);

attributes qw(kind type ext
	      additional_path);

################################################################
sub initialize($)
{
    my $self = shift;

    # set default value
#    $self->kind("todo") unless $self->kind;
#    $self->type("dat") unless $self->type;
    
    $self->SUPER::initialize;
}

sub GetFilename
{
    my $self = shift;

    return sprintf("%s/%s",
		   $self->GetDirectory,
		   $self->GetOutputFilename);
}
sub GetDirectory($)
{
    my $self = shift;
    return sprintf("%s/%s",
		   $self->GetBaseDir,
		   $self->GetTypeDir);
}

sub GetWriteFilename($)
{
    shift->GetFilename;
}
sub GetOutputFilename($)
{
    my $self = shift;

    my $ext;
    if ($_ = $self->ext){
	$ext = $_;
	unless ($ext =~ /^[a-z]+$/){
	    die "illegal extention: $ext";
	}
    } else {
	$ext = ($self->type eq 'conf') ? 'conf' : 'dat';
    }
    return sprintf("%s.%s",
		   $self->GetKindBasename,
		   $ext);
}
sub GetBaseType($)
{
    my $self = shift;
    
    my %type_dir_map =
	('dat'=>'diary_dir',
	 'conf'=>'diary_dir',
	 'tdf'=>'diary_dir',
	 'log'=>'web_dir',
	 'admin'=>'web_dir');
    return $type_dir_map{$self->type};
}
sub GetBaseDir ($)
{
    my $self = shift;

    my $base_type = $self->GetBaseType;

    if ($base_type eq 'diary_dir'){
	return GetDiaryDir();
    } elsif ($base_type eq 'web_dir'){
	return GetWebDiaryDir();
    } elsif ($base_type eq 'customize_dir'){
	return GetCustomizeDir();
    } elsif ($base_type eq 'style_dir'){
	my $style_name = TDS::Style::GetStyleName();
	return GetWebDiaryDir() . "/styles/$style_name";
    } else {
	die "illegal base type: $base_type";
    }
}
sub GetTypeDir($)
{
    my $self = shift;

    if ($self->additional_path){
	return $self->additional_path;
    } else {
	return $self->type;
    }
}
sub GetKindBasename($)
{
    my $self = shift;
    my $kind = $self->kind;
    unless ($kind =~ /^[A-Za-z0-9\-_]+$/){
	die "illegal kind: $kind";
    }
    return $kind;
}
1;
