/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5CommonInformation {
    protected final String path;
    protected final HDF5ObjectType type;

    static HDF5ObjectType objectTypeIdToObjectType(int objectTypeId) {
        if (-1 == objectTypeId) {
            return HDF5ObjectType.NONEXISTENT;
        }
        if (HDF5Constants.H5O_TYPE_GROUP == objectTypeId) {
            return HDF5ObjectType.GROUP;
        }
        if (HDF5Constants.H5O_TYPE_DATASET == objectTypeId) {
            return HDF5ObjectType.DATASET;
        }
        if (HDF5Constants.H5O_TYPE_NAMED_DATATYPE == objectTypeId) {
            return HDF5ObjectType.DATATYPE;
        }
        if (objectTypeId >= HDF5Constants.H5O_TYPE_NTYPES) {
            int linkTypeId = objectTypeId - HDF5Constants.H5O_TYPE_NTYPES;
            if (linkTypeId == HDF5Constants.H5L_TYPE_SOFT) {
                return HDF5ObjectType.SOFT_LINK;
            }
            if (linkTypeId == HDF5Constants.H5L_TYPE_EXTERNAL) {
                return HDF5ObjectType.EXTERNAL_LINK;
            }
        }
        return HDF5ObjectType.OTHER;
    }

    HDF5CommonInformation(String path, HDF5ObjectType type) {
        assert (path != null);
        assert (type != null);
        this.path = path;
        this.type = type;
    }

    public void checkExists() throws HDF5JavaException {
        if (!this.exists()) {
            throw new HDF5JavaException("Link '" + this.getPath() + "' does not exist.");
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        int lastSlashIndex = this.path.lastIndexOf(47);
        if (lastSlashIndex <= 0) {
            return "/";
        }
        return this.path.substring(0, lastSlashIndex);
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    public HDF5ObjectType getType() {
        return this.type;
    }

    public boolean exists() {
        return HDF5ObjectType.exists(this.type);
    }

    public boolean isGroup() {
        return HDF5ObjectType.isGroup(this.type);
    }

    public boolean isDataSet() {
        return HDF5ObjectType.isDataSet(this.type);
    }

    public boolean isDataType() {
        return HDF5ObjectType.isDataType(this.type);
    }
}

