require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_LHASH_H)) {
    eval 'sub OPENSSL_LHASH_H () {1;}' unless defined(&OPENSSL_LHASH_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_LHASH_H () {1;}' unless defined(&HEADER_LHASH_H);
    }
    require 'openssl/e_os2.ph';
    require 'openssl/bio.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub DECLARE_LHASH_HASH_FN {
        my($name, $o_type) = @_;
	    eval q(\'unsigned long name\' &_LHASH_HASH( &const  &void *););
    }' unless defined(&DECLARE_LHASH_HASH_FN);
    eval 'sub IMPLEMENT_LHASH_HASH_FN {
        my($name, $o_type) = @_;
	    eval q(\'unsigned long name\' &_LHASH_HASH( &const  &void * &arg) {  &const $o_type * &a =  &arg;  &return $name &_hash( &a); });
    }' unless defined(&IMPLEMENT_LHASH_HASH_FN);
    eval 'sub LHASH_HASH_FN {
        my($name) = @_;
	    eval q($name &_LHASH_HASH);
    }' unless defined(&LHASH_HASH_FN);
    eval 'sub DECLARE_LHASH_COMP_FN {
        my($name, $o_type) = @_;
	    eval q(\'int\' $name &_LHASH_COMP( &const  &void *,  &const  &void *););
    }' unless defined(&DECLARE_LHASH_COMP_FN);
    eval 'sub IMPLEMENT_LHASH_COMP_FN {
        my($name, $o_type) = @_;
	    eval q(\'int\' $name &_LHASH_COMP( &const  &void * &arg1,  &const  &void * &arg2) {  &const $o_type * &a =  &arg1;  &const $o_type * &b =  &arg2;  &return $name &_cmp( &a, &b); });
    }' unless defined(&IMPLEMENT_LHASH_COMP_FN);
    eval 'sub LHASH_COMP_FN {
        my($name) = @_;
	    eval q($name &_LHASH_COMP);
    }' unless defined(&LHASH_COMP_FN);
    eval 'sub DECLARE_LHASH_DOALL_ARG_FN {
        my($name, $o_type, $a_type) = @_;
	    eval q( &void $name &_LHASH_DOALL_ARG( &void *,  &void *););
    }' unless defined(&DECLARE_LHASH_DOALL_ARG_FN);
    eval 'sub IMPLEMENT_LHASH_DOALL_ARG_FN {
        my($name, $o_type, $a_type) = @_;
	    eval q( &void $name &_LHASH_DOALL_ARG( &void * &arg1,  &void * &arg2) { $o_type * &a =  &arg1; $a_type * &b =  &arg2; $name &_doall_arg( &a,  &b); });
    }' unless defined(&IMPLEMENT_LHASH_DOALL_ARG_FN);
    eval 'sub LHASH_DOALL_ARG_FN {
        my($name) = @_;
	    eval q($name &_LHASH_DOALL_ARG);
    }' unless defined(&LHASH_DOALL_ARG_FN);
    eval 'sub LH_LOAD_MULT () {256;}' unless defined(&LH_LOAD_MULT);
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub _LHASH () { &OPENSSL_LHASH;}' unless defined(&_LHASH);
	eval 'sub LHASH_NODE () { &OPENSSL_LH_NODE;}' unless defined(&LHASH_NODE);
	eval 'sub lh_error () { &OPENSSL_LH_error;}' unless defined(&lh_error);
	eval 'sub lh_new () { &OPENSSL_LH_new;}' unless defined(&lh_new);
	eval 'sub lh_free () { &OPENSSL_LH_free;}' unless defined(&lh_free);
	eval 'sub lh_insert () { &OPENSSL_LH_insert;}' unless defined(&lh_insert);
	eval 'sub lh_delete () { &OPENSSL_LH_delete;}' unless defined(&lh_delete);
	eval 'sub lh_retrieve () { &OPENSSL_LH_retrieve;}' unless defined(&lh_retrieve);
	eval 'sub lh_doall () { &OPENSSL_LH_doall;}' unless defined(&lh_doall);
	eval 'sub lh_doall_arg () { &OPENSSL_LH_doall_arg;}' unless defined(&lh_doall_arg);
	eval 'sub lh_strhash () { &OPENSSL_LH_strhash;}' unless defined(&lh_strhash);
	eval 'sub lh_num_items () { &OPENSSL_LH_num_items;}' unless defined(&lh_num_items);
	unless(defined(&OPENSSL_NO_STDIO)) {
	    eval 'sub lh_stats () { &OPENSSL_LH_stats;}' unless defined(&lh_stats);
	    eval 'sub lh_node_stats () { &OPENSSL_LH_node_stats;}' unless defined(&lh_node_stats);
	    eval 'sub lh_node_usage_stats () { &OPENSSL_LH_node_usage_stats;}' unless defined(&lh_node_usage_stats);
	}
	eval 'sub lh_stats_bio () { &OPENSSL_LH_stats_bio;}' unless defined(&lh_stats_bio);
	eval 'sub lh_node_stats_bio () { &OPENSSL_LH_node_stats_bio;}' unless defined(&lh_node_stats_bio);
	eval 'sub lh_node_usage_stats_bio () { &OPENSSL_LH_node_usage_stats_bio;}' unless defined(&lh_node_usage_stats_bio);
    }
    eval 'sub LHASH_OF {
        my($type) = @_;
	    eval q(\'struct lhash_st_\'$type);
    }' unless defined(&LHASH_OF);
    eval 'sub DEFINE_LHASH_OF_INTERNAL {
        my($type) = @_;
	    eval q( &LHASH_OF($type) { \'union lh_\'$type &_dummy {  &void*  &d1; \'unsigned long d2\'; \'int\'  &d3; }  &dummy; };  &typedef  &int (* &lh_$type &_compfunc)( &const $type * &a,  &const $type * &b);  &typedef  &unsigned long (* &lh_$type &_hashfunc)( &const $type * &a);  &typedef  &void (* &lh_$type &_doallfunc)($type * &a);  &static  &ossl_unused  &ossl_inline $type * &ossl_check_$type &_lh_plain_type($type * &ptr) {  &return  &ptr; }  &static  &ossl_unused  &ossl_inline  &const $type * &ossl_check_const_$type &_lh_plain_type( &const $type * &ptr) {  &return  &ptr; }  &static  &ossl_unused  &ossl_inline  &const  &OPENSSL_LHASH * &ossl_check_const_$type &_lh_type( &const  &LHASH_OF($type) * &lh) {  &return ( &const  &OPENSSL_LHASH *) &lh; }  &static  &ossl_unused  &ossl_inline  &OPENSSL_LHASH * &ossl_check_$type &_lh_type( &LHASH_OF($type) * &lh) {  &return ( &OPENSSL_LHASH *) &lh; }  &static  &ossl_unused  &ossl_inline  &OPENSSL_LH_COMPFUNC  &ossl_check_$type &_lh_compfunc_type( &lh_$type &_compfunc  &cmp) {  &return ( &OPENSSL_LH_COMPFUNC) &cmp; }  &static  &ossl_unused  &ossl_inline  &OPENSSL_LH_HASHFUNC  &ossl_check_$type &_lh_hashfunc_type( &lh_$type &_hashfunc  &hfn) {  &return ( &OPENSSL_LH_HASHFUNC) &hfn; }  &static  &ossl_unused  &ossl_inline  &OPENSSL_LH_DOALL_FUNC  &ossl_check_$type &_lh_doallfunc_type( &lh_$type &_doallfunc  &dfn) {  &return ( &OPENSSL_LH_DOALL_FUNC) &dfn; }  &LHASH_OF($type));
    }' unless defined(&DEFINE_LHASH_OF_INTERNAL);
    eval 'sub DEFINE_LHASH_OF {
        my($type) = @_;
	    eval q( &LHASH_OF($type) { \'union lh_\'$type &_dummy {  &void*  &d1; \'unsigned long d2\'; \'int\'  &d3; }  &dummy; };  &static  &ossl_unused  &ossl_inline  &LHASH_OF($type) * &lh_$type &_new( &unsigned long (* &hfn)( &const $type *),  &int (* &cfn)( &const $type *,  &const $type *)) {  &return ( &LHASH_OF($type) *)  &OPENSSL_LH_new(( &OPENSSL_LH_HASHFUNC) &hfn, ( &OPENSSL_LH_COMPFUNC) &cfn); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_free( &LHASH_OF($type) * &lh) {  &OPENSSL_LH_free(( &OPENSSL_LHASH *) &lh); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_flush( &LHASH_OF($type) * &lh) {  &OPENSSL_LH_flush(( &OPENSSL_LHASH *) &lh); }  &static  &ossl_unused  &ossl_inline $type * &lh_$type &_insert( &LHASH_OF($type) * &lh, $type * &d) {  &return ($type *) &OPENSSL_LH_insert(( &OPENSSL_LHASH *) &lh,  &d); }  &static  &ossl_unused  &ossl_inline $type * &lh_$type &_delete( &LHASH_OF($type) * &lh,  &const $type * &d) {  &return ($type *) &OPENSSL_LH_delete(( &OPENSSL_LHASH *) &lh,  &d); }  &static  &ossl_unused  &ossl_inline $type * &lh_$type &_retrieve( &LHASH_OF($type) * &lh,  &const $type * &d) {  &return ($type *) &OPENSSL_LH_retrieve(( &OPENSSL_LHASH *) &lh,  &d); }  &static  &ossl_unused  &ossl_inline \'int\'  &lh_$type &_error( &LHASH_OF($type) * &lh) {  &return  &OPENSSL_LH_error(( &OPENSSL_LHASH *) &lh); }  &static  &ossl_unused  &ossl_inline \'unsigned long lh_\'$type &_num_items( &LHASH_OF($type) * &lh) {  &return  &OPENSSL_LH_num_items(( &OPENSSL_LHASH *) &lh); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_node_stats_bio( &const  &LHASH_OF($type) * &lh,  &BIO * &out) {  &OPENSSL_LH_node_stats_bio(( &const  &OPENSSL_LHASH *) &lh,  &out); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_node_usage_stats_bio( &const  &LHASH_OF($type) * &lh,  &BIO * &out) {  &OPENSSL_LH_node_usage_stats_bio(( &const  &OPENSSL_LHASH *) &lh,  &out); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_stats_bio( &const  &LHASH_OF($type) * &lh,  &BIO * &out) {  &OPENSSL_LH_stats_bio(( &const  &OPENSSL_LHASH *) &lh,  &out); }  &static  &ossl_unused  &ossl_inline \'unsigned long lh_\'$type &_get_down_load( &LHASH_OF($type) * &lh) {  &return  &OPENSSL_LH_get_down_load(( &OPENSSL_LHASH *) &lh); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_set_down_load( &LHASH_OF($type) * &lh, \'unsigned long dl\') {  &OPENSSL_LH_set_down_load(( &OPENSSL_LHASH *) &lh,  &dl); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_doall( &LHASH_OF($type) * &lh,  &void (* &doall)($type *)) {  &OPENSSL_LH_doall(( &OPENSSL_LHASH *) &lh, ( &OPENSSL_LH_DOALL_FUNC) &doall); }  &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_doall_arg( &LHASH_OF($type) * &lh,  &void (* &doallarg)($type *,  &void *),  &void * &arg) {  &OPENSSL_LH_doall_arg(( &OPENSSL_LHASH *) &lh, ( &OPENSSL_LH_DOALL_FUNCARG) &doallarg,  &arg); }  &LHASH_OF($type));
    }' unless defined(&DEFINE_LHASH_OF);
    eval 'sub IMPLEMENT_LHASH_DOALL_ARG_CONST {
        my($type, $argtype) = @_;
	    eval q( &int_implement_lhash_doall($type, $argtype,  &const $type));
    }' unless defined(&IMPLEMENT_LHASH_DOALL_ARG_CONST);
    eval 'sub IMPLEMENT_LHASH_DOALL_ARG {
        my($type, $argtype) = @_;
	    eval q( &int_implement_lhash_doall($type, $argtype, $type));
    }' unless defined(&IMPLEMENT_LHASH_DOALL_ARG);
    eval 'sub int_implement_lhash_doall {
        my($type, $argtype, $cbargtype) = @_;
	    eval q( &static  &ossl_unused  &ossl_inline  &void  &lh_$type &_doall_$argtype( &LHASH_OF($type) * &lh,  &void (* &fn)($cbargtype *, $argtype *), $argtype * &arg) {  &OPENSSL_LH_doall_arg(( &OPENSSL_LHASH *) &lh, ( &OPENSSL_LH_DOALL_FUNCARG) &fn, ( &void *) &arg); }  &LHASH_OF($type));
    }' unless defined(&int_implement_lhash_doall);
    eval 'sub lh_OPENSSL_STRING_new {
        my($hfn, $cmp) = @_;
	    eval q((( &LHASH_OF( &OPENSSL_STRING) *) &OPENSSL_LH_new( &ossl_check_OPENSSL_STRING_lh_hashfunc_type($hfn),  &ossl_check_OPENSSL_STRING_lh_compfunc_type($cmp))));
    }' unless defined(&lh_OPENSSL_STRING_new);
    eval 'sub lh_OPENSSL_STRING_free {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_free( &ossl_check_OPENSSL_STRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_STRING_free);
    eval 'sub lh_OPENSSL_STRING_flush {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_flush( &ossl_check_OPENSSL_STRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_STRING_flush);
    eval 'sub lh_OPENSSL_STRING_insert {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_STRING *) &OPENSSL_LH_insert( &ossl_check_OPENSSL_STRING_lh_type($lh),  &ossl_check_OPENSSL_STRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_STRING_insert);
    eval 'sub lh_OPENSSL_STRING_delete {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_STRING *) &OPENSSL_LH_delete( &ossl_check_OPENSSL_STRING_lh_type($lh),  &ossl_check_const_OPENSSL_STRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_STRING_delete);
    eval 'sub lh_OPENSSL_STRING_retrieve {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_STRING *) &OPENSSL_LH_retrieve( &ossl_check_OPENSSL_STRING_lh_type($lh),  &ossl_check_const_OPENSSL_STRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_STRING_retrieve);
    eval 'sub lh_OPENSSL_STRING_error {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_error( &ossl_check_OPENSSL_STRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_STRING_error);
    eval 'sub lh_OPENSSL_STRING_num_items {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_num_items( &ossl_check_OPENSSL_STRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_STRING_num_items);
    eval 'sub lh_OPENSSL_STRING_node_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_stats_bio( &ossl_check_const_OPENSSL_STRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_STRING_node_stats_bio);
    eval 'sub lh_OPENSSL_STRING_node_usage_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_usage_stats_bio( &ossl_check_const_OPENSSL_STRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_STRING_node_usage_stats_bio);
    eval 'sub lh_OPENSSL_STRING_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_stats_bio( &ossl_check_const_OPENSSL_STRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_STRING_stats_bio);
    eval 'sub lh_OPENSSL_STRING_get_down_load {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_get_down_load( &ossl_check_OPENSSL_STRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_STRING_get_down_load);
    eval 'sub lh_OPENSSL_STRING_set_down_load {
        my($lh, $dl) = @_;
	    eval q( &OPENSSL_LH_set_down_load( &ossl_check_OPENSSL_STRING_lh_type($lh), $dl));
    }' unless defined(&lh_OPENSSL_STRING_set_down_load);
    eval 'sub lh_OPENSSL_STRING_doall {
        my($lh, $dfn) = @_;
	    eval q( &OPENSSL_LH_doall( &ossl_check_OPENSSL_STRING_lh_type($lh),  &ossl_check_OPENSSL_STRING_lh_doallfunc_type($dfn)));
    }' unless defined(&lh_OPENSSL_STRING_doall);
    eval 'sub lh_OPENSSL_CSTRING_new {
        my($hfn, $cmp) = @_;
	    eval q((( &LHASH_OF( &OPENSSL_CSTRING) *) &OPENSSL_LH_new( &ossl_check_OPENSSL_CSTRING_lh_hashfunc_type($hfn),  &ossl_check_OPENSSL_CSTRING_lh_compfunc_type($cmp))));
    }' unless defined(&lh_OPENSSL_CSTRING_new);
    eval 'sub lh_OPENSSL_CSTRING_free {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_free( &ossl_check_OPENSSL_CSTRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_CSTRING_free);
    eval 'sub lh_OPENSSL_CSTRING_flush {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_flush( &ossl_check_OPENSSL_CSTRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_CSTRING_flush);
    eval 'sub lh_OPENSSL_CSTRING_insert {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_CSTRING *) &OPENSSL_LH_insert( &ossl_check_OPENSSL_CSTRING_lh_type($lh),  &ossl_check_OPENSSL_CSTRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_CSTRING_insert);
    eval 'sub lh_OPENSSL_CSTRING_delete {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_CSTRING *) &OPENSSL_LH_delete( &ossl_check_OPENSSL_CSTRING_lh_type($lh),  &ossl_check_const_OPENSSL_CSTRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_CSTRING_delete);
    eval 'sub lh_OPENSSL_CSTRING_retrieve {
        my($lh, $ptr) = @_;
	    eval q((( &OPENSSL_CSTRING *) &OPENSSL_LH_retrieve( &ossl_check_OPENSSL_CSTRING_lh_type($lh),  &ossl_check_const_OPENSSL_CSTRING_lh_plain_type($ptr))));
    }' unless defined(&lh_OPENSSL_CSTRING_retrieve);
    eval 'sub lh_OPENSSL_CSTRING_error {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_error( &ossl_check_OPENSSL_CSTRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_CSTRING_error);
    eval 'sub lh_OPENSSL_CSTRING_num_items {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_num_items( &ossl_check_OPENSSL_CSTRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_CSTRING_num_items);
    eval 'sub lh_OPENSSL_CSTRING_node_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_stats_bio( &ossl_check_const_OPENSSL_CSTRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_CSTRING_node_stats_bio);
    eval 'sub lh_OPENSSL_CSTRING_node_usage_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_node_usage_stats_bio( &ossl_check_const_OPENSSL_CSTRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_CSTRING_node_usage_stats_bio);
    eval 'sub lh_OPENSSL_CSTRING_stats_bio {
        my($lh, $out) = @_;
	    eval q( &OPENSSL_LH_stats_bio( &ossl_check_const_OPENSSL_CSTRING_lh_type($lh), $out));
    }' unless defined(&lh_OPENSSL_CSTRING_stats_bio);
    eval 'sub lh_OPENSSL_CSTRING_get_down_load {
        my($lh) = @_;
	    eval q( &OPENSSL_LH_get_down_load( &ossl_check_OPENSSL_CSTRING_lh_type($lh)));
    }' unless defined(&lh_OPENSSL_CSTRING_get_down_load);
    eval 'sub lh_OPENSSL_CSTRING_set_down_load {
        my($lh, $dl) = @_;
	    eval q( &OPENSSL_LH_set_down_load( &ossl_check_OPENSSL_CSTRING_lh_type($lh), $dl));
    }' unless defined(&lh_OPENSSL_CSTRING_set_down_load);
    eval 'sub lh_OPENSSL_CSTRING_doall {
        my($lh, $dfn) = @_;
	    eval q( &OPENSSL_LH_doall( &ossl_check_OPENSSL_CSTRING_lh_type($lh),  &ossl_check_OPENSSL_CSTRING_lh_doallfunc_type($dfn)));
    }' unless defined(&lh_OPENSSL_CSTRING_doall);
    if(defined(&__cplusplus)) {
    }
}
1;
