/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DeflaterEngine;
import java.util.zip.DeflaterPending;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFLATED = 8;
    private static final int IS_SETDICT = 1;
    private static final int IS_FLUSHING = 4;
    private static final int IS_FINISHING = 8;
    private static final int INIT_STATE = 0;
    private static final int SETDICT_STATE = 1;
    private static final int INIT_FINISHING_STATE = 8;
    private static final int SETDICT_FINISHING_STATE = 9;
    private static final int BUSY_STATE = 16;
    private static final int FLUSHING_STATE = 20;
    private static final int FINISHING_STATE = 28;
    private static final int FINISHED_STATE = 30;
    private static final int CLOSED_STATE = 127;
    private int level;
    private boolean noHeader;
    private int state;
    private int totalOut;
    private DeflaterPending pending;
    private DeflaterEngine engine;

    public void reset() {
        this.state = this.noHeader ? 16 : 0;
        this.totalOut = 0;
        this.pending.reset();
        this.engine.reset();
    }

    public void end() {
        this.engine = null;
        this.pending = null;
        this.state = 127;
    }

    public int getAdler() {
        return this.engine.getAdler();
    }

    public int getTotalIn() {
        return this.engine.getTotalIn();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    protected void finalize() {
    }

    void flush() {
        this.state |= 4;
    }

    public void finish() {
        this.state |= 0xC;
    }

    public boolean finished() {
        boolean bl = false;
        if (this.state == 30 && this.pending.isFlushed()) {
            bl = true;
        }
        return bl;
    }

    public boolean needsInput() {
        return this.engine.needsInput();
    }

    public void setInput(byte[] input) {
        this.setInput(input, 0, input.length);
    }

    public void setInput(byte[] input, int off, int len) {
        if ((this.state & 8) != 0) {
            throw new IllegalStateException("finish()/end() already called");
        }
        this.engine.setInput(input, off, len);
    }

    public void setLevel(int lvl) {
        if (lvl == -1) {
            lvl = 6;
        } else if (lvl < 0 || lvl > 9) {
            throw new IllegalArgumentException();
        }
        if (this.level != lvl) {
            this.level = lvl;
            this.engine.setLevel(lvl);
        }
    }

    public void setStrategy(int stgy) {
        if (stgy != 0 && stgy != 1 && stgy != 2) {
            throw new IllegalArgumentException();
        }
        this.engine.setStrategy(stgy);
    }

    public int deflate(byte[] output) {
        return this.deflate(output, 0, output.length);
    }

    public int deflate(byte[] output, int offset, int length) {
        int origLength = length;
        if (this.state == 127) {
            throw new IllegalStateException("Deflater closed");
        }
        if (this.state < 16) {
            int header = 30720;
            int level_flags = this.level - 1 >> 1;
            if (level_flags < 0 || level_flags > 3) {
                level_flags = 3;
            }
            header |= level_flags << 6;
            if ((this.state & 1) != 0) {
                header |= 0x20;
            }
            header += 31 - header % 31;
            this.pending.writeShortMSB(header);
            if ((this.state & 1) != 0) {
                int chksum = this.engine.getAdler();
                this.engine.resetAdler();
                this.pending.writeShortMSB(chksum >> 16);
                this.pending.writeShortMSB(chksum & (char)-1);
            }
            this.state = 0x10 | this.state & 0xC;
        }
        while (true) {
            int count = this.pending.flush(output, offset, length);
            offset += count;
            this.totalOut += count;
            if ((length -= count) == 0 || this.state == 30) break;
            boolean bl = false;
            if ((this.state & 4) != 0) {
                bl = true;
            }
            boolean bl2 = false;
            if ((this.state & 8) != 0) {
                bl2 = true;
            }
            if (this.engine.deflate(bl, bl2)) continue;
            if (this.state == 16) {
                return origLength - length;
            }
            if (this.state == 20) {
                if (this.level != 0) {
                    int neededbits = 8 + (-this.pending.getBitCount() & 7);
                    while (neededbits > 0) {
                        this.pending.writeBits(2, 10);
                        neededbits -= 10;
                    }
                }
                this.state = 16;
                continue;
            }
            if (this.state != 28) continue;
            this.pending.alignToByte();
            if (!this.noHeader) {
                int adler = this.engine.getAdler();
                this.pending.writeShortMSB(adler >> 16);
                this.pending.writeShortMSB(adler & (char)-1);
            }
            this.state = 30;
        }
        return origLength - length;
    }

    public void setDictionary(byte[] dict) {
        this.setDictionary(dict, 0, dict.length);
    }

    public void setDictionary(byte[] dict, int offset, int length) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = 1;
        this.engine.setDictionary(dict, offset, length);
    }

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int lvl) {
        this(lvl, false);
    }

    public Deflater(int lvl, boolean nowrap) {
        if (lvl == -1) {
            lvl = 6;
        } else if (lvl < 0 || lvl > 9) {
            throw new IllegalArgumentException();
        }
        this.pending = new DeflaterPending();
        this.engine = new DeflaterEngine(this.pending);
        this.noHeader = nowrap;
        this.setStrategy(0);
        this.setLevel(lvl);
        this.reset();
    }
}

