/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.MenuContainer;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JSlider
extends JComponent
implements SwingConstants,
Accessible,
ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -1441275936141218479L;
    private transient boolean paintTicks;
    private transient boolean paintTrack;
    private transient boolean paintLabels;
    private transient Dictionary labelTable;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks;
    protected int orientation;
    private transient boolean isInverted;
    protected ChangeListener changeListener;
    protected transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public int getValue() {
        return this.sliderModel.getValue();
    }

    public void setValue(int value) {
        this.sliderModel.setValue(value);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((SliderUI)UIManager.getUI(this));
        this.invalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "SliderUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public final void stateChanged(ChangeEvent ce) {
                JSlider.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            Object object = changeListeners[i];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JSlider.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JSlider.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.sliderModel) {
            BoundedRangeModel oldModel = this.sliderModel;
            this.sliderModel = model;
            oldModel.removeChangeListener(this.changeListener);
            this.sliderModel.addChangeListener(this.changeListener);
            this.firePropertyChange("model", oldModel, this.sliderModel);
        }
    }

    public int getMinimum() {
        return this.sliderModel.getMinimum();
    }

    public void setMinimum(int minimum) {
        int old = this.sliderModel.getMinimum();
        this.sliderModel.setMinimum(minimum);
        if (minimum != old) {
            this.firePropertyChange("minimum", old, minimum);
        }
    }

    public int getMaximum() {
        return this.sliderModel.getMaximum();
    }

    public void setMaximum(int maximum) {
        int old = this.sliderModel.getMaximum();
        this.sliderModel.setMaximum(maximum);
        if (maximum != old) {
            this.firePropertyChange("maximum", old, maximum);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.sliderModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean adjusting) {
        this.sliderModel.setValueIsAdjusting(adjusting);
    }

    public int getExtent() {
        return this.sliderModel.getExtent();
    }

    public void setExtent(int extent) {
        this.sliderModel.setExtent(extent);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary table) {
        if (table != this.labelTable) {
            Dictionary oldTable = this.labelTable;
            this.labelTable = table;
            this.firePropertyChange("labelTable", oldTable, this.labelTable);
        }
    }

    protected void updateLabelUIs() {
        if (this.labelTable == null) {
            return;
        }
        Enumeration list2 = this.labelTable.elements();
        while (list2.hasMoreElements()) {
            JLabel label = (JLabel)list2.nextElement();
            label.updateUI();
        }
    }

    public Hashtable createStandardLabels(int increment) {
        return this.createStandardLabels(increment, this.sliderModel.getMinimum());
    }

    public Hashtable createStandardLabels(int increment, int start) {
        if (increment <= 0) {
            throw new IllegalArgumentException("Requires 'increment' > 0.");
        }
        if (start < this.getMinimum() || start > this.getMaximum()) {
            throw new IllegalArgumentException("The 'start' value is out of range.");
        }
        Hashtable table = new Hashtable();
        int max = this.sliderModel.getMaximum();
        int i = start;
        while (i <= max) {
            JLabel label = new JLabel(String.valueOf(i));
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            Dimension dim = label.getPreferredSize();
            label.setBounds(label.getX(), label.getY(), (int)dim.getWidth(), (int)dim.getHeight());
            table.put(new Integer(i), label);
            i += increment;
        }
        return table;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted != inverted) {
            boolean oldInverted = this.isInverted;
            this.isInverted = inverted;
            this.firePropertyChange("inverted", oldInverted, this.isInverted);
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int spacing) {
        if (this.majorTickSpacing != spacing) {
            int oldSpacing = this.majorTickSpacing;
            this.majorTickSpacing = spacing;
            this.firePropertyChange("majorTickSpacing", oldSpacing, this.majorTickSpacing);
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int spacing) {
        if (this.minorTickSpacing != spacing) {
            int oldSpacing = this.minorTickSpacing;
            this.minorTickSpacing = spacing;
            this.firePropertyChange("minorTickSpacing", oldSpacing, this.minorTickSpacing);
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean snap) {
        if (snap != this.snapToTicks) {
            this.snapToTicks = snap;
            this.firePropertyChange("snapToTicks", snap ^ true, snap);
        }
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean paint) {
        if (paint != this.paintTicks) {
            boolean oldPaintTicks = this.paintTicks;
            this.paintTicks = paint;
            this.firePropertyChange("paintTicks", oldPaintTicks, this.paintTicks);
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean paint) {
        if (this.paintTrack != paint) {
            this.paintTrack = paint;
            this.firePropertyChange("paintTrack", paint ^ true, paint);
        }
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean paint) {
        if (paint != this.paintLabels) {
            this.paintLabels = paint;
            if (paint && this.majorTickSpacing > 0) {
                this.labelTable = this.createStandardLabels(this.majorTickSpacing);
            }
            this.firePropertyChange("paintLabels", paint ^ true, paint);
        }
    }

    protected String paramString() {
        return "JSlider";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.paintTicks = false;
        this.paintTrack = true;
        this.paintLabels = false;
        this.snapToTicks = false;
        this.orientation = 0;
    }

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int orientation) {
        this(orientation, 0, 100, 50);
    }

    public JSlider(int minimum, int maximum) {
        this(0, minimum, maximum, (maximum + minimum) / 2);
    }

    public JSlider(int minimum, int maximum, int value) {
        this(0, minimum, maximum, value);
    }

    public JSlider(int orientation, int minimum, int maximum, int value) {
        this.this();
        this.sliderModel = new DefaultBoundedRangeModel(value, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider(BoundedRangeModel model) {
        this.this();
        this.sliderModel = model;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -6301740148041106789L;

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        protected AccessibleJSlider() {
        }
    }
}

