# Calendar examples

The module provides different examples of calendars, made-up using the machinery provided in the t-pocketdiary module.

The user is completely free to change and adapt the examples to his needs. The examples are in the Public Domain. 

## A5-day_per_page.tex

This calendar produces single page day-calendars for the whole year. The page carries in the header the month's name and the year.
On the next line it places the the day-number of the month with the day-name. This is followed by the week-number and the the day-number of the year. In the following field the name of the Christian holiday is typeset. In the last block data concerning the moon-cycle and sun data are provided.
The page is filled with a hourly schedule from 06:00 to 22:00
The footer displays information according to the setup established in the variable set. 

This example has different modes for the production either an A5 or an A6 sized calendar. The A5 sized calendar is arranged A4 landscape paper for sections of 16 pages consisting out of 4 sheets each carrying 2 pages recto and verso. The A6 version is also arranged for sections of 16 pages typeset on A4 portrait paper. The sections consist out of 2 sheets carrying 4 pages recto and 4 pages verso.

## A6-1week_per_2pages.tex

The calendar is made up as a table for one week, spread over two pages.
The header displays the month's name and to the right the week-number and the year.
The table is split in two parts after Thursday. Friday and the weekend is placed on the second page. The Weekend is split into two cells on one row.
On Tuesdays moon- and sun-data are desplayed. If the day is Chrstian holiday, it is printed in red and the name of the holiday is typeset.


## Menu-calendar.tex

The menu-calendar is based on week-number, i.e. in years, where the first of January is not in the first week, those days are left out. Each week is spread over two pages.
The header shows the month's name and to the right the week-number.
The year is typeset in the footer.
Each day shows the day-number and the name of the day. Christian holidays are marked red and the name of the holiday is typeset right to the day-name. There is a larger space for notes concerning the menu and each day has a "Comment" line.

## Photocalendar.tex

The Phoro calendar is made-up on A4 paper. It contains a title page with one picture, followed by 12 pages each reserved for one month. On each of those pages there is a picture and at the bottom a month-table is placed. Centered above the table the month's name and the year is typeset. This example is set-up such, that one can only put either landscape or portrait pictures.

## Sundata-calendar.tex

This calendar puts the moon- and sun-data per day in a table. It is arranged as a A6-booklet consisting out of two sections. Sewn together and set into a cover this gives a handy brochure to keep track of moon-cycle and the daily sunrise, sunset and day-light hours.

