/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Default defines for most configuration variables
****/

/*+ The default global configuration file. +*/
#define DEF_CONFIG "/usr/pkg/etc/ubs/ubs.conf"

/*+ Where the queue file is located +*/
#define DEF_QUEUE "var/queue"

/*+ The location of the error log +*/
#define DEF_ERRORLOG "log/error.log"

/*+ Default playlist log location +*/
#define DEF_SONGLOG "log/playlist.log"

/*+ Default debugging level +*/
#define DEF_LOGLEVEL LOG_ERROR

/*+ Default debugging level in string form (for parsing configuration files) +*/
#define DEF_LOGLEVEL_STR "2"

// ubs-play Defaults

/*+ Default media player.  This is the program that actually plays the music on the air.  Use the string '%s' in this directive, and that's where the filename will be placed. +*/
#define DEF_MEDIA "ogg123 -q %s"

// ubs-event Defaults
/*+ Number of known events +*/
#define DEF_NUMEVENTS "0"

// ubs-sched Defaults

/*+ If the UBS can't find a show for the given timeslot, then this is the directory it pulls music from +*/
#define DEF_MISCDIR "misc"

/*+ Number of known shows +*/
#define DEF_NUMSHOWS "0"

/*+ How far back to look in the logs +*/
#define DEF_SEARCHBACK "30"
