package org.cdavies.itunes;

public class ItunesHost {
	
	private String _hostName;
	private int _version;
	private String _name;
	
	public static int LEGACY = 1;
	public static int ITUNES_4 = 2;
	public static int ITUNES_45 = 3;
	
	public ItunesHost(String addr, String name, int version) {
		
		_hostName = addr;
		_name = name;
		
		if (_version > 3)
			_version = ITUNES_45;
		else
			_version = version;
		
	}
	
	public int getVersion() {
		
		return _version;
		
	}
	
	public String getName() {
		
		return _name;
		
	}
	
	public String getAddress() {
		
		return _hostName;
		
	}
	
	public String toString() {
		
		return _name;
		
	}
	
	public boolean equals(Object o) {
		return _name.equals(((ItunesHost)o).getName());
	}
	
}
