/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.igoweb.games.Clock;
import org.igoweb.go.Game;
import org.igoweb.go.Loc;
import org.igoweb.go.sgf.GameUpdater;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.go.swing.GobanWidget;
import org.igoweb.util.Event;

public class Updater
extends GameUpdater {
    private final WeakReference<GobanWidget> gobanRef;
    private final boolean markKos;
    private boolean koPresent = false;

    public Updater(GobanWidget goban, Tree tree, boolean markKos, Clock wClock, Clock bClock) {
        super(tree, goban.getGame(), wClock, bClock);
        this.markKos = markKos;
        this.gobanRef = new WeakReference<GobanWidget>(goban);
        this.markNode(goban);
    }

    @Override
    protected void treeEvent(Event event) {
        GobanWidget goban;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Calling GUI updater from a non-dispatch thread");
        }
        super.treeEvent(event);
        if (event.type == 7) {
            GobanWidget goban2 = (GobanWidget)this.gobanRef.get();
            if (goban2 == null) {
                return;
            }
            goban2.clearMarks();
            this.koPresent = false;
            this.markNode(goban2);
        } else if (event.source == this.tree.getActiveNode() && (event.type == 0 || event.type == 1) && (goban = (GobanWidget)this.gobanRef.get()) != null) {
            if (((Prop)event.arg).type == 14) {
                if (this.koPresent) {
                    goban.clearMarks();
                }
                this.markNode(goban);
                goban.enablePassBut();
            } else if (event.type == 0) {
                this.markProp(goban, (Prop)event.arg);
            } else {
                this.unmarkProp(goban, (Prop)event.arg);
            }
        }
    }

    private void markNode(GobanWidget goban) {
        Game game;
        Iterator<Prop> params = this.tree.getActiveNode().iterator();
        while (params.hasNext()) {
            this.markProp(goban, params.next());
        }
        if (this.markKos && (game = this.getGame()) != null) {
            Iterator<Loc> locs = game.allLocs();
            while (locs.hasNext()) {
                Loc loc = locs.next();
                if (game.isLegal(loc) != 2) continue;
                this.koPresent = true;
                goban.setMark(loc, 256);
            }
        }
    }

    protected void markProp(GobanWidget goban, Prop param) {
        if (param.type == 19) {
            goban.setLabel(param.getLoc(), param.getText());
        } else {
            int mark = this.markMask(param);
            if (mark != 0) {
                goban.setMark(param.getLoc(), this.markMask(param));
            }
        }
    }

    protected int markMask(Prop param) {
        switch (param.type) {
            case 19: {
                return 2;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 8;
            }
            case 15: {
                return 16;
            }
            case 14: {
                return 4096;
            }
            case 22: {
                return param.getColor() == 0 ? 32 : 64;
            }
            case 30: {
                return 2048;
            }
            case 23: {
                return 128;
            }
        }
        return 0;
    }

    protected void unmarkProp(GobanWidget goban, Prop param) {
        int mask = this.markMask(param);
        if (mask != 0) {
            Loc loc = param.getLoc();
            goban.clearMark(loc, mask);
        }
    }
}

