/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new MultiPixelPackedSampleModel(this.dataType, w, h, this.numberOfBits);
    }

    public DataBuffer createDataBuffer() {
        int size = this.scanlineStride * this.height;
        return Buffers.createBuffer(this.getDataType(), size);
    }

    public int getNumDataElements() {
        return 1;
    }

    public int[] getSampleSize() {
        return this.sampleSize;
    }

    public int getSampleSize(int band) {
        return this.sampleSize[0];
    }

    public int getOffset(int x, int y) {
        return this.scanlineStride * y + (this.dataBitOffset + x * this.numberOfBits) / this.elemBits;
    }

    public int getBitOffset(int x) {
        return (this.dataBitOffset + x * this.numberOfBits) % this.elemBits;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.numberOfBits;
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int numBands = bands.length;
        if (numBands != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel only supports one band");
        }
        return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int pixel = this.getSample(x, y, 0, data);
        switch (this.getTransferType()) {
            case 0: {
                if (obj == null) {
                    obj = new byte[1];
                }
                ((byte[])obj)[0] = (byte)pixel;
                return obj;
            }
            case 1: {
                if (obj == null) {
                    obj = new short[1];
                }
                ((short[])obj)[0] = (short)pixel;
                return obj;
            }
            case 3: {
                if (obj == null) {
                    obj = new int[1];
                }
                ((int[])obj)[0] = pixel;
                return obj;
            }
        }
        throw new ClassCastException();
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (iArray == null) {
            iArray = new int[]{this.getSample(x, y, 0, data)};
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.getOffset(x, y);
        if (iArray == null) {
            iArray = new int[w * h];
        }
        int outOffset = 0;
        y = 0;
        while (y < h) {
            int lineOffset = offset;
            x = 0;
            while (x < w) {
                int samples = data.getElem(lineOffset++);
                int b = 0;
                while (b < this.numElems && x < w) {
                    iArray[outOffset++] = (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
                    ++x;
                    ++b;
                }
            }
            offset += this.scanlineStride;
            ++y;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        int pos = (this.dataBitOffset + x * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int offset = this.getOffset(x, y);
        int samples = data.getElem(offset);
        return (samples & this.bitMasks[pos]) >>> this.bitOffsets[pos];
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int transferType = this.getTransferType();
        if (this.getTransferType() != data.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), does not match data buffer type (" + data.getDataType() + ").");
        }
        int offset = this.getOffset(x, y);
        try {
            switch (transferType) {
                case 0: {
                    DataBufferByte out = (DataBufferByte)data;
                    byte[] in = (byte[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
                case 1: {
                    DataBufferUShort out = (DataBufferUShort)data;
                    short[] in = (short[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
                case 3: {
                    DataBufferInt out = (DataBufferInt)data;
                    int[] in = (int[])obj;
                    out.getData()[offset] = in[0];
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While writing data elements, x=" + x + ", y=" + y + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + offset + ", data.getSize()=" + data.getSize() + ", data.getOffset()=" + data.getOffset() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        this.setSample(x, y, 0, iArray[0], data);
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        int bitpos = (this.dataBitOffset + x * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int offset = this.getOffset(x, y);
        s <<= this.bitOffsets[bitpos];
        int sample = data.getElem(offset);
        data.setElem(offset, sample |= (s &= this.bitMasks[bitpos]));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("[");
        result.append("scanlineStride=").append(this.scanlineStride);
        int i = 0;
        while (i < this.bitMasks.length) {
            result.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits) {
        this(dataType, w, h, numberOfBits, 0, 0);
    }

    public MultiPixelPackedSampleModel(int dataType, int w, int h, int numberOfBits, int scanlineStride, int dataBitOffset) {
        super(dataType, w, h, 1);
        switch (dataType) {
            case 0: {
                this.elemBits = 8;
                break;
            }
            case 1: {
                this.elemBits = 16;
                break;
            }
            case 3: {
                this.elemBits = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("MultiPixelPackedSampleModel unsupported dataType");
            }
        }
        this.dataBitOffset = dataBitOffset;
        this.numberOfBits = numberOfBits;
        if (numberOfBits > this.elemBits) {
            throw new RasterFormatException("MultiPixelPackedSampleModel pixel size larger than dataType");
        }
        switch (numberOfBits) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new RasterFormatException("MultiPixelPackedSampleModel pixel size not 2^n bits");
            }
        }
        this.numElems = this.elemBits / numberOfBits;
        if (scanlineStride == 0) {
            scanlineStride = (dataBitOffset + w * numberOfBits) / this.elemBits;
        }
        this.scanlineStride = scanlineStride;
        this.sampleSize = new int[1];
        this.sampleSize[0] = numberOfBits;
        this.bitMasks = new int[this.numElems];
        this.bitOffsets = new int[this.numElems];
        int i = 0;
        while (i < this.numElems) {
            this.bitOffsets[this.numElems - i - 1] = numberOfBits * i;
            this.bitMasks[this.numElems - i - 1] = (1 << numberOfBits) - 1 << this.bitOffsets[this.numElems - i - 1];
            ++i;
        }
    }
}

