//
// $Id: Types.h,v 1.7 2007/04/15 23:32:57 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(TYPES_OL_GUARD)
#if !defined(OL_GENERATING_DOCUMENTATION)
#define TYPES_OL_GUARD
#endif

#include <ObjectiveLib/Config.h>
#if defined(OL_WINDOWS)
#include <windows.h>
#endif

/**
 * @file
 *
 * Types for general use.
 *
 * @ingroup Misc
 */

/**
 * The type used for file descriptors.
 *
 * @sa OLFileInputStream, OLFileOutputStream
 *
 * @ingroup Types
 */
#if defined(OL_WINDOWS)
typedef HANDLE ol_fd;
#else
typedef int ol_fd;
#endif

/**
 * Types of functors that can be created by OLFunctor#functorOfType:.
 *
 * @sa OLFunctor
 *
 * @ingroup Types
 */
typedef enum
{
    /** refers to OLDivides */
    OLFunctorType_Divides,
    /** refers to OLEqualTo */
    OLFunctorType_EqualTo,
    /** refers to OLGreater */
    OLFunctorType_Greater,
    /** refers to OLGreaterEqual */
    OLFunctorType_GreaterEqual,
    /** refers to OLLess */
    OLFunctorType_Less,
    /** refers to OLLessEqual */
    OLFunctorType_LessEqual,
    /** refers to OLLogicalAnd */
    OLFunctorType_LogicalAnd,
    /** refers to OLLogicalNot */
    OLFunctorType_LogicalNot,
    /** refers to OLLogicalOr */
    OLFunctorType_LogicalOr,
    /** refers to OLMinus */
    OLFunctorType_Minus,
    /** refers to OLModulus */
    OLFunctorType_Modulus,
    /** refers to OLMultiplies */
    OLFunctorType_Multiplies,
    /** refers to OLNegate */
    OLFunctorType_Negate,
    /** refers to OLNotEqualTo */
    OLFunctorType_NotEqualTo,
    /** refers to OLPlus */
    OLFunctorType_Plus
} OLFunctorType;

#endif
