/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public class ConcatGZIPInputStream
extends InputStream {
    private PushbackInputStream source;
    private GZIPHelperInputStream gzIn;

    public ConcatGZIPInputStream(InputStream in) throws IOException {
        this.source = new PushbackInputStream(in, 1024);
        this.nextGzipInputStream();
    }

    private void nextGzipInputStream() throws IOException {
        int r;
        boolean more = false;
        if (this.gzIn != null && this.gzIn.pushbackUnused() > 0) {
            more = true;
        }
        if (!more && (r = this.source.read()) != -1) {
            this.source.unread(r);
            more = true;
        }
        this.gzIn = more ? new GZIPHelperInputStream(this.source) : null;
    }

    public void close() throws IOException {
        this.gzIn = null;
        this.source.close();
    }

    public int read() throws IOException {
        int res = -1;
        while (res == -1 && this.gzIn != null) {
            res = this.gzIn.read();
            if (res != -1) continue;
            this.nextGzipInputStream();
        }
        return res;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int res = -1;
        while (res == -1 && this.gzIn != null) {
            res = this.gzIn.read(b, off, len);
            if (res != -1) continue;
            this.nextGzipInputStream();
        }
        return res;
    }

    public int read(byte[] b) throws IOException {
        int res = -1;
        while (res == -1 && this.gzIn != null) {
            res = this.gzIn.read(b);
            if (res != -1) continue;
            this.nextGzipInputStream();
        }
        return res;
    }

    private class GZIPHelperInputStream
    extends GZIPInputStream {
        private GZIPHelperInputStream(InputStream in) throws IOException {
            super(in);
        }

        private int pushbackUnused() throws IOException {
            int amount = this.inf.getRemaining() - 8;
            if (amount > 0) {
                ConcatGZIPInputStream.this.source.unread(this.buf, this.len - amount, amount);
            }
            return amount;
        }
    }
}

