/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.common.Display;
import org.diylc.common.EventType;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.boards.BlankBoard;
import org.diylc.components.boards.PerfBoard;
import org.diylc.components.boards.VeroBoard;
import org.diylc.components.connectivity.CopperTrace;
import org.diylc.components.connectivity.HookupWire;
import org.diylc.components.connectivity.Jumper;
import org.diylc.components.connectivity.SolderPad;
import org.diylc.components.misc.Label;
import org.diylc.components.passive.PotentiometerPanel;
import org.diylc.components.passive.RadialElectrolytic;
import org.diylc.components.passive.RadialFilmCapacitor;
import org.diylc.components.passive.Resistor;
import org.diylc.components.passive.Taper;
import org.diylc.components.semiconductors.DIL_IC;
import org.diylc.components.semiconductors.DiodePlastic;
import org.diylc.components.semiconductors.LED;
import org.diylc.components.semiconductors.TransistorTO92;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.presenter.CalcUtils;
import org.diylc.presenter.ComparatorFactory;
import org.diylc.presenter.PointConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProjectFileManager {
    private static final Logger LOG = Logger.getLogger(ProjectFileManager.class);
    private static final Size V1_GRID_SPACING = new Size((Double)0.1, SizeUnit.in);
    private static final Map<String, Color> V1_COLOR_MAP = new HashMap<String, Color>();
    private XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
    private XStream xStreamOld;
    private String currentFileName = null;
    private boolean modified = false;
    private MessageDispatcher<EventType> messageDispatcher;

    public ProjectFileManager(MessageDispatcher<EventType> messageDispatcher) {
        this.xStream.autodetectAnnotations(true);
        this.xStream.registerConverter((Converter)new PointConverter());
        this.xStreamOld = new XStream((HierarchicalStreamDriver)new DomDriver());
        this.xStreamOld.autodetectAnnotations(true);
        this.messageDispatcher = messageDispatcher;
    }

    public void startNewFile() {
        this.currentFileName = null;
        this.modified = false;
        this.fireFileStatusChanged();
    }

    public synchronized void serializeProjectToFile(Project project, String string, boolean bl) throws IOException {
        if (!bl) {
            LOG.info((Object)String.format("saveProjectToFile(%s)", string));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.xStream.toXML((Object)project, (Writer)outputStreamWriter);
        fileOutputStream.close();
        if (!bl) {
            this.currentFileName = string;
            this.modified = false;
            this.fireFileStatusChanged();
        }
    }

    public Project deserializeProjectFromFile(String string, List<String> list) throws SAXException, IOException, ParserConfigurationException {
        Project project;
        LOG.info((Object)String.format("loadProjectFromFile(%s)", string));
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new InputStreamReader(new FileInputStream(file))));
        document.getDocumentElement().normalize();
        if (document.getDocumentElement().getNodeName().equalsIgnoreCase(Project.class.getName())) {
            project = this.parseV3File(string);
        } else {
            if (!document.getDocumentElement().getNodeName().equalsIgnoreCase("layout")) {
                throw new IllegalArgumentException("Could not open DIY file. Root node is not named 'Layout'.");
            }
            String string2 = document.getDocumentElement().getAttribute("formatVersion");
            if (string2 == null || string2.trim().isEmpty()) {
                LOG.debug((Object)"Detected v1 file.");
                project = this.parseV1File(document.getDocumentElement(), list);
            } else if (string2.equals("2.0")) {
                LOG.debug((Object)"Detected v2 file.");
                project = this.parseV2File(document.getDocumentElement());
            } else {
                throw new IllegalArgumentException("Unknown file format version: " + string2);
            }
        }
        Collections.sort(list);
        this.currentFileName = string;
        this.modified = false;
        return project;
    }

    public void notifyFileChange() {
        this.modified = true;
        this.fireFileStatusChanged();
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void fireFileStatusChanged() {
        this.messageDispatcher.dispatchMessage((Enum)EventType.FILE_STATUS_CHANGED, new Object[]{this.getCurrentFileName(), this.isModified()});
    }

    private Project parseV1File(Element element, List<String> list) {
        BlankBoard blankBoard;
        Project project = new Project();
        project.setTitle(element.getAttribute("Project"));
        project.setAuthor(element.getAttribute("Credits"));
        project.setGridSpacing(V1_GRID_SPACING);
        String string = element.getAttribute("Type");
        int n = Integer.parseInt(element.getAttribute("Width")) + 1;
        int n2 = Integer.parseInt(element.getAttribute("Height")) + 1;
        int n3 = (int)((double)(n * 200) * V1_GRID_SPACING.getValue());
        int n4 = (int)((double)(n2 * 200) * V1_GRID_SPACING.getValue());
        int n5 = (int)project.getWidth().convertToPixels();
        int n6 = (int)project.getHeight().convertToPixels();
        int n7 = (n5 - n3) / 2;
        int n8 = (n6 - n4) / 2;
        if (string.equalsIgnoreCase("pcb")) {
            blankBoard = new BlankBoard();
            blankBoard.setBoardColor(Color.white);
            blankBoard.setBorderColor(Color.black);
        } else if (string.equalsIgnoreCase("perfboard")) {
            blankBoard = new PerfBoard();
        } else if (string.equalsIgnoreCase("stripboard")) {
            blankBoard = new VeroBoard();
        } else {
            throw new IllegalArgumentException("Unrecognized board type: " + string);
        }
        blankBoard.setName("Main board");
        Point point = new Point(CalcUtils.roundToGrid(n7, V1_GRID_SPACING), CalcUtils.roundToGrid(n8, V1_GRID_SPACING));
        blankBoard.setControlPoint(point, 0);
        blankBoard.setControlPoint(new Point(CalcUtils.roundToGrid(n7 + n3, V1_GRID_SPACING), CalcUtils.roundToGrid(n8 + n4, V1_GRID_SPACING)), 1);
        project.getComponents().add((IDIYComponent<?>)blankBoard);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Point point2;
            int n9;
            Object object;
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string3 = node.getNodeName();
            String string4 = node.getAttributes().getNamedItem("Name").getNodeValue();
            Node node2 = node.getAttributes().getNamedItem("Value");
            String string5 = node2 == null ? null : node2.getNodeValue();
            int n10 = Integer.parseInt(node.getAttributes().getNamedItem("X1").getNodeValue());
            int n11 = Integer.parseInt(node.getAttributes().getNamedItem("Y1").getNodeValue());
            Point point3 = this.convertV1CoordinatesToV3Point(point, n10, n11);
            Point point4 = null;
            Integer n12 = null;
            Integer n13 = null;
            Color color = null;
            if (node.getAttributes().getNamedItem("Color") != null) {
                string2 = node.getAttributes().getNamedItem("Color").getNodeValue();
                color = V1_COLOR_MAP.get(string2.toLowerCase());
            }
            if (node.getAttributes().getNamedItem("X2") != null && node.getAttributes().getNamedItem("Y2") != null) {
                n12 = Integer.parseInt(node.getAttributes().getNamedItem("X2").getNodeValue());
                n13 = Integer.parseInt(node.getAttributes().getNamedItem("Y2").getNodeValue());
                point4 = this.convertV1CoordinatesToV3Point(point, n12, n13);
            }
            string2 = null;
            if (string3.equalsIgnoreCase("text")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new Label();
                object.setName(string4);
                if (color != null) {
                    object.setColor(color);
                }
                object.setText(string5);
                object.setHorizontalAlignment(HorizontalAlignment.LEFT);
                object.setVerticalAlignment(VerticalAlignment.CENTER);
                object.setControlPoint(this.convertV1CoordinatesToV3Point(point, n10, n11), 0);
                string2 = object;
            } else if (string3.equalsIgnoreCase("pad")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new SolderPad();
                object.setName(string4);
                if (color != null) {
                    object.setColor(color);
                }
                object.setControlPoint(this.convertV1CoordinatesToV3Point(point, n10, n11), 0);
                string2 = object;
            } else if (string3.equalsIgnoreCase("trace")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new CopperTrace();
                object.setName(string4);
                if (color != null) {
                    object.setLeadColor(color);
                }
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("jumper")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new Jumper();
                object.setName(string4);
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("wire")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new HookupWire();
                Point point5 = new Point((point3.x + point4.x) / 2, (point3.y + point4.y) / 2);
                object.setName(string4);
                String string6 = node.getAttributes().getNamedItem("Color").getNodeValue();
                object.setColor(this.parseV1Color(string6));
                object.setControlPoint(point3, 0);
                object.setControlPoint(point5, 1);
                object.setControlPoint(point5, 2);
                object.setControlPoint(point4, 3);
                string2 = object;
            } else if (string3.equalsIgnoreCase("resistor")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new Resistor();
                object.setName(string4);
                try {
                    object.setValue(Resistance.parseResistance(string5));
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                object.setLength(new Size((Double)6.35, SizeUnit.mm));
                object.setWidth(new Size((Double)2.2, SizeUnit.mm));
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("capacitor")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new RadialFilmCapacitor();
                object.setName(string4);
                try {
                    object.setValue(Capacitance.parseCapacitance(string5));
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                object.setLength(new Size((Double)6.0, SizeUnit.mm));
                object.setWidth(new Size((Double)2.0, SizeUnit.mm));
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("electrolyte")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new RadialElectrolytic();
                object.setName(string4);
                try {
                    object.setValue(Capacitance.parseCapacitance(string5));
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                try {
                    String string7 = node.getAttributes().getNamedItem("Size").getNodeValue();
                    if (string7.equalsIgnoreCase("small")) {
                        object.setLength(new Size((Double)3.5, SizeUnit.mm));
                    } else if (string7.equalsIgnoreCase("medium")) {
                        object.setLength(new Size((Double)5.0, SizeUnit.mm));
                    } else if (string7.equalsIgnoreCase("large")) {
                        object.setLength(new Size((Double)7.0, SizeUnit.mm));
                    } else {
                        object.setLength(new Size((Double)4.0, SizeUnit.mm));
                    }
                }
                catch (Exception exception) {
                    object.setLength(new Size((Double)5.0, SizeUnit.mm));
                    LOG.debug((Object)("Could not set size of " + string4));
                }
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("diode")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new DiodePlastic();
                object.setName(string4);
                try {
                    object.setValue(string5);
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                object.setLength(new Size((Double)6.0, SizeUnit.mm));
                object.setWidth(new Size((Double)2.0, SizeUnit.mm));
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("led")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new LED();
                object.setName(string4);
                object.setValue(string5);
                object.setBodyColor(Color.red);
                object.setBorderColor(Color.red.darker());
                object.setLength(new Size((Double)3.0, SizeUnit.mm));
                object.setControlPoint(point3, 0);
                object.setControlPoint(point4, 1);
                string2 = object;
            } else if (string3.equalsIgnoreCase("transistor")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new TransistorTO92();
                object.setName(string4);
                try {
                    object.setValue(string5);
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                object.setControlPoint(point3, 0);
                if (point3.y > point4.y) {
                    object.setOrientation(Orientation._180);
                } else if (point3.y < point4.y) {
                    object.setOrientation(Orientation.DEFAULT);
                } else if (point3.x < point4.x) {
                    object.setOrientation(Orientation._270);
                } else if (point3.x > point4.x) {
                    object.setOrientation(Orientation._90);
                }
                string2 = object;
            } else if (string3.equalsIgnoreCase("ic")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new DIL_IC();
                int n14 = 8;
                int n15 = 3;
                if (n10 < n12 && n11 < n13) {
                    n14 = (n13 - n11 + 1) * 2;
                    n15 = n12 - n10;
                    object.setOrientation(Orientation.DEFAULT);
                } else if (n10 > n12 && n11 < n13) {
                    n14 = (n10 - n12 + 1) * 2;
                    n15 = n13 - n11;
                    object.setOrientation(Orientation._90);
                } else if (n10 > n12 && n11 > n13) {
                    n15 = n10 - n12;
                    n14 = (n11 - n13 + 1) * 2;
                    object.setOrientation(Orientation._180);
                } else if (n10 < n12 && n11 > n13) {
                    n15 = n11 - n13;
                    n14 = (n12 - n10 + 1) * 2;
                    object.setOrientation(Orientation._270);
                }
                object.setRowSpacing(new Size((Double)(0.1 * (double)n15), SizeUnit.in));
                object.setPinCount(DIL_IC.PinCount.valueOf((String)("_" + n14)));
                object.setName(string4);
                for (n9 = 0; n9 < object.getControlPointCount(); ++n9) {
                    point2 = new Point(object.getControlPoint(n9));
                    point2.translate(point3.x, point3.y);
                    object.setControlPoint(point2, n9);
                }
                object.setValue(string5);
                string2 = object;
            } else if (string3.equalsIgnoreCase("pot")) {
                LOG.debug((Object)("Recognized " + string3));
                object = new PotentiometerPanel();
                object.setBodyDiameter(new Size((Double)14.0, SizeUnit.mm));
                object.setSpacing(new Size((Double)0.2, SizeUnit.in));
                object.setName(string4);
                try {
                    object.setValue(Resistance.parseResistance(string5));
                }
                catch (Exception exception) {
                    LOG.debug((Object)("Could not set value of " + string4));
                }
                String string8 = node.getAttributes().getNamedItem("Taper").getNodeValue();
                if ("Linear".equals(string8)) {
                    object.setTaper(Taper.LIN);
                } else if ("Audio".equals(string8)) {
                    object.setTaper(Taper.LOG);
                } else if ("Reverse Audio".equals(string8)) {
                    object.setTaper(Taper.REV_LOG);
                }
                int n16 = 40;
                if (n10 < n12) {
                    object.setOrientation(Orientation.DEFAULT);
                    for (n9 = 0; n9 < object.getControlPointCount(); ++n9) {
                        point2 = new Point(object.getControlPoint(n9));
                        point2.translate(point3.x - n16, point3.y);
                        object.setControlPoint(point2, n9);
                    }
                } else if (n10 > n12) {
                    object.setOrientation(Orientation._180);
                    for (n9 = 0; n9 < object.getControlPointCount(); ++n9) {
                        point2 = new Point(object.getControlPoint(n9));
                        point2.translate(point3.x + n16, point3.y);
                        object.setControlPoint(point2, n9);
                    }
                } else if (n11 < n13) {
                    object.setOrientation(Orientation._90);
                    for (n9 = 0; n9 < object.getControlPointCount(); ++n9) {
                        point2 = new Point(object.getControlPoint(n9));
                        point2.translate(point3.x, point3.y - n16);
                        object.setControlPoint(point2, n9);
                    }
                } else if (n11 > n13) {
                    object.setOrientation(Orientation._270);
                    for (n9 = 0; n9 < object.getControlPointCount(); ++n9) {
                        point2 = new Point(object.getControlPoint(n9));
                        point2.translate(point3.x, point3.y + n16);
                        object.setControlPoint(point2, n9);
                    }
                }
                string2 = object;
            } else {
                object = "Could not recognize component type " + string3;
                LOG.debug(object);
                if (!list.contains(object)) {
                    list.add((String)object);
                }
            }
            if (string2 == null) continue;
            if (string2 instanceof AbstractLeadedComponent) {
                ((AbstractLeadedComponent)((Object)string2)).setDisplay(Display.NAME);
            }
            if (string2 instanceof AbstractTransparentComponent) {
                ((AbstractTransparentComponent)((Object)string2)).setAlpha((byte)100);
            }
            project.getComponents().add((IDIYComponent<?>)((Object)string2));
        }
        Collections.sort(project.getComponents(), ComparatorFactory.getInstance().getComponentZOrderComparator());
        return project;
    }

    private Point convertV1CoordinatesToV3Point(Point point, int n, int n2) {
        Point point2 = new Point(point);
        point2.translate((int)((double)(n * 200) * V1_GRID_SPACING.getValue()), (int)((double)(n2 * 200) * V1_GRID_SPACING.getValue()));
        return point2;
    }

    private Color parseV1Color(String string) {
        if ("brown".equals(string.toLowerCase())) {
            return new Color(139, 69, 19);
        }
        try {
            Field field = Color.class.getDeclaredField(string.toLowerCase());
            return (Color)field.get(null);
        }
        catch (Exception exception) {
            LOG.error((Object)("Could not parse color \"" + string + "\""), (Throwable)exception);
            return Color.black;
        }
    }

    private Project parseV2File(Element element) {
        Project project = new Project();
        String string = element.getAttribute("projectName");
        String string2 = element.getAttribute("credits");
        String string3 = element.getAttribute("width");
        String string4 = element.getAttribute("height");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("component")) {
                LOG.debug((Object)node.getAttributes().getNamedItem("name").getNodeValue());
                continue;
            }
            LOG.debug((Object)("Unrecognized node name found: " + node.getNodeName()));
        }
        return project;
    }

    private Project parseV3File(String string) throws IOException {
        Project project;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            project = (Project)this.xStream.fromXML((Reader)inputStreamReader);
        }
        catch (Exception exception) {
            LOG.warn((Object)"Could not open with the new xStream, trying the old one");
            fileInputStream.close();
            fileInputStream = new FileInputStream(string);
            project = (Project)this.xStreamOld.fromXML((InputStream)fileInputStream);
        }
        fileInputStream.close();
        return project;
    }

    static {
        V1_COLOR_MAP.put("red", Color.red);
        V1_COLOR_MAP.put("blue", Color.blue);
        V1_COLOR_MAP.put("white", Color.white);
        V1_COLOR_MAP.put("green", Color.green.darker());
        V1_COLOR_MAP.put("black", Color.black);
        V1_COLOR_MAP.put("yellow", Color.yellow);
    }
}

