/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.diylc.swingframework.LinkLabel;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private final String appName;
    private final Icon icon;
    private final String version;
    private final String author;
    private final String url;
    private final String mail;
    private final String htmlContent;

    public AboutDialog(JFrame parent, String appName, Icon icon, String version, String author, String url, String mail, String htmlContent) {
        super((Frame)parent, "About");
        this.appName = appName;
        this.icon = icon;
        this.version = version;
        this.author = author;
        this.url = url;
        this.mail = mail;
        this.htmlContent = htmlContent;
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.setPreferredSize(new Dimension(320, 240));
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBackground(Color.white);
            this.mainPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 23;
            gbc.fill = 0;
            gbc.insets = new Insets(10, 8, 10, 4);
            JLabel iconLabel = new JLabel(this.icon);
            gbc.gridheight = 2;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.mainPanel.add((Component)iconLabel, gbc);
            JLabel appNameLabel = new JLabel(this.appName);
            appNameLabel.setForeground(Color.red.darker());
            appNameLabel.setFont(appNameLabel.getFont().deriveFont(18.0f).deriveFont(1));
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 4, 0, 4);
            this.mainPanel.add((Component)appNameLabel, gbc);
            JLabel versionLabel = new JLabel("version " + this.version);
            versionLabel.setForeground(Color.lightGray);
            versionLabel.setFont(versionLabel.getFont().deriveFont(1));
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 4, 8, 4);
            this.mainPanel.add((Component)versionLabel, gbc);
            JLabel authorLabel = new JLabel(this.author);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(1, 8, 1, 4);
            this.mainPanel.add((Component)authorLabel, gbc);
            LinkLabel urlLabel = new LinkLabel("http://", this.url);
            gbc.gridy = 3;
            this.mainPanel.add((Component)urlLabel, gbc);
            LinkLabel mailLabel = new LinkLabel("mailto:", this.mail);
            gbc.gridy = 4;
            this.mainPanel.add((Component)mailLabel, gbc);
            String html = "<head><title>About</title><style type=\"text/css\">body {font-family: Tahoma; font-size: 8.5px; } </style></head><body>" + this.htmlContent + "</body></html>";
            JEditorPane editorPane = new JEditorPane("text/html", html);
            editorPane.setEditable(false);
            editorPane.setCursor(Cursor.getPredefinedCursor(2));
            JScrollPane scrollPane = new JScrollPane(editorPane);
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setBorder(null);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.insets = new Insets(8, 4, 1, 4);
            this.mainPanel.add((Component)scrollPane, gbc);
        }
        return this.mainPanel;
    }

    public JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(4));
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.setVisible(false);
                }
            });
            this.buttonPanel.add(closeButton);
        }
        return this.buttonPanel;
    }
}

