/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.update;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.diylc.appframework.images.IconLoader;
import org.diylc.appframework.update.Version;
import org.diylc.appframework.update.VersionNumber;
import org.diylc.swingframework.update.UpdateChecker;
import org.diylc.swingframework.update.UpdateDialog;

public class UpdateLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private UpdateChecker updateChecker;
    private List<Version> updatedVersions;

    public UpdateLabel(VersionNumber currentVersion, String updateFileUrl) {
        this.updateChecker = new UpdateChecker(currentVersion, updateFileUrl);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (UpdateLabel.this.updatedVersions != null && UpdateLabel.this.updatedVersions.size() > 0) {
                    new UpdateDialog(UpdateLabel.this, UpdateLabel.this.updateChecker.createUpdateHTML(UpdateLabel.this.updatedVersions), ((Version)UpdateLabel.this.updatedVersions.get(0)).getUrl()).setVisible(true);
                } else {
                    UpdateLabel.this.checkForUpdates();
                }
            }
        });
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        SwingWorker<List<Version>, Void> worker = new SwingWorker<List<Version>, Void>(){

            @Override
            protected List<Version> doInBackground() throws Exception {
                return UpdateLabel.this.updateChecker.findNewVersions();
            }

            @Override
            protected void done() {
                try {
                    UpdateLabel.this.updatedVersions = (List)this.get();
                    if (UpdateLabel.this.updatedVersions.size() == 0) {
                        UpdateLabel.this.setIcon(IconLoader.LightBulbOff.getIcon());
                        UpdateLabel.this.setToolTipText("No updates available, click to check again");
                    } else {
                        UpdateLabel.this.setIcon(IconLoader.LightBulbOn.getIcon());
                        UpdateLabel.this.setToolTipText("Updates are available, click to see details");
                    }
                }
                catch (Exception e) {
                    UpdateLabel.this.setIcon(IconLoader.LightBulbOff.getIcon());
                    UpdateLabel.this.setToolTipText("Error occured while searching for updates: " + e.getMessage());
                    UpdateLabel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        worker.execute();
    }
}

