/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.openide.util.lookup.MetaInfServicesLookup;

final class MetaInfCache {
    private int knownInstancesCount;
    private final List<Reference<Object>> knownInstances = new ArrayList<Reference<Object>>();

    public MetaInfCache(int size) {
        for (int i = 0; i < size; ++i) {
            this.knownInstances.add(null);
        }
    }

    public synchronized Object findInstance(Class<?> c) {
        Reference<Object> ref;
        int size = this.knownInstances.size();
        int index = MetaInfCache.hashForClass(c, size);
        for (int i = 0; i < size && (ref = this.knownInstances.get(index)) != null; ++i) {
            Object obj = ref.get();
            if (obj != null && c == obj.getClass()) {
                return obj;
            }
            if (++index != size) continue;
            index = 0;
        }
        return null;
    }

    public synchronized void storeInstance(Object o) {
        this.hashPut(o);
        int size = this.knownInstances.size();
        if (this.knownInstancesCount > size * 2 / 3) {
            MetaInfServicesLookup.LOGGER.log(Level.CONFIG, "Cache of size {0} is 2/3 full. Rehashing.", size);
            MetaInfCache newCache = new MetaInfCache(size * 2);
            for (Reference<Object> r : this.knownInstances) {
                Object instance;
                if (r == null || (instance = r.get()) == null) continue;
                newCache.storeInstance(instance);
            }
            this.knownInstances.clear();
            this.knownInstances.addAll(newCache.knownInstances);
            this.knownInstancesCount = newCache.knownInstancesCount;
        }
    }

    private void hashPut(Object o) {
        assert (Thread.holdsLock(this));
        Class<?> c = o.getClass();
        int size = this.knownInstances.size();
        int index = MetaInfCache.hashForClass(c, size);
        for (int i = 0; i < size; ++i) {
            Object obj;
            Reference<Object> ref = this.knownInstances.get(index);
            Object object = obj = ref == null ? null : ref.get();
            if (obj == null) {
                this.knownInstances.set(index, new WeakReference<Object>(o));
                ++this.knownInstancesCount;
                break;
            }
            if (++index != size) continue;
            index = 0;
        }
    }

    private static int hashForClass(Class<?> c, int size) {
        return Math.abs(c.hashCode() % size);
    }
}

