/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.canvas;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.VolatileImage;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.DrawOption;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.plugins.canvas.CanvasGestureListener;
import org.diylc.swing.plugins.canvas.CanvasTargetListener;

class CanvasPanel
extends JComponent
implements Autoscroll {
    private static final long serialVersionUID = 1L;
    private IPlugInPort plugInPort;
    private Image bufferImage;
    private GraphicsConfiguration screenGraphicsConfiguration;
    public static boolean USE_HARDWARE_ACCELLERATION = false;

    public CanvasPanel(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.setFocusable(true);
        this.initializeListeners();
        this.initializeDnD();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        this.screenGraphicsConfiguration = graphicsDeviceArray[0].getDefaultConfiguration();
        this.initializeActions();
    }

    public void invalidateCache() {
        this.bufferImage = null;
    }

    private void initializeDnD() {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 0x40000003, new CanvasGestureListener(this.plugInPort));
        new DropTarget(this, 3, new CanvasTargetListener(this.plugInPort), true);
    }

    private void initializeActions() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "clearSlot");
        this.getActionMap().put("clearSlot", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CanvasPanel.this.plugInPort.setNewComponentTypeSlot(null, null);
            }
        });
    }

    protected void createBufferImage() {
        if (USE_HARDWARE_ACCELLERATION) {
            this.bufferImage = this.screenGraphicsConfiguration.createCompatibleVolatileImage(this.getWidth(), this.getHeight());
            ((VolatileImage)this.bufferImage).validate(this.screenGraphicsConfiguration);
        } else {
            this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.plugInPort == null) {
            return;
        }
        if (this.bufferImage == null) {
            this.createBufferImage();
        }
        Graphics2D graphics2D = (Graphics2D)this.bufferImage.getGraphics();
        graphics2D.setClip(this.getVisibleRect());
        EnumSet<DrawOption> enumSet = EnumSet.of(DrawOption.GRID, DrawOption.SELECTION, DrawOption.ZOOM, DrawOption.CONTROL_POINTS);
        if (ConfigurationManager.getInstance().readBoolean("antiAliasing", true)) {
            enumSet.add(DrawOption.ANTIALIASING);
        }
        if (ConfigurationManager.getInstance().readBoolean("outline", false)) {
            enumSet.add(DrawOption.OUTLINE_MODE);
        }
        this.plugInPort.draw(graphics2D, enumSet, null);
        if (USE_HARDWARE_ACCELLERATION) {
            VolatileImage volatileImage = (VolatileImage)this.bufferImage;
            do {
                try {
                    if (volatileImage.contentsLost()) {
                        this.createBufferImage();
                    }
                    graphics.drawImage(this.bufferImage, 0, 0, this);
                }
                catch (NullPointerException nullPointerException) {
                    this.createBufferImage();
                }
            } while (volatileImage == null || volatileImage.contentsLost());
        } else {
            graphics.drawImage(this.bufferImage, 0, 0, this);
        }
        graphics2D.dispose();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void initializeListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                CanvasPanel.this.invalidateCache();
                CanvasPanel.this.invalidate();
            }
        });
    }

    @Override
    public void autoscroll(Point point) {
        this.scrollRectToVisible(new Rectangle(point.x - 15, point.y - 15, 30, 30));
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getVisibleRect();
        return new Insets(rectangle.y - 15, rectangle.x - 15, rectangle.y + rectangle.height + 15, rectangle.x + rectangle.width + 15);
    }
}

