/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtsp;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.rtsp.RtspAppListener;
import com.sun.media.rtsp.RtspListener;
import com.sun.media.rtsp.RtspManager;
import com.sun.media.rtsp.RtspUrl;
import com.sun.media.rtsp.protocol.CSeqHeader;
import com.sun.media.rtsp.protocol.ContentBaseHeader;
import com.sun.media.rtsp.protocol.Header;
import com.sun.media.rtsp.protocol.Message;
import com.sun.media.rtsp.protocol.OptionsMessage;
import com.sun.media.rtsp.protocol.Request;
import com.sun.media.rtsp.protocol.ResponseMessage;
import com.sun.media.rtsp.protocol.SessionHeader;
import com.sun.media.rtsp.protocol.StatusCode;
import com.sun.media.rtsp.protocol.TransportHeader;
import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.MediaDescription;
import com.sun.media.sdp.SdpParser;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;

public class RtspUtil
implements RtspListener {
    private final int TIMER_1 = 60000;
    private final int TIMER_2 = 30000;
    private RtspManager rtspManager;
    private RTPManager[] mgrs;
    private String[] mediaTypes;
    private long sequenceNumber;
    private int numberOfTracks;
    private String userAgent;
    private RtspUrl rtspUrl;
    private String[] mediaControls;
    private int[] server_ports;
    private int[] client_ports;
    private String[] session_ids;
    private Message message;
    private int connectionId;
    private String url;
    private double startPos;
    private String processError;
    private long duration;
    private Vector listeners;
    private ReceiveStreamListener parent;
    boolean responseReceived;
    boolean dataReceived;
    Object responseSync = new Object();

    public RtspUtil(ReceiveStreamListener parent) {
        this.parent = parent;
        this.listeners = new Vector();
        this.rtspManager = new RtspManager(false);
        this.sequenceNumber = (long)(Math.random() * 1000.0);
        this.userAgent = "User-Agent: JMF RTSP Player " + BasicPlayer.VERSION;
        this.rtspManager.addListener(this);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStartPos(double startPos) {
        this.startPos = startPos;
    }

    public RTPManager getRTPManager(int i2) {
        return this.mgrs[i2];
    }

    public RTPManager[] getRTPManagers() {
        return this.mgrs;
    }

    public String getMediaType(int i2) {
        return this.mediaTypes[i2];
    }

    public String[] getMediaTypes() {
        return this.mediaTypes;
    }

    public long getDuration() {
        return this.duration;
    }

    public void removeTrack(int trackId) {
        Log.comment("track removed: " + this.mediaTypes[trackId]);
        this.mgrs[trackId].removeTargets("media track not supported");
        this.mgrs[trackId].dispose();
        --this.numberOfTracks;
        if (trackId + 1 > this.mgrs.length) {
            int length = this.mgrs.length - trackId - 1;
            System.arraycopy(this.mgrs, trackId + 1, this.mgrs, trackId, length);
        }
    }

    public boolean createConnection() {
        boolean realized = true;
        try {
            this.rtspUrl = new RtspUrl(this.url);
        }
        catch (MalformedURLException e2) {
            this.processError = "Invalid RTSP URL: " + this.url;
            return false;
        }
        String ipAddress = this.getServerIpAddress();
        if (ipAddress == null) {
            Log.error("Invalid server address:" + this.url);
            this.processError = "Invalid Server adress: " + this.url;
            return false;
        }
        this.connectionId = this.rtspManager.createConnection(ipAddress, this.rtspUrl.getPort());
        if (this.connectionId < 0) {
            switch (this.connectionId) {
                case -2: {
                    this.processError = "Unknown RTSP Host!";
                    break;
                }
                case -3: {
                    this.processError = "Can't connect to RTSP Server!";
                    break;
                }
                default: {
                    this.processError = "Unknown reason";
                }
            }
            realized = false;
        }
        return realized;
    }

    public void closeConnection() {
        this.rtspManager.closeConnection(this.connectionId);
    }

    public boolean rtspSetup() {
        String msg = "DESCRIBE rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Accept: application/sdp\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(msg);
        boolean timeout = this.waitForResponse(60000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return false;
        }
        if (!this.responseOk()) {
            return false;
        }
        this.setDuration();
        this.numberOfTracks = this.getNumTracks();
        this.client_ports = new int[this.numberOfTracks];
        this.mgrs = new RTPManager[this.numberOfTracks];
        this.mediaControls = new String[this.numberOfTracks];
        this.mediaTypes = new String[this.numberOfTracks];
        String[] dynamicPayloads = new String[this.numberOfTracks];
        int i2 = 0;
        while (i2 < this.numberOfTracks) {
            this.mgrs[i2] = this.createSessionManager(i2);
            this.mediaTypes[i2] = this.getCurMediaType(i2);
            this.mediaControls[i2] = this.getMediaAttributeValue(i2, "control");
            dynamicPayloads[i2] = this.getMediaAttributeValue(i2, "rtpmap");
            if (this.mediaTypes[i2] != null && dynamicPayloads[i2] != null) {
                this.addDynamicPayload(this.mgrs[i2], this.mediaTypes[i2], dynamicPayloads[i2]);
            }
            ++i2;
        }
        String contentBase = this.getContentBase();
        this.session_ids = new String[this.numberOfTracks];
        this.server_ports = new int[this.numberOfTracks];
        int i3 = 0;
        while (i3 < this.numberOfTracks) {
            int serverPort;
            msg = i3 == 0 ? "SETUP " + contentBase + this.mediaControls[i3] + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + this.client_ports[i3] + "-" + (this.client_ports[i3] + 1) + "\r\n" + this.userAgent + "\r\n\r\n" : "SETUP " + contentBase + this.mediaControls[i3] + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + this.client_ports[i3] + "-" + (this.client_ports[i3] + 1) + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
            this.sendMessage(msg);
            timeout = this.waitForResponse(30000);
            if (timeout) {
                Log.error("ERROR: Timeout received (1).");
                this.processError = "Server is not responding";
                return false;
            }
            if (!this.responseOk()) {
                return false;
            }
            String sessionId = this.getSessionId();
            if (sessionId == null) {
                this.processError = "Invalid session ID";
                return false;
            }
            this.session_ids[i3] = sessionId;
            int pos = this.session_ids[i3].indexOf(59);
            if (pos > 0) {
                this.session_ids[i3] = this.session_ids[i3].substring(0, pos);
            }
            if ((serverPort = this.getServerDataPort()) == -1) {
                this.processError = "Invalid server data port";
                return false;
            }
            this.server_ports[i3] = serverPort;
            ++i3;
        }
        return true;
    }

    private boolean responseOk() {
        boolean result = false;
        int statusCode = this.getStatusCode();
        if (statusCode == 200) {
            result = true;
        } else {
            this.processError = "Message from RTSP Server - " + this.getStatusText(statusCode);
        }
        return result;
    }

    private String getSessionId() {
        String id = null;
        try {
            ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
            SessionHeader hdr = (SessionHeader)responseMsg.getResponse().getHeader((int)3).parameter;
            id = hdr.getSessionId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    private int getServerDataPort() {
        int port = -1;
        try {
            ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
            TransportHeader transport_hdr = (TransportHeader)responseMsg.getResponse().getHeader((int)1).parameter;
            port = transport_hdr.getServerDataPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public boolean rtspStart() {
        String msg = "PLAY rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Range: npt=" + this.startPos / 1.0E9 + "-\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(msg);
        boolean timeout = this.waitForResponse(30000);
        if (timeout) {
            this.processError = "Server is not responding";
            return false;
        }
        int code = this.getStatusCode();
        if (code == -1) {
            this.processError = "Received invalid status code";
            return false;
        }
        if (this.getStatusCode() == 454) {
            int i2 = 0;
            if (i2 < this.numberOfTracks) {
                this.mgrs[i2].removeTargets("session not found");
                this.mgrs[i2].dispose();
                return false;
            }
        }
        return true;
    }

    public void rtspStop() {
        String msg = "PAUSE rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(msg);
        boolean timeout = this.waitForResponse(30000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
    }

    public void rtspTeardown() {
        String msg = "TEARDOWN rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(msg);
        boolean timeout = this.waitForResponse(30000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
    }

    public RTPManager createSessionManager(int index) {
        RTPManager rtpManager = RTPManager.newInstance();
        if (rtpManager == null) {
            return null;
        }
        rtpManager.addReceiveStreamListener(this.parent);
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            SessionAddress localAddress = new SessionAddress();
            rtpManager.initialize(localAddress);
            this.client_ports[index] = localAddress.getDataPort();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
        return rtpManager;
    }

    private void addDynamicPayload(RTPManager mgr, String typeStr, String dpStr) {
        int c2 = 0;
        while (dpStr.length() > 0 && dpStr.charAt(c2) == ' ') {
            ++c2;
        }
        if (c2 > 0) {
            dpStr = dpStr.substring(c2);
        }
        c2 = 0;
        while (dpStr.length() > 0 && dpStr.charAt(c2) != ' ') {
            ++c2;
        }
        if (c2 < 0) {
            return;
        }
        String tmpStr = dpStr.substring(0, c2);
        dpStr = dpStr.substring(c2);
        Integer integer = Integer.valueOf(tmpStr);
        if (integer == null) {
            return;
        }
        int payload = integer;
        if (payload < 96 || payload > 127) {
            return;
        }
        c2 = 0;
        while (dpStr.length() > 0 && dpStr.charAt(c2) == ' ') {
            ++c2;
        }
        if (c2 > 0) {
            dpStr = dpStr.substring(c2);
        }
        if (dpStr.length() == 0) {
            return;
        }
        c2 = 0;
        while (dpStr.length() > 0 && dpStr.charAt(c2) != '/') {
            ++c2;
        }
        tmpStr = c2 > 0 ? dpStr.substring(0, c2) : dpStr;
        if (tmpStr.length() == 0) {
            return;
        }
        tmpStr = tmpStr.toLowerCase() + "/rtp";
        if ("video".equalsIgnoreCase(typeStr)) {
            mgr.addFormat(new VideoFormat(tmpStr), payload);
            Log.comment("Add RTP dynamic payload for video: " + payload + " : " + tmpStr);
        }
        if ("audio".equalsIgnoreCase(typeStr)) {
            mgr.addFormat(new AudioFormat(tmpStr), payload);
            Log.comment("Add RTP dynamic payload for audio: " + payload + " : " + tmpStr);
        }
    }

    public int getStatusCode() {
        int code = -1;
        try {
            ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
            code = responseMsg.getResponse().getStatusLine().getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private String getStatusText(int code) {
        return StatusCode.getStatusText(code);
    }

    private void setDuration() {
        String value;
        MediaAttribute attribute;
        this.duration = 0L;
        ResponseMessage msg = (ResponseMessage)this.message.getParameter();
        double start_time = 0.0;
        double end_time = 0.0;
        SdpParser sdp = msg.getResponse().sdp;
        if (sdp != null && (attribute = sdp.getSessionAttribute("range")) != null && (value = attribute.getValue()).startsWith("npt")) {
            int start = value.indexOf(61) + 1;
            int end = value.indexOf(45);
            String startTime = value.substring(start, end).trim();
            String endTime = value.substring(end + 1).trim();
            end_time = new Double(endTime);
            this.duration = (long)(end_time * 1.0E9);
        }
    }

    private int getNumTracks() {
        int numTracks = 0;
        ResponseMessage msg = (ResponseMessage)this.message.getParameter();
        SdpParser sdp = msg.getResponse().sdp;
        if (sdp != null) {
            numTracks = sdp.getMediaDescriptions().size();
        }
        return numTracks;
    }

    private MediaDescription getMediaDescription(String mediaName) {
        MediaDescription description = null;
        try {
            ResponseMessage msg = (ResponseMessage)this.message.getParameter();
            SdpParser sdp = msg.getResponse().sdp;
            description = sdp.getMediaDescription(mediaName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return description;
    }

    private String getCurMediaType(int i2) {
        String type = null;
        try {
            ResponseMessage msg = (ResponseMessage)this.message.getParameter();
            SdpParser sdp = msg.getResponse().sdp;
            MediaDescription md = (MediaDescription)sdp.getMediaDescriptions().elementAt(i2);
            type = md.name;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    public static String getMediaAttribute(MediaDescription md, String attribute) {
        MediaAttribute ma;
        String mediaAttribute = "";
        if (md != null && (ma = md.getMediaAttribute("control")) != null) {
            mediaAttribute = ma.getValue();
        }
        return mediaAttribute;
    }

    private String getMediaAttributeValue(int i2, String attribute) {
        String value = null;
        try {
            ResponseMessage msg = (ResponseMessage)this.message.getParameter();
            SdpParser sdp = msg.getResponse().sdp;
            MediaDescription md = (MediaDescription)sdp.getMediaDescriptions().elementAt(i2);
            MediaAttribute ma = md.getMediaAttribute(attribute);
            value = ma.getValue();
        }
        catch (Exception e2) {
            // empty catch block
        }
        return value;
    }

    private String getTrackID(String mediaName) {
        String trackId = null;
        try {
            ResponseMessage msg = (ResponseMessage)this.message.getParameter();
            SdpParser sdp = msg.getResponse().sdp;
            MediaDescription description = sdp.getMediaDescription(mediaName);
            MediaAttribute attribute = description.getMediaAttribute("control");
            trackId = attribute.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trackId;
    }

    private String getContentBase() {
        String contentBase = "";
        try {
            ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
            Header header = responseMsg.getResponse().getHeader(9);
            ContentBaseHeader cbh = (ContentBaseHeader)header.parameter;
            contentBase = cbh.getContentBase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentBase;
    }

    private void sendMessage(String message) {
        this.responseReceived = false;
        boolean success = this.rtspManager.sendMessage(this.connectionId, message);
        if (!success) {
            String ipAddress = this.getServerIpAddress();
            this.connectionId = this.rtspManager.createConnection(ipAddress, this.rtspUrl.getPort());
            this.rtspManager.sendMessage(this.connectionId, message);
        }
    }

    private synchronized boolean waitForResponse(int time) {
        boolean timeout = false;
        try {
            Object object = this.responseSync;
            synchronized (object) {
                if (!this.responseReceived) {
                    this.responseSync.wait(time);
                }
                if (this.responseReceived) {
                    ++this.sequenceNumber;
                } else {
                    timeout = true;
                }
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return timeout;
    }

    private void processRtspRequest(int connectionId, Message message) {
        if (message.getType() == 4) {
            OptionsMessage msg = (OptionsMessage)message.getParameter();
            this.sendResponse(connectionId, msg.getRequest());
        }
    }

    private void processRtspResponse(int connectionId, Message message) {
        this.message = message;
        this.responseReceived = true;
        Object object = this.responseSync;
        synchronized (object) {
            this.responseSync.notify();
        }
    }

    private void sendResponse(int connectionId, Request msg) {
        Object type = null;
        Header header = msg.getHeader(2);
        if (header != null) {
            CSeqHeader cSeqHeader = (CSeqHeader)header.parameter;
            String message = "RTSP/1.0 200 OK\r\nCSeq: " + cSeqHeader.getSequenceNumber() + "\r\n\r\n";
            this.sendMessage(message);
        }
    }

    private void sendStatusMessage(int code, String message) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            ((RtspAppListener)this.listeners.elementAt(i2)).postStatusMessage(code, message);
            ++i2;
        }
    }

    public void addListener(RtspAppListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeListener(RtspAppListener listener) {
        this.listeners.removeElement(listener);
    }

    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    public int[] getServerPorts() {
        return this.server_ports;
    }

    public void rtspMessageIndication(int connectionId, Message message) {
        if (message.getType() == 12) {
            this.processRtspResponse(connectionId, message);
        } else {
            this.processRtspRequest(connectionId, message);
        }
    }

    public String getServerIpAddress() {
        String ipAddress = null;
        try {
            String host;
            if (this.rtspUrl == null) {
                this.rtspUrl = new RtspUrl(this.url);
            }
            if ((host = this.rtspUrl.getHost()) != null) {
                ipAddress = InetAddress.getByName(host).getHostAddress();
            }
        }
        catch (MalformedURLException e2) {
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipAddress;
    }

    public void rtspConnectionTerminated(int connectionId) {
    }

    public String getProcessError() {
        return this.processError;
    }

    public void setProcessError(String error) {
        this.processError = error;
    }
}

