/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import java.lang.reflect.Array;

class GrowableArrayContext
extends AbstractContext {
    private static final int INITIAL_SIZE = 16;
    private Class klass;
    private Object array;
    private int length;

    public void addParameterObject(Object object) throws AssemblyException {
        if (this.length == Array.getLength(this.array)) {
            Object object2 = Array.newInstance(this.klass, this.length * 2);
            System.arraycopy(this.array, 0, object2, 0, this.length);
            this.array = object2;
        }
        try {
            Array.set(this.array, this.length++, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssemblyException(illegalArgumentException);
        }
    }

    public void notifyStatement(Context context) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Statements inside a growable array are not allowed."));
    }

    public Object endContext(Context context) throws AssemblyException {
        if (this.length != Array.getLength(this.array)) {
            Object object = Array.newInstance(this.klass, this.length);
            System.arraycopy(this.array, 0, object, 0, this.length);
            this.array = object;
        }
        return this.array;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int n, Object object) throws AssemblyException {
        try {
            Array.set(this.array, n, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssemblyException(illegalArgumentException);
        }
    }

    public Object get(int n) throws AssemblyException {
        return Array.get(this.array, n);
    }

    public Object getResult() {
        return this.array;
    }

    GrowableArrayContext(String string, Class clazz) {
        this.setId(string);
        this.klass = clazz;
        this.array = Array.newInstance(this.klass, 16);
    }
}

