/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import gnu.java.security.action.GetSecurityPropertyAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LoginContext {
    private static final String OTHER = "other";
    private final String name;
    private final CallbackHandler cbHandler;
    private final Subject subject;
    private final AppConfigurationEntry[] entries;
    private final LoginModule[] modules;
    private final Map sharedState;

    public Subject getSubject() {
        return this.subject;
    }

    /*
     * Unable to fully structure code
     */
    public void login() throws LoginException {
        var1_1 = false;
        var2_2 = 0;
        while (var2_2 < this.modules.length) {
            block11: {
                try {
                    var3_3 = this.modules[var2_2].login();
                    if (!var3_3) {
                        if (this.entries[var2_2].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                            throw new LoginException("REQUISITE module " + this.entries[var2_2].getLoginModuleName() + " failed");
                        }
                        if (this.entries[var2_2].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                            var1_1 = true;
                        }
                    } else if (this.entries[var2_2].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                        break;
                    }
                    break block11;
                }
                catch (LoginException var3_4) {
                    if (this.entries[var2_2].getControlFlag() != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) break block11;
                    var4_5 = 0;
                    ** while (var4_5 < this.modules.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.modules[var2_2].abort();
                    ++var4_5;
                    continue;
                }
lbl23:
                // 1 sources

                throw var3_4;
            }
            ++var2_2;
        }
        if (var1_1) {
            throw new LoginException("not all REQUIRED modules succeeded");
        }
        var2_2 = 0;
        while (var2_2 < this.modules.length) {
            this.modules[var2_2].commit();
            ++var2_2;
        }
    }

    public void logout() throws LoginException {
        int n = 0;
        while (n < this.modules.length) {
            this.modules[n].logout();
            ++n;
        }
    }

    private static final CallbackHandler defaultHandler() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("auth.login.defaultCallbackHandler");
        String string = (String)AccessController.doPrivileged(getSecurityPropertyAction);
        if (string != null) {
            try {
                return (CallbackHandler)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
        }
        return null;
    }

    private final LoginModule lookupModule(AppConfigurationEntry appConfigurationEntry, Subject subject, Map map) throws LoginException {
        Object object;
        LoginModule loginModule = null;
        Exception exception = null;
        try {
            object = Thread.currentThread().getContextClassLoader();
            Class clazz = Class.forName(appConfigurationEntry.getLoginModuleName(), true, (ClassLoader)object);
            loginModule = (LoginModule)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (ClassCastException classCastException) {
            exception = classCastException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        if (exception != null) {
            object = new LoginException("could not load module " + appConfigurationEntry.getLoginModuleName());
            ((Throwable)object).initCause(exception);
            throw object;
        }
        loginModule.initialize(subject, this.cbHandler, map, appConfigurationEntry.getOptions());
        return loginModule;
    }

    public LoginContext(String string) throws LoginException {
        this(string, new Subject(), LoginContext.defaultHandler());
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this(string, new Subject(), callbackHandler);
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this(string, subject, LoginContext.defaultHandler());
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject, callbackHandler, null);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        if (configuration == null) {
            configuration = Configuration.getConfig();
        }
        if ((appConfigurationEntryArray = configuration.getAppConfigurationEntry(string)) == null) {
            appConfigurationEntryArray = configuration.getAppConfigurationEntry(OTHER);
        }
        if (appConfigurationEntryArray == null) {
            throw new LoginException("no configured modules for application " + string);
        }
        this.entries = appConfigurationEntryArray;
        this.modules = new LoginModule[appConfigurationEntryArray.length];
        this.sharedState = new HashMap();
        int n = 0;
        while (n < appConfigurationEntryArray.length) {
            this.modules[n] = this.lookupModule(appConfigurationEntryArray[n], subject, this.sharedState);
            ++n;
        }
        this.name = string;
        this.subject = subject;
        this.cbHandler = callbackHandler;
    }
}

