/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_APPLICATION_H__
#define __SG_APPLICATION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_dataset.h"
#include "widgets/sg_worksheet.h"
#include "widgets/sg_plot.h"
#include "widgets/sg_clipboard.h"
#include "widgets/sg_plot_clipboard.h"

#define SG_APPLICATION(obj)        GTK_CHECK_CAST (obj, sg_application_get_type (), SGapplication)
#define GTK_TYPE_SG_APPLICATION   (sg_application_get_type ())

#define SG_APPLICATION_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_application_get_type(), SGapplicationClass)
#define GTK_IS_SG_APPLICATION(obj)     GTK_CHECK_TYPE (obj, sg_application_get_type ())


typedef struct _SGapplication SGapplication;
typedef struct _SGapplicationClass SGapplicationClass;

struct _SGapplication
{
  GtkObject object;

  gboolean changed;
  GtkWidget *layer_control;

  gint num_worksheets;
  gint num_plots;
  gint last_worksheet;
  gint last_matrix;
  gint last_plot;
  gint last_dataset;

  SGlist *worksheets;
  SGlist *datasets;
  SGlist *plots;

  SGworksheet *active_worksheet;
  SGplot *active_plot;

  gchar *path;
  gchar *filename;

  SGclipboard *worksheet_cb;
  SGplotClipboard *plot_cb;
};

struct _SGapplicationClass
{
  GtkObjectClass parent_class;

  void (*add_worksheet)         (SGapplication *app, SGworksheet *worksheet);
  void (*add_matrix)            (SGapplication *app, SGworksheet *worksheet);
  void (*add_plot)              (SGapplication *app, SGplot *plot);
  void (*add_dataset)           (SGapplication *app, SGdataset *dataset);
  void (*remove_worksheet)      (SGapplication *app, SGworksheet *worksheet);
  void (*remove_matrix)         (SGapplication *app, SGworksheet *worksheet);
  void (*remove_plot)           (SGapplication *app, SGplot *plot);
  void (*remove_dataset)        (SGapplication *app, SGdataset *dataset);
  void (*rename_worksheet)      (SGapplication *app, SGworksheet *worksheet);
  void (*rename_matrix)         (SGapplication *app, SGworksheet *worksheet);
  void (*rename_plot)           (SGapplication *app, SGplot *plot);
  void (*rename_dataset)        (SGapplication *app, SGdataset *dataset);
  void (*activate_worksheet)    (SGapplication *app, SGworksheet *worksheet);
  void (*activate_plot)         (SGapplication *app, SGplot *plot);
  void (*changed)               (SGapplication *app);

};

GtkType 	sg_application_get_type			(void);
GtkObject * 	sg_application_new			(void);
void		sg_application_set_changed		(SGapplication *app,
							 gboolean changed);
gboolean	sg_application_changed			(SGapplication *app);
void		sg_application_add_worksheet		(SGapplication *app,
							 SGworksheet *w);
void		sg_application_add_matrix		(SGapplication *app,
							 SGworksheet *m);
void		sg_application_add_plot			(SGapplication *app,
							 SGplot *plot);
void		sg_application_add_dataset		(SGapplication *app,
							 SGdataset *data);
gboolean	sg_application_remove_worksheet		(SGapplication *app,
							 SGworksheet *w);
gboolean	sg_application_remove_matrix		(SGapplication *app,
							 SGworksheet *m);
gboolean	sg_application_remove_plot		(SGapplication *app,
							 SGplot *plot);
gboolean	sg_application_remove_dataset		(SGapplication *app,
							 SGdataset *data);
void		sg_application_rename_worksheet		(SGapplication *app,
							 SGworksheet *w);
void		sg_application_rename_matrix		(SGapplication *app,
							 SGworksheet *m);
void		sg_application_rename_plot		(SGapplication *app,
							 SGplot *plot);
void		sg_application_rename_dataset		(SGapplication *app,
							 SGdataset *data);
void		sg_application_refresh_datasets		(SGapplication *app);
void		sg_application_set_active_worksheet	(SGapplication *app,
							 SGworksheet *w);
void		sg_application_set_active_plot		(SGapplication *app,
							 SGplot *plot);
SGworksheet *	sg_application_active_worksheet		(SGapplication *app);
SGplot *	sg_application_active_plot		(SGapplication *app);
SGdataset *	sg_application_get_dataset_by_id	(SGapplication *app,
							 gint id);
void		sg_application_set_path			(SGapplication *app,
							 const gchar *path);
void		sg_application_set_filename		(SGapplication *app,
							 const gchar *filename);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_APPLICATION_H__ */
