/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_CLIPBOARD_H__
#define __SG_CLIPBOARD_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include "sg_worksheet.h"

#define SG_CLIPBOARD(obj)        GTK_CHECK_CAST (obj, sg_clipboard_get_type (), SGclipboard)
#define GTK_TYPE_SG_CLIPBOARD   (sg_clipboard_get_type ())

#define SG_CLIPBOARD_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_clipboard_get_type(), SGclipboardClass)
#define GTK_IS_SG_CLIPBOARD(obj)     GTK_CHECK_TYPE (obj, sg_clipboard_get_type ())

typedef struct _SGclipboard SGclipboard;
typedef struct _SGclipboardClass SGclipboardClass;

struct _SGclipboard
{
  GObject object;

  GList *selection;
};

struct _SGclipboardClass
{
  GObjectClass parent_class;
};


GType sg_clipboard_get_type		(void);
GObject *sg_clipboard_new		(void);
void	sg_clipboard_copy		(SGclipboard *clipboard,
					 SGworksheet *worksheet,
					 gboolean clear);
void	sg_clipboard_paste		(SGclipboard *clipboard,
					 SGworksheet *worksheet);
void	sg_clipboard_clear		(SGclipboard *clipboard);
					 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_CLIPBOARD_H__ */

