.\"$Header: /home/vikas/netmgt/nocol/src/doc/RCS/eventselect.8,v 1.4 1994/11/29 20:12:56 vikas Exp $
.\"
.TH EVENTSELECT 8 "May 1994"
.SH NAME
eventselect \- NOCOL event selector.
.SH SYNOPSIS
.B eventselect
[
.B \-d
] [
.B \-l
] [
.B \-s
.I <sender>
] [
.B \-S
.I <site name>
] [
.B \-v
.I <severity as Critical|Error|Warning|Info>
] [
.B \-f
.I <fromtime>
] [
.B \-t
.I <to time>
] [
.I nocol-data-files ...
]
.\"
.SH DESCRIPTION
.LP
.B eventselect
parses all NOCOL format data files and outputs only those events that
match the criterion specified on the command line. The output of
.B eventselect
is text strings in the nocol LOG format.

The program is useful for running periodically from the
.I crontab
and list all sites that are in a particular severity for more than a
certain amount of time (like escalate the problem internally and
send email to someone else within a group). See the
.I utility/notifier
script for an example of using this program.

Events can be selected based on the site-name, the monitor (sender)
name, the severity and the time stamp of the event. Multiple site and
sender names can be specified. The time can also be specified as 
incremental values (seconds from the current time).

The matching events are printed out on the standard output as text
lines in the nocol log (
.IR noclogd (8)
) format. Optionally, the events can be sent to the logging daemon (in
case the 
.I noclogd
daemon starts up later and we need to log the existing state of the
events to the logging daemon).

.SH OPTIONS
.TP 3
.B \-d
prints debugging output.
.TP 3
.B \-l
log matching events to the \fI noclogd\fR daemon. Useful to log existing
events in case the logging daemon starts up after the various monitors.
.TP 3
.B \-s
.I <sender name>
This is the name of the NOCOL monitoring program (EVENT.sender). Multiple
sender names can be specified using multiple '\-s'  options. A sub-string
will also be matched.
.TP 3
.B \-S
.I <site name>
This is the name of the site (EVENT.site.name). Multiple site-names can
be specified by repeating the '\-S' options.
.TP 3
.B \-v
.I <minimum severity>
Minimum severity of the event (critical or error or warning or info). Only
the first letter need to be specified.
.TP 3
.B \-f
.I <from time>
The minimum timestamp of the events. It is specified in the Unix 'date'
format (Oct 1, 1993 23:15). It can also be specified as an incremental
value (number of seconds from the current time) by prefixing the number
of seconds with a '+' sign (+3600 means in the past 1 hour=3600secs).
Default (if no value is specified) time is zero (beginning of eternity).
.TP 3
.B \-t
.I <to time>
This is the maximum timestamp of the events. It has the same format as
the 
.I from-time
described above.
.sp
.I e.g.
.RS
  eventselect 
\-s pingmon  \-s tpmon  \-S bellcore \-S rutgers \-v E 
\-f 'Oct 25 05:00'  -t +3600
.RE
.TP 3
.I nocol-data-files
This is a list of NOCOL format datafiles that are to be processed. If
no file is specified, the program reads from the standard input (
.I stdin
).
.\"------------------------------------
.SH AUTHOR
Vikas Aggarwal, vikas@navya.com
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

