/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestServerSideInclude
extends AbstractAppParamPlugin {
    private static final String SSI_UNIX = "<!--#EXEC cmd=\"ls /\"-->";
    private static final String SSI_UNIX2 = "\"><!--#EXEC cmd=\"ls /\"--><";
    private static final String SSI_WIN = "<!--#EXEC cmd=\"dir \\\"-->";
    private static final String SSI_WIN2 = "\"><!--#EXEC cmd=\"dir \\\"--><";
    private static Pattern patternSSIUnix = Pattern.compile("\\broot\\b.*\\busr\\b", 10);
    private static Pattern patternSSIWin = Pattern.compile("\\bprogram files\\b.*\\b(WINDOWS|WINNT)\\b", 10);

    public int getId() {
        return 40002;
    }

    public String getName() {
        return "Server side include";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Certain parameters may cause Server Side Include commands to be executed.  This may allow database connection or arbitrary code to be executed.";
        return string;
    }

    public int getCategory() {
        return 4;
    }

    public String getSolution() {
        String string = "Do not trust client side input and enforece tight check in the server side.  Disable server side include.\r\n. Refer to manual to disable Sever Side Include.\r\n. Use least privilege to run your web server or application server.\r\nFor Apache, disable the following:\r\nOptions Indexes FollowSymLinks Includes\r\nAddType application/x-httpd-cgi .cgi\r\nAddType text/x-server-parsed-html .html\r\n";
        return string;
    }

    public String getReference() {
        String string = "http://www.carleton.ca/~dmcfet/html/ssi.html";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        try {
            this.setParameter(httpMessage, string, SSI_UNIX);
            this.sendAndReceive(httpMessage);
            string3 = httpMessage.getResponseBody().toString();
            if (this.matchBodyPattern(httpMessage, patternSSIUnix, null)) {
                this.bingo(3, 1, null, string, null, httpMessage);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            httpMessage = this.getNewMsg();
            this.setParameter(httpMessage, string, SSI_UNIX2);
            this.sendAndReceive(httpMessage);
            string3 = httpMessage.getResponseBody().toString();
            if (this.matchBodyPattern(httpMessage, patternSSIUnix, null)) {
                this.bingo(3, 1, null, string, null, httpMessage);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            httpMessage = this.getNewMsg();
            this.setParameter(httpMessage, string, SSI_WIN);
            this.sendAndReceive(httpMessage);
            string3 = httpMessage.getResponseBody().toString();
            if (this.matchBodyPattern(httpMessage, patternSSIWin, null)) {
                this.bingo(3, 1, null, string, null, httpMessage);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            httpMessage = this.getNewMsg();
            this.setParameter(httpMessage, string, SSI_WIN2);
            this.sendAndReceive(httpMessage);
            string3 = httpMessage.getResponseBody().toString();
            if (this.matchBodyPattern(httpMessage, patternSSIWin, null)) {
                this.bingo(3, 1, null, string, null, httpMessage);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

