/* example4.c -- this is an example using 3-D perspective graphics.  A
 * surface, defined by a constant value of a 3-D field, is displayed
 * in perspective view.  The 3-D field has axial symmetry, and is
 * defined by rotating a 2-D field about a vertical axis.
 */
#include <stdio.h>
#include <math.h>
#include "pgraf.h"
#define NR 10
#define NZ 10
int ir,iz,i;
float ar[NR][NZ],r,z,orig[3],ra[3],za[3],theta;
main()
{
/* initialize the 2-D field in r-z space */
  for (ir = 0; ir < NR; ir++) {
    for (iz = 0; iz < NZ; iz++) {
      r = ir;
      z = iz - NZ/2;
      ar[ir][iz] = exp(-r*r/100. - z*z/20.);
    }
  }
/* initialize graphics and set up window */
  gopen();
  gclear();
  window(1,0.,15.,0.,10.);
/* define the perspective viewpoint, the object center, and the zoom */
  pview(1,0.,2.5,1.5,0.,0.,0.,2.);
/* define the planes in which a contour will be drawn */
/* start with things that don't change with the plane orientation */
  for (i = 0; i < 3; i++) {
    orig[i] = 0.;
    za[i] = 0.;
  }
  orig[2] = -.5;
/* za points vertically, ra points radially */
  za[2] = 1.;
  ra[2] = 0.;
/* finish the above job for 20 different plane orientations */
  for (i = 0; i < 20; i++) {
    theta = 6.28318*i/20.;
    ra[0] = cos(theta);
    ra[1] = sin(theta);
/* draw the contour outlining the object for each plane orientation */
    pconto(1,1,NR,NZ,.5,ar,orig,ra,za);
  }
/* finish up the graphics */
  gpause();
  gclose();
}
