SET SESSION FOREIGN_KEY_CHECKS=0;


/* Create Tables */

CREATE TABLE T_CONFIGURE
(
	CON_ID int NOT NULL AUTO_INCREMENT COMMENT '環境設定ID',
	NAME varchar(255) NOT NULL COMMENT '名前',
	VALUE text NOT NULL COMMENT '値',
	PRIMARY KEY (CON_ID)
) COMMENT = '環境設定情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_READ
(
	RED_ID int NOT NULL AUTO_INCREMENT COMMENT '読んだ！ID',
	TML_ID int NOT NULL COMMENT 'タイムラインID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	PRIMARY KEY (RED_ID)
) COMMENT = '読んだ！情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_PLUGIN
(
	PLU_ID int NOT NULL AUTO_INCREMENT COMMENT 'プラグインID',
	NAME varchar(255) NOT NULL COMMENT '名前',
	DISP_NAME varchar(255) NOT NULL COMMENT '表示名',
	FILE_NAME varchar(255) NOT NULL COMMENT 'ファイル名',
	DESCRIPTION text NOT NULL COMMENT '説明',
	AUTHOR varchar(255) NOT NULL COMMENT '作成者',
	URL varchar(255) NOT NULL COMMENT 'URL',
	DB varchar(255) COMMENT 'DB',
	NOT_STOP int DEFAULT 0 NOT NULL COMMENT 'ストップ',
	STATUS int NOT NULL COMMENT 'ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	LAST_UPDATE datetime NOT NULL COMMENT '更新日',
	DEL_FLG boolean NOT NULL COMMENT '削除日',
	PRIMARY KEY (PLU_ID)
) COMMENT = 'プラグイン情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_MESSAGE
(
	MSG_ID int NOT NULL AUTO_INCREMENT COMMENT 'メッセージ情報ID',
	S_USR_ID int NOT NULL COMMENT '送信者ユーザID',
	S_NAME text NOT NULL COMMENT '送信者の名前',
	R_USR_ID int NOT NULL COMMENT '受信者ユーザID',
	R_NAME text NOT NULL COMMENT '受信者の名前',
	MESSAGE text NOT NULL COMMENT 'メッセージ',
	SUBJECT varchar(255) NOT NULL COMMENT '件名',
	STATUS boolean NOT NULL COMMENT 'ステータス',
	RED tinyint(4) NOT NULL COMMENT '既読ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	DEL_FLG int DEFAULT 0 NOT NULL COMMENT '削除日',
	PRIMARY KEY (MSG_ID)
) COMMENT = 'メッセージ情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_WATCH
(
	WCH_ID int NOT NULL AUTO_INCREMENT COMMENT 'ウォッチリストID',
	TML_ID int NOT NULL COMMENT 'タイムラインID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	PRIMARY KEY (WCH_ID)
) COMMENT = 'ウォッチ情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_JOIN
(
	JIN_ID int NOT NULL AUTO_INCREMENT COMMENT 'グループ参加ID',
	GRP_ID int NOT NULL COMMENT 'グループID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	STATUS int COMMENT 'ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	LAST_UPDATE datetime NOT NULL COMMENT '更新日',
	PRIMARY KEY (JIN_ID)
) COMMENT = 'グループ参加情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_FILE
(
	FLE_ID int NOT NULL AUTO_INCREMENT COMMENT 'ファイルID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	GRP_ID int NOT NULL COMMENT 'グループID',
	ORIGINAL_NAME varchar(255) NOT NULL COMMENT '元のファイル名',
	RAND_NAME varchar(255) NOT NULL COMMENT 'ランダムファイル名',
	EXTENSION varchar(255) COMMENT '拡張子',
	F_TYPE varchar(255) NOT NULL COMMENT 'ファイル形式',
	F_SIZE varchar(255) NOT NULL COMMENT 'ファイルサイズ',
	PUBLIC boolean NOT NULL COMMENT '公開ステータス',
	DISP int DEFAULT 1 NOT NULL COMMENT 'DISP',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	LAST_UPDATE datetime NOT NULL COMMENT '更新日',
	DEL_FLG boolean NOT NULL COMMENT '削除フラグ',
	PRIMARY KEY (FLE_ID)
) COMMENT = 'ファイル情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_NOTE
(
	NOTE_ID int NOT NULL AUTO_INCREMENT COMMENT 'ノートID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	TITLE text NOT NULL COMMENT 'タイトル',
	CONTENT text NOT NULL COMMENT 'コンテンツ',
	PUBLIC varchar(20) COMMENT 'PUBLIC',
	STATUS int NOT NULL COMMENT 'ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	UPDATE_DATE datetime NOT NULL COMMENT '更新日',
	PRIMARY KEY (NOTE_ID)
) COMMENT = 'ノート' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_REQUEST
(
	REQ_ID int NOT NULL AUTO_INCREMENT COMMENT '申請情報ID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	GRP_ID int NOT NULL COMMENT 'グループID',
	TYPE int NOT NULL COMMENT '種別',
	MAIL varchar(255) COMMENT 'メールアドレス',
	TOKEN varchar(255) COMMENT 'トークン',
	PASSWORD varchar(255) COMMENT 'パスワード',
	MESSAGE text COMMENT 'メッセージ',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	PRIMARY KEY (REQ_ID)
) COMMENT = 'リクエスト情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_TIME_LINE
(
	TML_ID int NOT NULL AUTO_INCREMENT COMMENT 'タイムラインID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	ACT_ID int NOT NULL COMMENT 'アクションID',
	VAL_ID int COMMENT '値',
	MESSAGE text NOT NULL COMMENT 'メッセージ',
	RED_NUM int DEFAULT 0 NOT NULL COMMENT '読んだ！数',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	LAST_DATE datetime COMMENT '更新日',
	DEL_FLG boolean NOT NULL COMMENT '削除日',
	PRIMARY KEY (TML_ID)
) COMMENT = 'タイムライン情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_NOTICE
(
	NTC_ID int NOT NULL AUTO_INCREMENT COMMENT '通知ID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	GRP_ID int NOT NULL COMMENT 'グループID',
	TML_ID int NOT NULL COMMENT 'タイムラインID',
	CMT_ID int COMMENT 'CMT_ID',
	P_USR_ID int NOT NULL COMMENT '動作行ったユーザID',
	ACT_ID int NOT NULL COMMENT 'アクションID',
	STATUS int NOT NULL COMMENT 'ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	PRIMARY KEY (NTC_ID)
) COMMENT = '通知情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE M_GROUP
(
	GRP_ID int NOT NULL AUTO_INCREMENT COMMENT 'グループID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	NAME varchar(255) NOT NULL COMMENT 'グループ名',
	TYPE int NOT NULL COMMENT '種別',
	DESCRIPTION text COMMENT '説明',
	DIRECTORY1 varchar(255) COMMENT 'グループディレクトリ1',
	DIRECTORY2 varchar(255) COMMENT 'グループディレクトリ2',
	THUMBNAIL varchar(255) COMMENT 'サムネイル',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	LAST_UPDATE datetime NOT NULL COMMENT '更新日',
	DEL_FLG boolean NOT NULL COMMENT '削除日',
	PRIMARY KEY (GRP_ID)
) COMMENT = 'グループ情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_USER
(
	USR_ID int NOT NULL AUTO_INCREMENT COMMENT 'ユーザID',
	GRP_ID int(11) COMMENT 'マイグループ',
	NAME varchar(255) COMMENT 'ユーザ名',
	NAME_KANA varchar(255) COMMENT 'ユーザ名（カナ）',
	UNIT varchar(255) COMMENT '部署名',
	MAIL varchar(255) NOT NULL COMMENT 'メールアドレス',
	PASSWORD varchar(255) COMMENT 'パスワード',
	FOLLOWER int DEFAULT 0 NOT NULL COMMENT 'フォロワー',
	FOLLOWING int DEFAULT 0 NOT NULL COMMENT 'フォロー',
	POSTCODE1 varchar(3) COMMENT '郵便番号1',
	POSTCODE2 varchar(4) COMMENT '郵便番号2',
	CNT_ID int COMMENT '都道府県ID',
	ADDRESS varchar(255) COMMENT '住所',
	PHONE_NO1 varchar(5) COMMENT '電話番号1',
	PHONE_NO2 varchar(4) COMMENT '電話番号2',
	PHONE_NO3 varchar(4) COMMENT '電話番号3',
	M_PHONE_NO1 varchar(5) COMMENT '携帯番号1',
	M_PHONE_NO2 varchar(4) COMMENT '携帯番号2',
	M_PHONE_NO3 varchar(4) COMMENT '携帯番号3',
	DESCRIPTION text COMMENT '自己紹介',
	RANDOM_KEY varchar(255) COMMENT 'ランダムキー',
	DIRECTORY1 varchar(255) COMMENT 'ディレクトリ1',
	DIRECTORY2 varchar(255) COMMENT 'ディレクトリ2',
	THUMBNAIL varchar(255) COMMENT 'サムネイル',
	AUTHORITY int NOT NULL COMMENT '権限',
	STATUS int NOT NULL COMMENT 'ステータス',
	INSERT_DATE datetime COMMENT '登録日',
	LAST_UPDATE datetime COMMENT '更新日',
	DEL_FLG int DEFAULT 0 NOT NULL COMMENT '削除フラグ',
	PRIMARY KEY (USR_ID)
) COMMENT = 'ユーザ情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


CREATE TABLE T_FRIEND
(
	FRD_ID int NOT NULL AUTO_INCREMENT COMMENT '友達情報ID',
	USR_ID int NOT NULL COMMENT 'ユーザID',
	F_USR_ID int NOT NULL COMMENT 'フォローユーザID',
	STATUS int COMMENT 'ステータス',
	INSERT_DATE datetime NOT NULL COMMENT '登録日',
	PRIMARY KEY (FRD_ID)
) COMMENT = '友達情報' DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;



