<?php

declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Backend\ViewHelpers\Toolbar;

use TYPO3\CMS\Backend\Toolbar\ToolbarItemInterface;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

/**
 * ViewHelper condition to checks whether a toolbar item provides a dropdown menu.
 *
 * ```
 *  <be:toolbar.ifHasDropdown class="{toolbarItem}">
 *      <f:then>...</f:then>
 *      <f:else>...</f:else>
 *  </be:toolbar.ifHasDropdown>
 * ```
 *
 * @see https://docs.typo3.org/permalink/t3viewhelper:typo3-backend-toolbar-ifhasdropdown
 * @internal
 */
class IfHasDropdownViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('class', ToolbarItemInterface::class, 'The toolbar item class to be checked for providing a drop down', true);
    }

    /**
     * @param array{class: object} $arguments
     */
    public static function verdict(array $arguments, RenderingContextInterface $renderingContext): bool
    {
        return $arguments['class'] instanceof ToolbarItemInterface && $arguments['class']->hasDropDown();
    }
}
