# -*- encoding: utf-8 -*-

require File.dirname(__FILE__) + '/helper.rb'

class TestEncode < Test::Unit::TestCase

  include Color::RGB::JP::Base::Encode

  def test_internal_encoding
    assert_kind_of(String, Color::RGB::JP::Base::Encode::INTERNAL_ENCODING)
  end

  def test_encode_to_nil
    assert_nil(encode_to(nil, nil, nil))
    assert_nil(encode_to("Shift_JIS", "UTF-8", nil))

    assert_equal("あいう", encode_to(nil, nil, "あいう"))
    assert_equal("あいう", encode_to(nil, "UTF-8", "あいう"))
    assert_equal("あいう", encode_to("UTF-8", nil, "あいう"))
    assert_equal("あいう", encode_to("UTF-8", "UTF-8", "あいう"))
  end

  def test_encode_to
    assert_equal("あいう", encode_to("UTF-8", "Shift_JIS", "\x82\xa0\x82\xa2\x82\xa4"))
    assert_equal("あいう", encode_to("UTF-8", "EUC-JP", "\xa4\xa2\xa4\xa4\xa4\xa6"))
  end

  def test_with_internal_encoding
    with_internal_encoding(nil, nil) {|v|
      assert_nil(v)
    }
    with_internal_encoding(nil, "Shift_JIS") {|v|
      assert_nil(v)
    }
    with_internal_encoding("\x82\xa0\x82\xa2\x82\xa4", "Shift_JIS") {|v|
      assert_equal("あいう", v)
    }
    with_internal_encoding("あいう", "UTF-8") {|v|
      assert_equal("あいう", v)
    }
  end
end
