/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    public static int binarySearch(byte[] a, byte key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            byte d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(char[] a, char key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            char d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(short[] a, short key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            short d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(int[] a, int key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(long[] a, long key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            long d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(float[] a, float key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int r = Float.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(double[] a, double key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int r = Double.compare(a[mid], key);
            if (r == 0) {
                return mid;
            }
            if (r > 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(Object[] a, Object key) {
        return Arrays.binarySearch(a, key, null);
    }

    public static int binarySearch(Object[] a, Object key, Comparator c) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int d = Collections.compare(key, a[mid], c);
            if (d == 0) {
                return mid;
            }
            if (d < 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static boolean equals(boolean[] a1, boolean[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] a1, char[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(short[] a1, short[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(long[] a1, long[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(float[] a1, float[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Float.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double[] a1, double[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (Double.compare(a1[i], a2[i]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length == a2.length) {
            int i = a1.length;
            while (--i >= 0) {
                if (AbstractCollection.equals(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int i = fromIndex;
        while (i < toIndex) {
            a[i] = val;
            ++i;
        }
    }

    public static void sort(byte[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, byte[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static final void swap(int i, int j, byte[] a) {
        byte c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, byte[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final void qsort(byte[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(char[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, char[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static final void swap(int i, int j, char[] a) {
        char c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, char[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final void qsort(char[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(short[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, short[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static final void swap(int i, int j, short[] a) {
        short c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, short[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final void qsort(short[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = array[b] - array[from]) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = array[c] - array[from]) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(int[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, int[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static final void swap(int i, int j, int[] a) {
        int c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, int[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final int compare(int a, int b) {
        int n;
        if (a < b) {
            n = -1;
        } else {
            int n2 = 0;
            if (a == b) {
                n2 = 1;
            }
            n = 1 - n2;
        }
        return n;
    }

    private static final void qsort(int[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(long[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, long[] d) {
        return d[a] < d[b] ? (d[b] < d[c] ? b : (d[a] < d[c] ? c : a)) : (d[b] > d[c] ? b : (d[a] > d[c] ? c : a));
    }

    private static final void swap(int i, int j, long[] a) {
        long c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, long[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final int compare(long a, long b) {
        int n;
        if (a < b) {
            n = -1;
        } else {
            int n2 = 0;
            if (a == b) {
                n2 = 1;
            }
            n = 1 - n2;
        }
        return n;
    }

    private static final void qsort(long[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && array[j - 1] > array[j]) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Arrays.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Arrays.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(float[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, float[] d) {
        return Float.compare(d[a], d[b]) < 0 ? (Float.compare(d[b], d[c]) < 0 ? b : (Float.compare(d[a], d[c]) < 0 ? c : a)) : (Float.compare(d[b], d[c]) > 0 ? b : (Float.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static final void swap(int i, int j, float[] a) {
        float c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, float[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final void qsort(float[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Float.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Float.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Float.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(double[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(a, fromIndex, toIndex - fromIndex);
    }

    private static final int med3(int a, int b, int c, double[] d) {
        return Double.compare(d[a], d[b]) < 0 ? (Double.compare(d[b], d[c]) < 0 ? b : (Double.compare(d[a], d[c]) < 0 ? c : a)) : (Double.compare(d[b], d[c]) > 0 ? b : (Double.compare(d[a], d[c]) > 0 ? c : a));
    }

    private static final void swap(int i, int j, double[] a) {
        double c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static final void vecswap(int i, int j, int n, double[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static final void qsort(double[] array, int from, int count) {
        int d;
        int b;
        if (count <= 7) {
            int i = from + 1;
            while (i < from + count) {
                int j = i;
                while (j > from && Double.compare(array[j - 1], array[j]) > 0) {
                    Arrays.swap(j, j - 1, array);
                    --j;
                }
                ++i;
            }
            return;
        }
        int mid = count / 2;
        int lo = from;
        int hi = from + count - 1;
        if (count > 40) {
            int s = count / 8;
            lo = Arrays.med3(lo, lo + s, lo + 2 * s, array);
            mid = Arrays.med3(mid - s, mid, mid + s, array);
            hi = Arrays.med3(hi - 2 * s, hi - s, hi, array);
        }
        mid = Arrays.med3(lo, mid, hi, array);
        Arrays.swap(from, mid, array);
        int a = b = from;
        int c = d = from + count - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = Double.compare(array[b], array[from])) <= 0) {
                if (comp == 0) {
                    Arrays.swap(a, b, array);
                    ++a;
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = Double.compare(array[c], array[from])) >= 0) {
                if (comp == 0) {
                    Arrays.swap(c, d, array);
                    --d;
                }
                --c;
            }
            if (b > c) break;
            Arrays.swap(b, c, array);
            ++b;
            --c;
        }
        hi = from + count;
        int span = Math.min(a - from, b - a);
        Arrays.vecswap(from, b - span, span, array);
        span = Math.min(d - c, hi - d - 1);
        Arrays.vecswap(b, hi - span, span, array);
        span = b - a;
        if (span > 1) {
            Arrays.qsort(array, from, span);
        }
        if ((span = d - c) > 1) {
            Arrays.qsort(array, hi - span, span);
        }
    }

    public static void sort(Object[] a) {
        Arrays.sort(a, 0, a.length, null);
    }

    public static void sort(Object[] a, Comparator c) {
        Arrays.sort(a, 0, a.length, c);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        Arrays.sort(a, fromIndex, toIndex, null);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex, Comparator c) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int chunk = fromIndex;
        while (chunk < toIndex) {
            int end = Math.min(chunk + 6, toIndex);
            int i = chunk + 1;
            while (i < end) {
                if (Collections.compare(a[i - 1], a[i], c) > 0) {
                    int j = i;
                    Object elem = a[j];
                    do {
                        a[j] = a[j - 1];
                    } while (--j > chunk && Collections.compare(a[j - 1], elem, c) > 0);
                    a[j] = elem;
                }
                ++i;
            }
            chunk += 6;
        }
        int len = toIndex - fromIndex;
        if (len <= 6) {
            return;
        }
        Object[] src = a;
        Object[] dest = new Object[len];
        Object[] t = null;
        int srcDestDiff = -fromIndex;
        int size = 6;
        while (size < len) {
            int start = fromIndex;
            while (start < toIndex) {
                int mid = start + size;
                int end = Math.min(toIndex, mid + size);
                if (mid >= end || Collections.compare(src[mid - 1], src[mid], c) <= 0) {
                    System.arraycopy(src, start, dest, start + srcDestDiff, end - start);
                } else if (Collections.compare(src[start], src[end - 1], c) > 0) {
                    System.arraycopy(src, start, dest, end - size + srcDestDiff, size);
                    System.arraycopy(src, mid, dest, start + srcDestDiff, end - mid);
                } else {
                    int p1 = start;
                    int p2 = mid;
                    int i = start + srcDestDiff;
                    while (p1 < mid && p2 < end) {
                        dest[i++] = src[Collections.compare(src[p1], src[p2], c) <= 0 ? p1++ : p2++];
                    }
                    if (p1 < mid) {
                        System.arraycopy(src, p1, dest, i, mid - p1);
                    } else {
                        System.arraycopy(src, p2, dest, i, end - p2);
                    }
                }
                start += size << 1;
            }
            t = src;
            src = dest;
            dest = t;
            fromIndex += srcDestDiff;
            toIndex += srcDestDiff;
            srcDestDiff = -srcDestDiff;
            size <<= 1;
        }
        if (src != a) {
            System.arraycopy(src, 0, a, srcDestDiff, toIndex);
        }
    }

    public static List asList(Object[] a) {
        return new ArrayList(a);
    }

    private Arrays() {
    }

    private static final class ArrayList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final Object[] a;

        public final Object get(int index) {
            return this.a[index];
        }

        public final int size() {
            return this.a.length;
        }

        public final Object set(int index, Object element) {
            Object old = this.a[index];
            this.a[index] = element;
            return old;
        }

        public final boolean contains(Object o) {
            boolean bl = false;
            if (this.lastIndexOf(o) >= 0) {
                bl = true;
            }
            return bl;
        }

        public final int indexOf(Object o) {
            int size = this.a.length;
            int i = 0;
            while (i < size) {
                if (ArrayList.equals(o, this.a[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public final int lastIndexOf(Object o) {
            int i = this.a.length;
            while (--i >= 0) {
                if (!ArrayList.equals(o, this.a[i])) continue;
                return i;
            }
            return -1;
        }

        public final Object[] toArray() {
            return (Object[])this.a.clone();
        }

        public final Object[] toArray(Object[] array) {
            int size = this.a.length;
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.a, 0, array, 0, size);
            return array;
        }

        ArrayList(Object[] a) {
            if (a == null) {
                throw new NullPointerException();
            }
            this.a = a;
        }
    }
}

