# patattack.pl is in the public domain.
# Written by Thomas Morgan <tmorgan@pobox.com>

$add_ons .= '+patattack.pl' unless $add_ons =~ /\+patattack\.pl/;

# The first argument to /patattack is the nick of the recipient.  The
# second is a size specification, in the form of ROWSxCOLS.  For
# example, `/patattack slackie 2x3' produces:
#
#   >slackie< *pat* *pat* *pat*
#   >slackie< *pat* *pat* *pat*
#
# /patattack accepts an option called `--combine' or `-c' for short.
# It directs /patattack to combine the pats to form a larger pat.  For
# example, `/patattack slackie 2x3' produces:
#
#   >slackie< *patpatpat*
#   >slackie< *patpatpat*

sub cmd_patattack
{
  local (@args);
  local ($floodee, $size);
  local ($rows, $cols);
  local ($combinep, $pat);

  $combinep = ($args =~ s/-c\b//g
	       || $args =~ s/--combine\b//g);

  ($floodee, $size) = split (" ", $args, 2);
  ($rows, $cols) = split (/x/, $size);

  $pat = ($combinep
	  ? '*' . 'pat' x $cols . '*'
	  : '*pat* ' x $cols);

  &msg ($floodee, $pat) while $rows--;
}
&addcmd ('patattack');
