#!/depot/path/tclsh

# This CGI script shows how to create a cookie.

package require cgi

cgi_eval {
    source example.tcl

    cgi_input

    cgi_http_head {
	cgi_content_type text/html
	if {0==[catch {cgi_import Name}]} {
	    cgi_export_cookie Name expires=never
	} else {
	    catch {cgi_import_cookie Name}
	}
    }
    cgi_head {
	cgi_title "Cookie Form Example"
    }
    cgi_body {
	p "This form finds a value from a previous submission of \
		the form either directly or through a cookie."
	set Name ""

	puts [bold "Result: "]

	if {0==[catch {cgi_import Name}]} {
	    put "Value found via form submission.  Bookmark this form,
	    visit somewhere else, and return to get the value via cookie."
	} elseif {0==[catch {cgi_import_cookie Name}]} {
	    put "Value found via cookie.  Note: you must exit
	    browser gracefully for cookie to be saved."
	} else {
	    put "Value not found.  Enter a value and press return."
	}

	cgi_form cookie {
	    puts "Value: "
	    cgi_text Name
	}
    }
}
