//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _WPT_TYPE_H
#define _WPT_TYPE_H

#include "constants.h"
#include "packet.h"
#include "gpdlinetool.h"

#include <string>
#include <iostream>
#include <math.h>


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// base waypoint class
class Wpt_Type : GPDLineTool, Constants
{
 public:

   virtual ~Wpt_Type(){}

   /// output-string return the data in gpd-string format 
   string os(void);

   void os(ostream);

   Wpt_Type(void);

   /**
    * Builds a new waypoint from its coordinates and properties.
    * Default comment is empty, default symbol is a dot, default display
    * option is symbol and name
    */
   Wpt_Type(const string &name, double longitude, double latitude,
	    float altitude, const string &comment = "",
	    const string &symbol = "wpt_dot",
	    const string &option = "symbol+name", bool rtpoint = false);

   /// set the data by garmin-packet 
   virtual void set(Packet);


   /// make Packet
   virtual Packet makePacket(void);
   
   /// set the data by gpd-string
   void set(string);

   /// same as set
   void operator<<(string);

   /// 
   virtual void clear(void);

   /// returns waypoint name
   const string &getName() const { return name; }

   /// returns waypoint associated comment
   const string &getComment() const { return comment; }

   /// returns waypoint symbol as a string representation
   const string &getSymbol() const { return symbol; }

   /// returns waypoint display option (string representation)
   const string &getDisplayOption() const { return display_option; }

   /// returns waypoint altitude
   float getAltitude() const { return altitude; }

   /// returns waypoint latitude (angle in radian)
   double getLatitude() const { return latitude; }

   /// returns waypoint longitude (angle in radian)
   double getLongitude() const { return longitude; }

   /// return false if this point is a waypoint or true if this is a route
   /// point
   bool isRoutePoint() const { return isRoutepoint; }

 protected:

   /// semicircle to double 
   double s2d(g_long sc);

   /// double to semicicle 
   g_long d2s(double deg);

   string   name;
   string   comment;
   float    altitude;
   double   latitude;
   double   longitude;
   string   symbol;
   string   display_option;
   
   bool isvalid;
   bool isRoutepoint;


 private:

		
};

}

#endif 
