/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.broad.igv.feature.Cytoband;

public class Chromosome {
    private String name;
    private int index;
    private int length = 0;
    private List<Cytoband> cytobands;

    public Chromosome(int index, String name, int length) {
        this.index = index;
        this.name = name;
        this.length = length;
        Cytoband cytoband = new Cytoband(name);
        cytoband.setStart(0);
        cytoband.setEnd(length);
        this.cytobands = Arrays.asList(cytoband);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int ii) {
        this.index = ii;
    }

    public List<Cytoband> getCytobands() {
        return this.cytobands;
    }

    public void setCytobands(List<Cytoband> cytobands) {
        this.cytobands = cytobands;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Chromosome && ((Chromosome)obj).getIndex() == this.getIndex() && ((Chromosome)obj).getLength() == this.getLength();
    }

    public int hashCode() {
        return Objects.hash(this.index, this.length);
    }
}

