/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

public abstract class Authenticator {
    private static Authenticator defaultAuthenticator;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;

    public static void setDefault(Authenticator authenticator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new NetPermission("setDefaultAuthenticator"));
        }
        defaultAuthenticator = authenticator;
    }

    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) throws SecurityException {
        return Authenticator.requestPasswordAuthentication(null, inetAddress, n, string, string2, string3);
    }

    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new NetPermission("requestPasswordAuthentication"));
        }
        if (defaultAuthenticator == null) {
            return null;
        }
        Authenticator.defaultAuthenticator.host = string;
        Authenticator.defaultAuthenticator.addr = inetAddress;
        Authenticator.defaultAuthenticator.port = n;
        Authenticator.defaultAuthenticator.protocol = string2;
        Authenticator.defaultAuthenticator.prompt = string3;
        Authenticator.defaultAuthenticator.scheme = string4;
        return defaultAuthenticator.getPasswordAuthentication();
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final String getRequestingHost() {
        return this.host;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

