/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;

final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final FloatBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final float get() {
        this.checkForUnderflow();
        float f = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return f;
    }

    public final FloatBuffer put(float f) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = f;
        this.position(this.position() + 1);
        return this;
    }

    public final float get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public final FloatBuffer put(int n, float f) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = f;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    FloatBufferImpl(int n) {
        this(new float[n], 0, n, n, 0, -1, false);
    }

    FloatBufferImpl(float[] fArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = fArray;
        this.array_offset = n;
        this.readOnly = bl;
    }
}

