/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class StringCreator {
    private static final String createStringFromChars(char[] data) {
        return new String(data);
    }

    private static final String createString(byte[] data) {
        int size = data.length;
        char[] value = new char[size];
        int count = 0;
        int i = 0;
        while (i < size) {
            int y;
            int x = data[i] & 0xFF;
            if (x >>> 7 == 0) {
                value[count++] = (char)x;
            } else if (x >>> 5 == 6) {
                y = data[++i] & 0xFF;
                value[count++] = (char)(((x & 0x1F) << 6) + (y & 0x3F));
            } else {
                y = data[++i] & 0xFF;
                int z = data[++i] & 0xFF;
                value[count++] = (char)(((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F));
            }
            ++i;
        }
        return new String(value, 0, count);
    }

    private static final int getLength(String s) {
        return s.length();
    }

    private static final int getUTFLength(String s) {
        return StringCreator.getUTFLength(s, 0, s.length());
    }

    private static final int getUTFLength(String s, int start, int len) {
        int result = 0;
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < len) {
            char c = chars[i + start];
            result = c >= '\u0001' && c <= '\u007f' ? ++result : (c >= '\u0800' ? (result += 3) : (result += 2));
            ++i;
        }
        return result;
    }

    private static final String createInternedString(byte[] data) {
        return StringCreator.createString(data).intern();
    }

    private static final char[] getChars(String s) {
        return s.toCharArray();
    }

    private static final byte[] getUTFChars(String s) {
        byte[] result = new byte[StringCreator.getUTFLength(s) + 1];
        char[] chars = s.toCharArray();
        int len = chars.length;
        int current = 0;
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                result[current++] = (byte)c;
            } else if (c >= '\u0800') {
                result[current++] = (byte)(0xE0 | c >> 12 & 0xF);
                result[current++] = (byte)(0x80 | c >> 6 & 0x2F);
                result[current++] = (byte)(0x80 | c & 0x2F);
            } else {
                result[current++] = (byte)(0xC0 | c >> 6 & 0x1F);
                result[current++] = (byte)(0x80 | c & 0x2F);
            }
            ++i;
        }
        return result;
    }

    StringCreator() {
    }
}

