#===========================================================================

# Robot used with LWP::Parallel to preload pages we know we're going
# to need, before the main logic gets to them.
#
package Sitescooper::ParUserAgent;

use LWP::Parallel::RobotUA;
use HTTP::Request;

require WWW::RobotRules::AnyDBM_File;

BEGIN {
  @ISA = qw(LWP::Parallel::RobotUA);
}

sub set_caches {
  my $self = shift;

  my $rules = new WWW::RobotRules::AnyDBM_File 'ParallelUA', 'cache';

  # create a fake Robot object to use to cache preloaded pages.
  # the directory named here should never be used.
  $self->{cacher} = new Sitescooper::Robot
	    (undef, $CF::user_tmpdir.$CF::slash."preload_tmp", undef);
  $self->{cacher}->{cachedir} = $CF::cachedir;
  $self->{cacher}->{newcachedir} = $CF::newcachedir;
  $self->{cacher}->{sharedcachedir} = $CF::sharedcache;

  $self->{ok_responses} = ();
}

sub on_return {
  my ($self, $req, $resp, $entry) = @_;

  &Scoop::dbg ("preload: ".$resp->code." for ".
			      $req->url.": ".$resp->message);

  if ($resp->is_success) {
    $self->{ok_responses}->{$req->url->as_string} = $resp;
  } else {
    # don't cache -- let the conventional logic deal with it.
  }
  return;
}

sub register {
  my $self = shift;
  my $url = shift;

  if ($url !~ /^http:/i) { return; }		# only http URLs

  $self->SUPER::register (new HTTP::Request ('GET', $url));
  &Scoop::dbg ("preload: registered $url");
}

1;
