#!/bin/sh
#
# wm-oldmenu2new: script to convert from old-style WindowMaker
# menu file to the new PropertyList style of the WMRootMenu.
#
# Note: ex in all the Linux systems I've used is badly
# broken, except for nex.  perl can be relied on however.
# Re-written to use perl.
#
# Local dependencies:
#   None.
#
# Authors: Luke Kendall, Toby J Sargeant
#
# Copyright waived; no warranty provided.
#
# $Id: wm-oldmenu2new.sh,v 1.8 2000/03/29 21:06:35 hafner Exp $
# $Date: 2000/03/29 21:06:35 $
# $Author: hafner $
# $Revision: 1.8 $
# $State: Exp $
#

MYNAME="`basename "$0"`"
USAGE="usage: oldmenu newmenu"

if [ $# != 2 ]
then
    echo "$USAGE" >&2
    exit 1
fi

[ "x$GNUSTEP_USER_ROOT" = x ] && export GNUSTEP_USER_ROOT="$HOME/GNUstep"
INCLUDES="-I'$GNUSTEP_USER_ROOT/Library/WindowMaker' -I/etc/X11/WindowMaker"

OLD_MENU="$1"
OLD_DIR="`dirname "$OLD_MENU"`"
OLD_NAME="`basename "$OLD_MENU"`"

if [ "$OLD_MENU" = "$OLD_NAME" ]
then
    if [ -r "$GNUSTEP_USER_ROOT/Library/WindowMaker/$OLD_NAME" ]
    then
	OLD_DIR="$GNUSTEP_USER_ROOT/Library/WindowMaker"
    elif [ -r "/etc/X11/WindowMaker/$OLD_NAME" ]
    then
	OLD_DIR=/etc/X11/WindowMaker
    else
        echo "$MYNAME: neither $GNUSTEP_USER_ROOT/Library/WindowMaker/$OLD_NAME nor /etc/X11/WindowMaker/$OLD_NAME exist" >&2
	exit 1
    fi	
fi    

NEW_MENU="$2"
NEW_DIR="`dirname "$NEW_MENU"`"
NEW_NAME="`basename "$NEW_MENU"`"

#
# For working out what cc is installed
#
which1()
{
    oldpath="$PATH"
    PATH=/bin:/usr/bin:/usr/local/bin

    IFS=":"
    for j in $oldpath
    do
	test -x "$j/$1" && test ! -d "$j/$1" && echo "$j/$1" && return 0
    done
    IFS=" "
    return 1
}

#
# Expand macros if necessary.
# Create a temp copy of the menu file to edit to turn into the new.
#
T="`tempfile -p wmenu`"
cd "$OLD_DIR" || exit 1
if [ ! -s "$OLD_NAME" ]
then
    echo "$MYNAME: $OLD_DIR/$OLD_NAME does not exist" >&2
    exit 1
fi
#
# Always pre-process, to join lines split with \, and to strip comments.
# Not to mention the main purpose, include & process wmmacros if used.
#
set -e
CC="`which1 gcc`"
[ "x$CC" = "x" ] && CC="`which1 cc`"
[ "x$CC" = "x" ] && "$MYNAME: no cc, gcc found - can't preprocess" >&2 && exit 1

#
# Use the "parse as if it's C option" if cc is gcc, because
# newer versions apparently get confused.  Apparently gcc -E does
# not simply run the preprocessor (that's sad).
#
strings "$CC" | grep -c gcc > /dev/null && GCC_FLAGS="-x c"
cp "$OLD_NAME" "$T-c"
#
# Given the set -e, the exit 1 shouldn't be needed.  But it is, on my NeXT!
#
"$CC" -E -I. $GCC_FLAGS $INCLUDES "$T-c" > "$T+c" || exit 1
sed '/^#/d;/^[ 	]*$/d' "$T+c" > "$T"
rm "$T-c" "$T+c"
set +e

#
# This is the interesting bit.  Edit the old style menu and
# convert into new style property-list menu.
#
perl - "$T" <<-'EOF' > "$T-p"
	$v=chr(22);
	for (<>) {
		push @foo,$_;
	}
	for (@foo) {
		s/\s*$//;
		s/^(\s*)"*(Workspaces*)"*\s\s*(WORKSPACE_MENU)/\1(\2, \3),/;
		s/^(\s*)("[^"]*")\s+MENU/\1($v\n\1\2,/;
		push @foo2,split "\n";
	}
	@foo=();
	for (@foo2) {
		s/^(\s*)"([^"]*)"\s\s*END/\1),/;
		s/^(\s*)"([^"]*)"\s\s*SHEXEC\s\s*(.*)$/\1($v\n\1"\2",$v\n\1SHEXEC,$v\n\1"\3"$v\n\1),/;
		s/^(\s*)"([^"]*)"\s\s*EXEC\s\s*(.*)$/\1($v\n\1"\2",$v\n\1EXEC,$v\n\1"\3"$v\n\1),/;
		push @foo,split "\n";
	}
	@foo2=();
	for (@foo) {
		 
s/^(\s*)"([^"]*)"\s\s*OPEN_MENU\s\s*(.*)$/\1($v\n\1"\2",$v\n\1OPEN_MENU,$v\n\1"\3"$v\n\1),/;
		push @foo2,split "\n";
	}
	@foo=();
	for (@foo2) {
		s/^(\s*)([^ 	]*)\s\s*MENU/\1($v\n\1"\2",/;
		push @foo,split "\n";
	}
	@foo2=();
	for (@foo) {
		s/^(\s*)([^ 	]*)\s\s*END/\1),/;
		s/^(\s*)([^ 	]*)\s\s*SHEXEC\s\s*(.*)$/\1($v\n\1"\2",$v\n\1SHEXEC,$v\n\1"\3"$v\n\1),/;
		s/^(\s*)([^ 	]*)\s\s*EXEC\s\s*(.*)$/\1($v\n\1"\2",$v\n\1EXEC,$v\n\1"\3"$v\n\1),/;
		push @foo2,split "\n";
	}
	@foo=();
	for (@foo2) {
		s/^(\s*)([^ 	 
]*)\s\s*OPEN_MENU\s\s*(.*)$/\1($v\n\1"\2",$v\n\1OPEN_MENU,$v\n\1"\3"$v\n\1),/;
		push @foo,split "\n";
	}
	@foo2=();
	for (@foo) {
		s/ WITH / QQQjjQQQ /;
		s/^(\s*)"([^"]*)"\s\s*([A-Z_][A-Z_]*)$/\1("\2", \3),/;
		s/^(\s*)"([^"]*)"\s+([A-Z_][A-Z_]*)\s\s*(.*)$/\1("\2", \3, \4),/;
		s/"(.*".*)"/JJJqqJJJ\1JJJqqJJJ/;
		/JJJqqJJJ/ && s/"/\\"/g;
		s/JJJqqJJJ/"/g;
		s/ QQQjjQQQ / WITH /;
		print "$_\n";
	}
EOF
mv "$T-p" "$T"

#
# Now strip off spurious commas from lines like:
#	),
#    )
# since comma is a property separator, not terminator.  Sigh.
# Also correct for another problem - Linux ex's require the CTRL-V
# above; a real vi/ex doesn't; so we have to strip out any spurious
# CTRL-V characters if we're using a real ex:
#
sed 's///g' "$T" | awk '
	{
	    if (last_line != null)
	    {
		if ((last_line ~ /,$/) && ($0 ~ /^[ 	]*\)/))
		    print substr(last_line, 1, length(last_line)-1)
		else
		    print last_line
	    }
	    last_line = $0
	}

END	{
	    if (last_line != null)
	    {
		if (last_line ~ /,$/)
		    print substr(last_line, 1, length(last_line)-1)
		else
		    print last_line
	    }
	}
' > "$NEW_MENU.new" || exit 1

rm "$T"

#
# Now install it.
#
cd "$NEW_DIR"
if [ -s "$NEW_NAME" ]
then
    mv "$NEW_MENU" "$NEW_MENU.sav"
fi
mv "$NEW_MENU.new" "$NEW_MENU" || (echo "$MYNAME: can't rename $NEW_MENU.new to $NEW_MENU" >&2 && exit 1)
