/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.basic.BasicIconFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicInternalFrameTitlePane
extends JComponent {
    protected static final String CLOSE_CMD = "Close";
    protected static final String ICONIFY_CMD = "Minimize";
    protected static final String MAXIMIZE_CMD = "Maximize";
    protected static final String MOVE_CMD = "Move";
    protected static final String RESTORE_CMD = "Restore";
    protected static final String SIZE_CMD = "Size";
    protected Action closeAction;
    protected Action iconifyAction;
    protected Action maximizeAction;
    protected Action moveAction;
    protected Action restoreAction;
    protected Action sizeAction;
    protected JButton closeButton;
    protected JButton iconButton;
    protected JButton maxButton;
    protected Icon minIcon;
    protected Icon maxIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected JInternalFrame frame;
    protected JMenuBar menuBar;
    protected JMenu windowMenu;
    protected Color notSelectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color selectedTextColor;
    protected Color selectedTitleColor;
    protected PropertyChangeListener propertyChangeListener;
    transient JLabel title;

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.assembleSystemMenu();
        this.createButtons();
        this.setButtonIcons();
        this.addSubComponents();
        this.enableActions();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.closeButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
    }

    protected void createActions() {
        this.closeAction = new CloseAction();
        this.closeAction.putValue("ActionCommandKey", CLOSE_CMD);
        this.iconifyAction = new IconifyAction();
        this.iconifyAction.putValue("ActionCommandKey", ICONIFY_CMD);
        this.maximizeAction = new MaximizeAction();
        this.maximizeAction.putValue("ActionCommandKey", MAXIMIZE_CMD);
        this.sizeAction = new SizeAction();
        this.sizeAction.putValue("ActionCommandKey", SIZE_CMD);
        this.restoreAction = new RestoreAction();
        this.restoreAction.putValue("ActionCommandKey", RESTORE_CMD);
        this.moveAction = new MoveAction();
        this.moveAction.putValue("ActionCommandKey", MOVE_CMD);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.title.setFont(defaults.getFont("InternalFrame.titleFont"));
        this.selectedTextColor = defaults.getColor("InternalFrame.activeTitleForeground");
        this.selectedTitleColor = defaults.getColor("InternalFrame.activeTitleBackground");
        this.notSelectedTextColor = defaults.getColor("InternalFrame.inactiveTitleForeground");
        this.notSelectedTitleColor = defaults.getColor("InternalFrame.inactiveTitleBackground");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    }

    protected void uninstallDefaults() {
        this.setFont(null);
        this.selectedTextColor = null;
        this.selectedTitleColor = null;
        this.notSelectedTextColor = null;
        this.notSelectedTitleColor = null;
        this.closeIcon = null;
        this.iconIcon = null;
        this.maxIcon = null;
    }

    protected void createButtons() {
        this.closeButton = new PaneButton(this.closeAction);
        this.closeButton.setText(null);
        if (!this.frame.isClosable()) {
            this.closeButton.setVisible(false);
        }
        this.iconButton = new PaneButton(this.iconifyAction);
        this.iconButton.setText(null);
        if (!this.frame.isIconifiable()) {
            this.iconButton.setVisible(false);
        }
        this.maxButton = new PaneButton(this.maximizeAction);
        this.maxButton.setText(null);
        if (!this.frame.isMaximizable()) {
            this.maxButton.setVisible(false);
        }
    }

    protected void setButtonIcons() {
        if (this.closeIcon != null) {
            this.closeButton.setIcon(this.closeIcon);
        }
        if (this.iconIcon != null) {
            this.iconButton.setIcon(this.iconIcon);
        }
        if (this.maxIcon != null) {
            this.maxButton.setIcon(this.maxIcon);
        }
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem tmp = new JMenuItem(RESTORE_CMD);
        tmp.addActionListener(this.restoreAction);
        tmp.setMnemonic(82);
        systemMenu.add(tmp);
        tmp = new JMenuItem(MOVE_CMD);
        tmp.addActionListener(this.moveAction);
        tmp.setMnemonic(77);
        systemMenu.add(tmp);
        tmp = new JMenuItem(SIZE_CMD);
        tmp.addActionListener(this.sizeAction);
        tmp.setMnemonic(83);
        systemMenu.add(tmp);
        tmp = new JMenuItem(ICONIFY_CMD);
        tmp.addActionListener(this.iconifyAction);
        tmp.setMnemonic(78);
        systemMenu.add(tmp);
        tmp = new JMenuItem(MAXIMIZE_CMD);
        tmp.addActionListener(this.maximizeAction);
        tmp.setMnemonic(88);
        systemMenu.add(tmp);
        systemMenu.addSeparator();
        tmp = new JMenuItem(CLOSE_CMD);
        tmp.addActionListener(this.closeAction);
        tmp.setMnemonic(67);
        systemMenu.add(tmp);
    }

    protected JMenuBar createSystemMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new SystemMenuBar();
        }
        this.menuBar.removeAll();
        return this.menuBar;
    }

    protected JMenu createSystemMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
        }
        this.windowMenu.removeAll();
        return this.windowMenu;
    }

    protected void showSystemMenu() {
        this.menuBar.getMenu(1).getPopupMenu().show();
    }

    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        if (this.frame.getTitle() != null && this.title != null) {
            Color saved = g.getColor();
            Font f = this.title.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics(f);
            if (this.frame.isSelected()) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            this.title.setText(this.getTitle(this.frame.getTitle(), fm, this.title.getBounds().width));
            SwingUtilities.paintComponent(g, this.title, null, this.title.getBounds());
            g.setColor(saved);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        Color saved = g.getColor();
        Dimension dims = this.getSize();
        Color bg = this.getBackground();
        bg = this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor;
        g.setColor(bg);
        g.fillRect(0, 0, dims.width, dims.height);
        g.setColor(saved);
    }

    protected String getTitle(String text, FontMetrics fm, int availableWidth) {
        Rectangle vr = new Rectangle(0, 0, availableWidth, fm.getHeight());
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        String value = SwingUtilities.layoutCompoundLabel(this, fm, text, null, 0, 2, 0, 2, vr, ir, tr, 0);
        return value;
    }

    protected void postClosingEvent(JInternalFrame frame) {
    }

    protected void enableActions() {
        this.closeAction.setEnabled(this.frame.isClosable());
        this.iconifyAction.setEnabled(this.frame.isIconifiable());
        this.maximizeAction.setEnabled(this.frame.isMaximizable());
        this.restoreAction.setEnabled(this.frame.isMaximum());
        this.sizeAction.setEnabled(this.frame.isResizable());
        this.moveAction.setEnabled(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private final /* synthetic */ void this() {
        this.minIcon = BasicIconFactory.createEmptyFrameIcon();
        this.maxIcon = BasicIconFactory.createEmptyFrameIcon();
        this.iconIcon = BasicIconFactory.createEmptyFrameIcon();
    }

    public BasicInternalFrameTitlePane(JInternalFrame f) {
        this.this();
        this.frame = f;
        this.setLayout(this.createLayout());
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.title.setHorizontalTextPosition(2);
        this.title.setOpaque(false);
        this.setOpaque(true);
        this.setBackground(Color.LIGHT_GRAY);
        this.setOpaque(true);
        this.installTitlePane();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public CloseAction() {
            super(BasicInternalFrameTitlePane.CLOSE_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class IconifyAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable() && !BasicInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public IconifyAction() {
            super(BasicInternalFrameTitlePane.ICONIFY_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MaximizeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            try {
                if (BasicInternalFrameTitlePane.this.frame.isMaximizable() && !BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    BasicInternalFrameTitlePane.this.frame.setMaximum(true);
                } else if (BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public MaximizeAction() {
            super(BasicInternalFrameTitlePane.MAXIMIZE_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SizeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public SizeAction() {
            super(BasicInternalFrameTitlePane.SIZE_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class RestoreAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public RestoreAction() {
            super(BasicInternalFrameTitlePane.RESTORE_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MoveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
        }

        public MoveAction() {
            super(BasicInternalFrameTitlePane.MOVE_CMD);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PaneButton
    extends JButton {
        public boolean isFocusable() {
            return false;
        }

        public PaneButton(Action a) {
            super(a);
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTransversable() {
            return true;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(Graphics g) {
            Icon frameIcon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (frameIcon == null) {
                frameIcon = BasicDesktopIconUI.defaultIcon;
            }
            frameIcon.paintIcon(this, g, 0, 0);
        }

        public void requestFocus() {
            super.requestFocus();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("closable")) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    BasicInternalFrameTitlePane.this.closeButton.setVisible(true);
                } else {
                    BasicInternalFrameTitlePane.this.closeButton.setVisible(false);
                }
            } else if (propName.equals("iconifiable")) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    BasicInternalFrameTitlePane.this.iconButton.setVisible(true);
                } else {
                    BasicInternalFrameTitlePane.this.iconButton.setVisible(false);
                }
            } else if (propName.equals("maximizable")) {
                if (evt.getNewValue().equals(Boolean.TRUE)) {
                    BasicInternalFrameTitlePane.this.maxButton.setVisible(true);
                } else {
                    BasicInternalFrameTitlePane.this.maxButton.setVisible(false);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            Dimension size = c.getSize();
            Insets insets = c.getInsets();
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            Dimension menupref = BasicInternalFrameTitlePane.this.menuBar.getPreferredSize();
            BasicInternalFrameTitlePane.this.menuBar.setBounds(insets.left, insets.top, menupref.width, height);
            int loc = width + insets.left - 1;
            int top = insets.top + 1;
            int buttonHeight = height - 4;
            if (BasicInternalFrameTitlePane.this.closeButton.isVisible()) {
                buttonWidth = BasicInternalFrameTitlePane.this.closeIcon.getIconWidth();
                BasicInternalFrameTitlePane.this.closeButton.setBounds(loc -= buttonWidth + 2, top, buttonWidth, buttonHeight);
            }
            if (BasicInternalFrameTitlePane.this.maxButton.isVisible()) {
                buttonWidth = BasicInternalFrameTitlePane.this.maxIcon.getIconWidth();
                BasicInternalFrameTitlePane.this.maxButton.setBounds(loc -= buttonWidth + 2, top, buttonWidth, buttonHeight);
            }
            if (BasicInternalFrameTitlePane.this.iconButton.isVisible()) {
                buttonWidth = BasicInternalFrameTitlePane.this.iconIcon.getIconWidth();
                BasicInternalFrameTitlePane.this.iconButton.setBounds(loc -= buttonWidth + 2, top, buttonWidth, buttonHeight);
            }
            if (BasicInternalFrameTitlePane.this.title != null) {
                BasicInternalFrameTitlePane.this.title.setBounds(insets.left + menupref.width, insets.top, loc - menupref.width - insets.left, height);
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(22, 18);
        }

        public void removeLayoutComponent(Component c) {
        }
    }
}

